using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public delegate bool UserGraphLoadFunction4( IStream Src , out BASEIMAGE Image ) ;


		/// <summary> o^ĂeOtBbN[_֐Aalof[^ GraphImagef[^\z </summary>
		/// <param name="BmpInfo"> BITMAPINFO ** </param>
		public static void CreateGraphImageOrDIBGraph( string FileName , IntPtr DataImage , LOADIMAGE_TYPE DataImageSize , int DataImageType , bool BmpFlag , bool ReverseFlag , out BaseImage Image , out IntPtr BmpInfo , out IntPtr GraphData )
		{
			lock( locker )
			{
				BASEIMAGE Image_ ;
				int result = dx_CreateGraphImageOrDIBGraph( FileName , DataImage , DataImageSize , DataImageType , BmpFlag , ReverseFlag , out Image_ , out BmpInfo , out GraphData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				Image = new BaseImage( Image_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphImageOrDIBGraph( string FileName , IntPtr DataImage , LOADIMAGE_TYPE DataImageSize , int DataImageType , bool BmpFlag , bool ReverseFlag , out BASEIMAGE Image , out IntPtr BmpInfo , out IntPtr GraphData ) ;


		/// <summary> ėpǂݍݏɂOtBbNC[W\z֐( 0:  -1:s ) </summary>
		public static void CreateBaseImageType2( IStream Src , out BaseImage Dest )
		{
			CreateGraphImageType2( Src , out Dest ) ;
		}

		/// <summary> ėpǂݍݏɂOtBbNC[W\z֐( 0:  -1:s ) </summary>
		public static void CreateGraphImageType2( IStream Src , out BaseImage Dest )
		{
			lock( locker )
			{
				STREAMDATA Src_ = new STREAMDATA( Src ) ;
				BASEIMAGE Dest_ ;
				int result = dx_CreateGraphImageType2( ref Src_ , out Dest_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				Dest = new BaseImage( Dest_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphImageType2( [ In ] ref STREAMDATA Src , out BASEIMAGE Dest ) ;


		/// <summary> tJ[`BITMAPINFO\̂쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void CreateBmpInfo( IntPtr BmpInfo , int Width , int Height , int Pitch , IntPtr SrcGrData , out IntPtr DestGrData )
		{
			lock( locker )
			{
				int result = dx_CreateBmpInfo( BmpInfo , Width , Height , Pitch , SrcGrData , out DestGrData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateBmpInfo( IntPtr BmpInfo , int Width , int Height , int Pitch , IntPtr SrcGrData , out IntPtr DestGrData ) ;


		/// <summary> chaOtBbN쐬(o[WQ) </summary>
		/// <returns> HBITMAP </returns>
		public static IntPtr CreateDIBGraphVer2( string FileName , IntPtr MemImage , int MemImageSize , LOADIMAGE_TYPE ImageType , bool ReverseFlag , COLORDATA SrcColor )
		{
			lock( locker )
			{
				IntPtr result = dx_CreateDIBGraphVer2( FileName , MemImage , MemImageSize , ImageType , ReverseFlag , ref SrcColor ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_CreateDIBGraphVer2( string FileName , IntPtr MemImage , int MemImageSize , LOADIMAGE_TYPE ImageType , bool ReverseFlag , [ In ] ref COLORDATA SrcColor ) ;


		/// <summary> chaOtBbN쐬 </summary>
		/// <param name="RGBBmp"> HBITMAP * </param>
		/// <param name="AlphaBmp"> HBITMAP * </param>
		public static void CreateDIBGraphVer2_plus_Alpha( string FileName , IntPtr MemImage , int MemImageSize , IntPtr AlphaImage , int AlphaImageSize , LOADIMAGE_TYPE ImageType , out IntPtr RGBBmp , out IntPtr AlphaBmp , bool ReverseFlag , COLORDATA SrcColor )
		{
			lock( locker )
			{
				int result = dx_CreateDIBGraphVer2_plus_Alpha( FileName , MemImage , MemImageSize , AlphaImage , AlphaImageSize , ImageType , out RGBBmp , out AlphaBmp , ReverseFlag , ref SrcColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDIBGraphVer2_plus_Alpha( string FileName , IntPtr MemImage , int MemImageSize , IntPtr AlphaImage , int AlphaImageSize , LOADIMAGE_TYPE ImageType , out IntPtr RGBBmp , out IntPtr AlphaBmp , bool ReverseFlag , [ In ] ref COLORDATA SrcColor ) ;


		/// <summary> BASEIMAGE \̂̉摜񂩂w̍W̃tJ[R[h擾 </summary>
		public static int GetGraphImageFullColorCode( BaseImage GraphImage , int x , int y )
		{
			lock( locker )
			{
				int result = dx_GetGraphImageFullColorCode( ref GraphImage.buffer , x , y ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetGraphImageFullColorCode( [ In ] ref BASEIMAGE GraphImage , int x , int y ) ;


		/// <summary> eOtBbNf[^OtBbNC[Wf[^ƃAt@}bvpC[Wf[^\z </summary>
		public static void CreateGraphImage_plus_Alpha( string FileName , IntPtr RgbImage , int RgbImageSize , LOADIMAGE_TYPE RgbImageType , IntPtr AlphaImage , int AlphaImageSize , LOADIMAGE_TYPE AlphaImageType , out BaseImage RgbGraphImage , out BaseImage AlphaGraphImage , bool ReverseFlag )
		{
			lock( locker )
			{
				BASEIMAGE RgbGraphImage_ ;
				BASEIMAGE AlphaGraphImage_ ;
				int result = dx_CreateGraphImage_plus_Alpha( FileName , RgbImage , RgbImageSize , RgbImageType , AlphaImage , AlphaImageSize , AlphaImageType , out RgbGraphImage_ , out AlphaGraphImage_ , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				RgbGraphImage = new BaseImage( RgbGraphImage_ ) ;
				AlphaGraphImage = new BaseImage( AlphaGraphImage_ ) ;
			}
		}

		/// <summary> eOtBbNf[^OtBbNC[Wf[^ƃAt@}bvpC[Wf[^\z </summary>
		public static void CreateBaseImage_plus_Alpha( string FileName , IntPtr RgbImage , int RgbImageSize , LOADIMAGE_TYPE RgbImageType , IntPtr AlphaImage , int AlphaImageSize , LOADIMAGE_TYPE AlphaImageType , out BaseImage RgbGraphImage , out BaseImage AlphaGraphImage , bool ReverseFlag )
		{
			CreateGraphImage_plus_Alpha( FileName , RgbImage , RgbImageSize , RgbImageType , AlphaImage , AlphaImageSize , AlphaImageType , out RgbGraphImage , out AlphaGraphImage , ReverseFlag ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphImage_plus_Alpha( string FileName , IntPtr RgbImage , int RgbImageSize , LOADIMAGE_TYPE RgbImageType , IntPtr AlphaImage , int AlphaImageSize , LOADIMAGE_TYPE AlphaImageType , out BASEIMAGE RgbGraphImage , out BASEIMAGE AlphaGraphImage , bool ReverseFlag ) ;


		/// <summary> w GraphImage E] </summary>
		public static void ReverseGraphImage( BaseImage GraphImage )
		{
			lock( locker )
			{
				int result = dx_ReverseGraphImage( ref GraphImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReverseGraphImage( [ In , Out ] ref BASEIMAGE GraphImage ) ;


		/// <summary> alo  GraphImage ɕϊ( Ret 0:I  1:Rs[s  -1:G[ ) </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void ConvBitmapToGraphImage( IntPtr BmpInfo , IntPtr GraphData , out BaseImage GraphImage , bool CopyFlag )
		{
			lock( locker )
			{
				BASEIMAGE GraphImage_ ;
				int result = dx_ConvBitmapToGraphImage( BmpInfo , GraphData , out GraphImage_ , CopyFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				GraphImage = new BaseImage( GraphImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ConvBitmapToGraphImage( IntPtr BmpInfo , IntPtr GraphData , out BASEIMAGE GraphImage , bool CopyFlag ) ;


		/// <summary> GraphImage  alo ɕϊ(At@f[^͂Ă)( Ret 0:I  1:Rs[s  -1:G[ ) </summary>
		public static void ConvGraphImageToBitmap( BaseImage GraphImage , out IntPtr BmpInfo , out IntPtr GraphData , bool CopyFlag )
		{
			ConvGraphImageToBitmap( GraphImage , out BmpInfo , out GraphData , CopyFlag , true ) ;
		}

		/// <summary> GraphImage  alo ɕϊ(At@f[^͂Ă)( Ret 0:I  1:Rs[s  -1:G[ ) </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void ConvGraphImageToBitmap( BaseImage GraphImage , out IntPtr BmpInfo , out IntPtr GraphData , bool CopyFlag , bool FullColorConv )
		{
			lock( locker )
			{
				BmpInfo = DxAlloc( 10 * 4 + 256 * 4 ) ;
				int result = dx_ConvGraphImageToBitmap( ref GraphImage.buffer , BmpInfo , out GraphData , CopyFlag , FullColorConv ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ConvGraphImageToBitmap( [ In ] ref BASEIMAGE GraphImage , IntPtr BmpInfo , out IntPtr GraphData , bool CopyFlag , bool FullColorConv ) ;


		/// <summary> chaOtBbN쐬 </summary>
		/// <returns> HBITMAP </returns>
		public static IntPtr CreateDIBGraph( string FileName , bool ReverseFlag , COLORDATA SrcColor )
		{
			lock( locker )
			{
				IntPtr result = dx_CreateDIBGraph( FileName , ReverseFlag , ref SrcColor ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_CreateDIBGraph( string FileName , bool ReverseFlag , [ In ] ref COLORDATA SrcColor ) ;


		/// <summary> chaOtBbNC[W쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <returns> HBITMAP </returns>
		public static IntPtr CreateDIBGraphToMem( IntPtr BmpInfo , IntPtr GraphData , bool ReverseFlag , COLORDATA SrcColor )
		{
			lock( locker )
			{
				IntPtr result = dx_CreateDIBGraphToMem( BmpInfo , GraphData , ReverseFlag , ref SrcColor ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_CreateDIBGraphToMem( IntPtr BmpInfo , IntPtr GraphData , bool ReverseFlag , [ In ] ref COLORDATA SrcColor ) ;


		/// <summary> t@CchaOtBbNƃ}XNOtBbN쐬 </summary>
		/// <param name="RGBBmp"> HBITMAP * </param>
		/// <param name="AlphaBmp"> HBITMAP * </param>
		public static void CreateDIBGraph_plus_Alpha( string FileName , out IntPtr RGBBmp , out IntPtr AlphaBmp )
		{
			CreateDIBGraph_plus_Alpha( FileName , out RGBBmp , out AlphaBmp , false ) ;
		}

		/// <summary> t@CchaOtBbNƃ}XNOtBbN쐬 </summary>
		/// <param name="RGBBmp"> HBITMAP * </param>
		/// <param name="AlphaBmp"> HBITMAP * </param>
		public static void CreateDIBGraph_plus_Alpha( string FileName , out IntPtr RGBBmp , out IntPtr AlphaBmp , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_CreateDIBGraph_plus_Alpha( FileName , out RGBBmp , out AlphaBmp , ReverseFlag , IntPtr.Zero ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> t@CchaOtBbNƃ}XNOtBbN쐬 </summary>
		/// <param name="RGBBmp"> HBITMAP * </param>
		/// <param name="AlphaBmp"> HBITMAP * </param>
		public static void CreateDIBGraph_plus_Alpha( string FileName , out IntPtr RGBBmp , out IntPtr AlphaBmp , bool ReverseFlag , COLORDATA SrcColor )
		{
			lock( locker )
			{
				int result = dx_CreateDIBGraph_plus_Alpha( FileName , out RGBBmp , out AlphaBmp , ReverseFlag , ref SrcColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDIBGraph_plus_Alpha( string FileName , out IntPtr RGBBmp , out IntPtr AlphaBmp , bool ReverseFlag , IntPtr SrcColor ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDIBGraph_plus_Alpha( string FileName , out IntPtr RGBBmp , out IntPtr AlphaBmp , bool ReverseFlag , [ In ] ref COLORDATA SrcColor ) ;



		/// <summary> [U[`̃OtBbN[h֐Ver4o^ </summary>
		public static void AddUserGraphLoadFunction4( UserGraphLoadFunction4 UserLoadFunc )
		{
			lock( locker )
			{
				USERGRAPHLOADFUNCTION4 UserLoadFunc_ = delegate( ref STREAMDATA Src , out BASEIMAGE Image )
				{
					return UserLoadFunc( new StreamData( Src ) , out Image ) ? 0 : -1 ;
				} ;
				UserGraphLoadFunction4s.Add( UserLoadFunc , UserLoadFunc_ ) ;
				int result = dx_AddUserGraphLoadFunction4( UserLoadFunc_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddUserGraphLoadFunction4( [ MarshalAs( UnmanagedType.FunctionPtr ) ] USERGRAPHLOADFUNCTION4 UserLoadFunc ) ;


		/// <summary> [U[`̃OtBbN[h֐Ver4o^疕 </summary>
		public static void SubUserGraphLoadFunction4( UserGraphLoadFunction4 UserLoadFunc )
		{
			lock( locker )
			{
				int result = dx_SubUserGraphLoadFunction4( UserLoadFunc ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				UserGraphLoadFunction4s.Remove( UserLoadFunc ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SubUserGraphLoadFunction4( [ MarshalAs( UnmanagedType.FunctionPtr ) ] UserGraphLoadFunction4 UserLoadFunc ) ;


		private static SortedDictionary< UserGraphLoadFunction4 , USERGRAPHLOADFUNCTION4 > UserGraphLoadFunction4s = new SortedDictionary< UserGraphLoadFunction4 , USERGRAPHLOADFUNCTION4 >() ;

	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate int USERGRAPHLOADFUNCTION4( [ In ] ref STREAMDATA Src , out BASEIMAGE Image ) ;


		/// <summary> ǂݍ݃[`gۂ̃tOZbg </summary>
		public static void SetUseFastLoadFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseFastLoadFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseFastLoadFlag( bool Flag ) ;


		/// <summary> OtBbNF̉摜򉻊ɘa[h̎擾 </summary>
		public static DX_SHAVEDMODE GetGraphDataShavedMode()
		{
			lock( locker )
			{
				DX_SHAVEDMODE result = dx_GetGraphDataShavedMode() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_SHAVEDMODE dx_GetGraphDataShavedMode() ;


		/// <summary> OtBbNF̉摜򉻊ɘa[h̕ύX </summary>
		public static void SetGraphDataShavedMode( DX_SHAVEDMODE ShavedMode )
		{
			lock( locker )
			{
				int result = dx_SetGraphDataShavedMode( ShavedMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetGraphDataShavedMode( DX_SHAVEDMODE ShavedMode ) ;


		/// <summary> \tgEGAňC[W̓ǂݍ( -1:G[  -1ȊO:C[Wnh ) </summary>
		public static SoftImage LoadSoftImage( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadSoftImage( FileName ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoftImage( string FileName ) ;


		/// <summary> \tgEGAňC[W̃̓ǂݍ( -1:G[  -1ȊO:C[Wnh ) </summary>
		public static SoftImage LoadSoftImageToMem( IntPtr FileImage , int FileImageSize )
		{
			lock( locker )
			{
				int result = dx_LoadSoftImageToMem( FileImage , FileImageSize ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadSoftImageToMem( IntPtr FileImage , int FileImageSize ) ;


		/// <summary> \tgEGAňC[W̍쐬( -1:G[  -1ȊO:C[Wnh ) </summary>
		public static SoftImage MakeSoftImage( int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_MakeSoftImage( SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeSoftImage( int SizeX , int SizeY ) ;


		/// <summary> \tgEGAňC[W̍쐬( RGBA8 J[ ) </summary>
		public static SoftImage MakeARGB8ColorSoftImage( int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_MakeARGB8ColorSoftImage( SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeARGB8ColorSoftImage( int SizeX , int SizeY ) ;


		/// <summary> \tgEGAňC[W̍쐬( XRGB8 J[ ) </summary>
		public static SoftImage MakeXRGB8ColorSoftImage( int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_MakeXRGB8ColorSoftImage( SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeXRGB8ColorSoftImage( int SizeX , int SizeY ) ;


		/// <summary> \tgEGAňC[W̍쐬( RGB8 J[ ) </summary>
		public static SoftImage MakeRGB8ColorSoftImage( int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_MakeRGB8ColorSoftImage( SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeRGB8ColorSoftImage( int SizeX , int SizeY ) ;


		/// <summary> \tgEGAňC[W̍쐬( pbgQTUF J[ ) </summary>
		public static SoftImage MakePAL8ColorSoftImage( int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_MakePAL8ColorSoftImage( SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return SoftImage.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakePAL8ColorSoftImage( int SizeX , int SizeY ) ;


		/// <summary> \tgEGAňC[W̃TCY擾 </summary>
		public static void GetSoftImageSize( SoftImage SIHandle , out int Width , out int Height )
		{
			lock( locker )
			{
				int result = dx_GetSoftImageSize( SoftImage.ToHandle( SIHandle ) , out Width , out Height ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetSoftImageSize( int SIHandle , out int Width , out int Height ) ;


		/// <summary> \tgEGAňC[Wpbg摜ǂ擾( TRUE:pbg摜  FALSE:pbg摜Ȃ ) </summary>
		public static bool CheckPaletteSoftImage( SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_CheckPaletteSoftImage( SoftImage.ToHandle( SIHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckPaletteSoftImage( int SIHandle ) ;


		/// <summary> \tgEGAňC[W̃tH[}bgɃvf邩ǂ擾( TRUE:  FALSE:Ȃ ) </summary>
		public static bool CheckAlphaSoftImage( SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_CheckAlphaSoftImage( SoftImage.ToHandle( SIHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CheckAlphaSoftImage( int SIHandle ) ;


		/// <summary> `Ώۂ̉ʂẅ̃OtBbN\tgEGAňC[Wɓ] </summary>
		public static void GetDrawScreenSoftImage( int x1 , int y1 , int x2 , int y2 , SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_GetDrawScreenSoftImage( x1 , y1 , x2 , y2 , SoftImage.ToHandle( SIHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawScreenSoftImage( int x1 , int y1 , int x2 , int y2 , int SIHandle ) ;


		/// <summary> \tgEGAňC[Wgp UpdateLayerdWindow s( C[W̓EChẼNCAg̈ƓTCYłKv܂ ) </summary>
		public static void UpdateLayerdWindowForSoftImage( SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_UpdateLayerdWindowForSoftImage( SoftImage.ToHandle( SIHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_UpdateLayerdWindowForSoftImage( int SIHandle ) ;


		/// <summary> \tgEGAňC[WwFœhԂ(eFvf͂O`QTT) </summary>
		public static void FillSoftImage( SoftImage SIHandle , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_FillSoftImage( SoftImage.ToHandle( SIHandle ) , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FillSoftImage( int SIHandle , int r , int g , int b , int a ) ;


		/// <summary> \tgEGAňC[W̃pbg擾(eFvf͂O`QTT) </summary>
		public static void GetPaletteSoftImage( SoftImage SIHandle , int PaletteNo , out int r , out int g , out int b , out int a )
		{
			lock( locker )
			{
				int result = dx_GetPaletteSoftImage( SoftImage.ToHandle( SIHandle ) , PaletteNo , out r , out g , out b , out a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPaletteSoftImage( int SIHandle , int PaletteNo , out int r , out int g , out int b , out int a ) ;


		/// <summary> \tgEGAňC[W̃pbgZbg(eFvf͂O`QTT) </summary>
		public static void SetPaletteSoftImage( SoftImage SIHandle , int PaletteNo , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_SetPaletteSoftImage( SoftImage.ToHandle( SIHandle ) , PaletteNo , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPaletteSoftImage( int SIHandle , int PaletteNo , int r , int g , int b , int a ) ;


		/// <summary> \tgEGAňC[W̎wWɃhbg`悷(pbg摜pALl͂O`QTT) </summary>
		public static void DrawPixelPalCodeSoftImage( SoftImage SIHandle , int x , int y , int PalNo )
		{
			lock( locker )
			{
				int result = dx_DrawPixelPalCodeSoftImage( SoftImage.ToHandle( SIHandle ) , x , y , PalNo ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawPixelPalCodeSoftImage( int SIHandle , int x , int y , int PalNo ) ;


		/// <summary> \tgEGAňC[W̎wW̐FR[h擾(pbg摜pA߂l͂O`QTT) </summary>
		public static int GetPixelPalCodeSoftImage( SoftImage SIHandle , int x , int y )
		{
			lock( locker )
			{
				int result = dx_GetPixelPalCodeSoftImage( SoftImage.ToHandle( SIHandle ) , x , y ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPixelPalCodeSoftImage( int SIHandle , int x , int y ) ;


		/// <summary> \tgEGAňC[W̎C[Wi[Ă郁̈̐擪AhX擾 </summary>
		public static IntPtr GetImageAddressSoftImage( SoftImage SIHandle )
		{
			lock( locker )
			{
				IntPtr result = dx_GetImageAddressSoftImage( SoftImage.ToHandle( SIHandle ) ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetImageAddressSoftImage( int SIHandle ) ;


		/// <summary> \tgEGAňC[W̎wWɃhbg`悷(eFvf͂O`QTT) </summary>
		public static void DrawPixelSoftImage( SoftImage SIHandle , int x , int y , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_DrawPixelSoftImage( SoftImage.ToHandle( SIHandle ) , x , y , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawPixelSoftImage( int SIHandle , int x , int y , int r , int g , int b , int a ) ;


		/// <summary> \tgEGAňC[W̎wW̐F擾(eFvf͂O`QTT) </summary>
		public static void GetPixelSoftImage( SoftImage SIHandle , int x , int y , out int r , out int g , out int b , out int a )
		{
			lock( locker )
			{
				int result = dx_GetPixelSoftImage( SoftImage.ToHandle( SIHandle ) , x , y , out r , out g , out b , out a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPixelSoftImage( int SIHandle , int x , int y , out int r , out int g , out int b , out int a ) ;


		/// <summary> \tgEGAňC[W̎wWɐ`悷(eFvf͂O`QTT) </summary>
		public static void DrawLineSoftImage( SoftImage SIHandle , int x1 , int y1 , int x2 , int y2 , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_DrawLineSoftImage( SoftImage.ToHandle( SIHandle ) , x1 , y1 , x2 , y2 , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawLineSoftImage( int SIHandle , int x1 , int y1 , int x2 , int y2 , int r , int g , int b , int a ) ;


		/// <summary> \tgEGAňC[Wʂ̃C[Wɓ] </summary>
		public static void BltSoftImage( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , SoftImage SrcSIHandle , int DestX , int DestY , SoftImage DestSIHandle )
		{
			lock( locker )
			{
				int result = dx_BltSoftImage( SrcX , SrcY , SrcSizeX , SrcSizeY , SoftImage.ToHandle( SrcSIHandle ) , DestX , DestY , SoftImage.ToHandle( DestSIHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltSoftImage( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int SrcSIHandle , int DestX , int DestY , int DestSIHandle ) ;


		/// <summary> \tgEGAňC[W𓧉ߐFtœ] </summary>
		public static void BltSoftImageWithTransColor( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , SoftImage SrcSIHandle , int DestX , int DestY , SoftImage DestSIHandle , int Tr , int Tg , int Tb , int Ta )
		{
			lock( locker )
			{
				int result = dx_BltSoftImageWithTransColor( SrcX , SrcY , SrcSizeX , SrcSizeY , SoftImage.ToHandle( SrcSIHandle ) , DestX , DestY , SoftImage.ToHandle( DestSIHandle ) , Tr , Tg , Tb , Ta ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltSoftImageWithTransColor( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int SrcSIHandle , int DestX , int DestY , int DestSIHandle , int Tr , int Tg , int Tb , int Ta ) ;


		/// <summary> \tgEGAňC[WAt@l̃uhlœ]( Opacity ͓x : 0( S ) ` 255( Ss ) )( o͐悪 ARGB8 `ȊȌꍇ̓G[ɂȂ܂ ) </summary>
		public static void BltSoftImageWithAlphaBlend( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , SoftImage SrcSIHandle , int DestX , int DestY , SoftImage DestSIHandle )
		{
			BltSoftImageWithAlphaBlend( SrcX , SrcY , SrcSizeX , SrcSizeY , SrcSIHandle , DestX , DestY , DestSIHandle , 255 ) ;
		}

		/// <summary> \tgEGAňC[WAt@l̃uhlœ]( Opacity ͓x : 0( S ) ` 255( Ss ) )( o͐悪 ARGB8 `ȊȌꍇ̓G[ɂȂ܂ ) </summary>
		public static void BltSoftImageWithAlphaBlend( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , SoftImage SrcSIHandle , int DestX , int DestY , SoftImage DestSIHandle , int Opacity )
		{
			lock( locker )
			{
				int result = dx_BltSoftImageWithAlphaBlend( SrcX , SrcY , SrcSizeX , SrcSizeY , SoftImage.ToHandle( SrcSIHandle ) , DestX , DestY , SoftImage.ToHandle( DestSIHandle ) , Opacity ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltSoftImageWithAlphaBlend( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int SrcSIHandle , int DestX , int DestY , int DestSIHandle , int Opacity ) ;


		/// <summary> \tgEGAňC[WɕC[W] </summary>
		public static void BltStringSoftImage( int x , int y , string StrData , SoftImage DestSIHandle )
		{
			BltStringSoftImage( x , y , StrData , DestSIHandle , null ) ;
		}

		/// <summary> \tgEGAňC[WɕC[W] </summary>
		public static void BltStringSoftImage( int x , int y , string StrData , SoftImage DestSIHandle , SoftImage DestEdgeSIHandle )
		{
			BltStringSoftImage( x , y , StrData , DestSIHandle , DestEdgeSIHandle , false ) ;
		}

		/// <summary> \tgEGAňC[WɕC[W] </summary>
		public static void BltStringSoftImage( int x , int y , string StrData , SoftImage DestSIHandle , SoftImage DestEdgeSIHandle , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_BltStringSoftImage( x , y , StrData , SoftImage.ToHandle( DestSIHandle ) , SoftImage.ToHandle( DestEdgeSIHandle ) , VerticalFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltStringSoftImage( int x , int y , string StrData , int DestSIHandle , int DestEdgeSIHandle , bool VerticalFlag ) ;


		/// <summary> \tgEGAňC[WɕC[W]( tHgnhgp ) </summary>
		/// <param name="DestEdgeSIHandle"> KvȂꍇ -1 </param>
		public static void BltStringSoftImageToHandle( int x , int y , string StrData , SoftImage DestSIHandle , SoftImage DestEdgeSIHandle , Font FontHandle )
		{
			BltStringSoftImageToHandle( x , y , StrData , DestSIHandle , DestEdgeSIHandle , FontHandle , false ) ;
		}

		/// <summary> \tgEGAňC[WɕC[W]( tHgnhgp ) </summary>
		/// <param name="DestEdgeSIHandle"> KvȂꍇ -1 </param>
		public static void BltStringSoftImageToHandle( int x , int y , string StrData , SoftImage DestSIHandle , SoftImage DestEdgeSIHandle , Font FontHandle , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_BltStringSoftImageToHandle( x , y , StrData , SoftImage.ToHandle( DestSIHandle ) , SoftImage.ToHandle( DestEdgeSIHandle ) , Font.ToHandle( FontHandle ) , VerticalFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltStringSoftImageToHandle( int x , int y , string StrData , int DestSIHandle , int DestEdgeSIHandle , int FontHandle , bool VerticalFlag ) ;


		/// <summary> \tgEGAňC[Wʂɕ`悷 </summary>
		public static void DrawSoftImage( int x , int y , SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_DrawSoftImage( x , y , SoftImage.ToHandle( SIHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawSoftImage( int x , int y , int SIHandle ) ;


		/// <summary> \tgEGAňC[Walo摜t@CƂĕۑ </summary>
		public static void SaveSoftImageToBmp( string FilePath , SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_SaveSoftImageToBmp( FilePath , SoftImage.ToHandle( SIHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SaveSoftImageToBmp( string FilePath , int SIHandle ) ;


		/// <summary> \tgEGAňC[Womf摜t@CƂĕۑ CompressionLevel = kAl傫قǍkׁAO͖k ,0`9 </summary>
		public static void SaveSoftImageToPng( string FilePath , SoftImage SIHandle , int CompressionLevel )
		{
			lock( locker )
			{
				int result = dx_SaveSoftImageToPng( FilePath , SoftImage.ToHandle( SIHandle ) , CompressionLevel ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SaveSoftImageToPng( string FilePath , int SIHandle , int CompressionLevel ) ;


		/// <summary> \tgEGAňC[Wiodf摜t@CƂĕۑ Quality = 掿Al傫قǒሳk掿 ,0`100  </summary>
		public static void SaveSoftImageToJpeg( string FilePath , SoftImage SIHandle , int Quality , bool Sample2x1 )
		{
			lock( locker )
			{
				int result = dx_SaveSoftImageToJpeg( FilePath , SoftImage.ToHandle( SIHandle ) , Quality , Sample2x1 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SaveSoftImageToJpeg( string FilePath , int SIHandle , int Quality , bool Sample2x1 ) ;


		/// <summary> eOtBbNf[^{C[Wf[^\z </summary>
		/// <param name="DataType"> =LOADIMAGE_TYPE_FILE </param>
		public static void CreateBaseImage( string FileName , IntPtr FileImage , int FileImageSize , LOADIMAGE_TYPE DataType , out BaseImage BaseImage , bool ReverseFlag )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateBaseImage( FileName , FileImage , FileImageSize , DataType , out BaseImage_ , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateBaseImage( string FileName , IntPtr FileImage , int FileImageSize , LOADIMAGE_TYPE DataType , out BASEIMAGE BaseImage , bool ReverseFlag ) ;


		/// <summary> CreateBaseImage ̋ </summary>
		/// <param name="DataImageType"> =LOADIMAGE_TYPE_FILE </param>
		public static void CreateGraphImage( string FileName , IntPtr DataImage , int DataImageSize , LOADIMAGE_TYPE DataImageType , out BaseImage GraphImage , bool ReverseFlag )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateGraphImage( FileName , DataImage , DataImageSize , DataImageType , out BaseImage_ , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				GraphImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphImage( string FileName , IntPtr DataImage , int DataImageSize , LOADIMAGE_TYPE DataImageType , out BASEIMAGE GraphImage , bool ReverseFlag ) ;


		/// <summary> 摜t@C{C[Wf[^\z </summary>
		public static void CreateBaseImageToFile( string FileName , out BaseImage BaseImage , bool ReverseFlag )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateBaseImageToFile( FileName , out BaseImage_ , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

		/// <summary> 摜t@C{C[Wf[^\z </summary>
		public static void CreateBaseImageToFile( string FileName , out BaseImage BaseImage )
		{
			CreateBaseImageToFile( FileName , out BaseImage , false ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateBaseImageToFile( string FileName , out BASEIMAGE BaseImage , bool ReverseFlag ) ;


		/// <summary> ɓWJꂽ摜t@C{C[Wf[^\z </summary>
		public static void CreateBaseImageToMem( IntPtr FileImage , int FileImageSize , out BaseImage BaseImage , bool ReverseFlag )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateBaseImageToMem( FileImage , FileImageSize , out BaseImage_ , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

		/// <summary> ɓWJꂽ摜t@C{C[Wf[^\z </summary>
		public static void CreateBaseImageToMem( IntPtr FileImage , int FileImageSize , out BaseImage BaseImage )
		{
			CreateBaseImageToMem( FileImage , FileImageSize , out BaseImage , false ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateBaseImageToMem( IntPtr FileImage , int FileImageSize , out BASEIMAGE BaseImage , bool ReverseFlag ) ;


		/// <summary> `qfaWJ[̋̊{C[Wf[^쐬 </summary>
		public static void CreateARGB8ColorBaseImage( int SizeX , int SizeY , out BaseImage BaseImage )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateARGB8ColorBaseImage( SizeX , SizeY , out BaseImage_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateARGB8ColorBaseImage( int SizeX , int SizeY , out BASEIMAGE BaseImage ) ;


		/// <summary> wqfaWJ[̋̊{C[Wf[^쐬 </summary>
		public static void CreateXRGB8ColorBaseImage( int SizeX , int SizeY , out BaseImage BaseImage )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateXRGB8ColorBaseImage( SizeX , SizeY , out BaseImage_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateXRGB8ColorBaseImage( int SizeX , int SizeY , out BASEIMAGE BaseImage ) ;


		/// <summary> qfaWJ[̋̊{C[Wf[^쐬 </summary>
		public static void CreateRGB8ColorBaseImage( int SizeX , int SizeY , out BaseImage BaseImage )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateRGB8ColorBaseImage( SizeX , SizeY , out BaseImage_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateRGB8ColorBaseImage( int SizeX , int SizeY , out BASEIMAGE BaseImage ) ;


		/// <summary> pbgWrbgJ[̋̊{C[Wf[^쐬 </summary>
		public static void CreatePAL8ColorBaseImage( int SizeX , int SizeY , out BaseImage BaseImage )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreatePAL8ColorBaseImage( SizeX , SizeY , out BaseImage_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreatePAL8ColorBaseImage( int SizeX , int SizeY , out BASEIMAGE BaseImage ) ;


		/// <summary> w̃J[tH[}bg̊k̊{C[Wf[^쐬 </summary>
		public static void CreateColorDataBaseImage( int SizeX , int SizeY , COLORDATA ColorData , out BaseImage BaseImage )
		{
			lock( locker )
			{
				BASEIMAGE BaseImage_ ;
				int result = dx_CreateColorDataBaseImage( SizeX , SizeY , ref ColorData , out BaseImage_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				BaseImage = new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateColorDataBaseImage( int SizeX , int SizeY , [ In ] ref COLORDATA ColorData , out BASEIMAGE BaseImage ) ;


		/// <summary> DX_BASEIMAGE_FORMAT_NORMAL ȊǑ`̃C[Wf[^ DX_BASEIMAGE_FORMAT_NORMAL `̃C[Wɕϊ </summary>
		public static void ConvertNormalFormatBaseImage( BaseImage BaseImage )
		{
			lock( locker )
			{
				int result = dx_ConvertNormalFormatBaseImage( ref BaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ConvertNormalFormatBaseImage( [ In , Out ] ref BASEIMAGE BaseImage ) ;


		/// <summary> `Ώۂ̉ʂẅ̃OtBbN{C[Wf[^ɓ] </summary>
		public static void GetDrawScreenBaseImage( int x1 , int y1 , int x2 , int y2 , BaseImage BaseImage )
		{
			lock( locker )
			{
				int result = dx_GetDrawScreenBaseImage( x1 , y1 , x2 , y2 , ref BaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawScreenBaseImage( int x1 , int y1 , int x2 , int y2 , [ In , Out ] ref BASEIMAGE BaseImage ) ;


		/// <summary> {C[Wgp UpdateLayerdWindow s </summary>
		public static void UpdateLayerdWindowForBaseImage( BaseImage BaseImage )
		{
			lock( locker )
			{
				int result = dx_UpdateLayerdWindowForBaseImage( ref BaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_UpdateLayerdWindowForBaseImage( [ In ] ref BASEIMAGE BaseImage ) ;


		/// <summary> {C[Wf[^w̐FœhԂ </summary>
		public static void FillBaseImage( BaseImage BaseImage , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_FillBaseImage( ref BaseImage.buffer , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FillBaseImage( [ In , Out ] ref BASEIMAGE BaseImage , int r , int g , int b , int a ) ;


		/// <summary> {C[Wf[^̎ẅ̗ONA </summary>
		public static void ClearRectBaseImage( BaseImage BaseImage , int x , int y , int w , int h )
		{
			lock( locker )
			{
				int result = dx_ClearRectBaseImage( ref BaseImage.buffer , x , y , w , h ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearRectBaseImage( [ In , Out ] ref BASEIMAGE BaseImage , int x , int y , int w , int h ) ;


		/// <summary> {C[Wf[^̃pbg擾 </summary>
		public static void GetPaletteBaseImage( BaseImage BaseImage , int PaletteNo , out int r , out int g , out int b , out int a )
		{
			lock( locker )
			{
				int result = dx_GetPaletteBaseImage( ref BaseImage.buffer , PaletteNo , out r , out g , out b , out a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPaletteBaseImage( [ In ] ref BASEIMAGE BaseImage , int PaletteNo , out int r , out int g , out int b , out int a ) ;


		/// <summary> {C[Wf[^̃pbgZbg </summary>
		public static void SetPaletteBaseImage( BaseImage BaseImage , int PaletteNo , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_SetPaletteBaseImage( ref BaseImage.buffer , PaletteNo , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPaletteBaseImage( [ In , Out ] ref BASEIMAGE BaseImage , int PaletteNo , int r , int g , int b , int a ) ;


		/// <summary> {C[Wf[^̎w̍W̐FR[hύX(pbg摜p) </summary>
		public static void SetPixelPalCodeBaseImage( BaseImage BaseImage , int x , int y , int PalNo )
		{
			lock( locker )
			{
				int result = dx_SetPixelPalCodeBaseImage( ref BaseImage.buffer , x , y , PalNo ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPixelPalCodeBaseImage( [ In , Out ] ref BASEIMAGE BaseImage , int x , int y , int PalNo ) ;


		/// <summary> {C[Wf[^̎w̍W̐FR[h擾(pbg摜p) </summary>
		public static int GetPixelPalCodeBaseImage( BaseImage BaseImage , int x , int y )
		{
			lock( locker )
			{
				int result = dx_GetPixelPalCodeBaseImage( ref BaseImage.buffer , x , y ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPixelPalCodeBaseImage( [ In ] ref BASEIMAGE BaseImage , int x , int y ) ;


		/// <summary> {C[Wf[^̎w̍W̐FύX(eFvf͂O`QTT) </summary>
		public static void SetPixelBaseImage( BaseImage BaseImage , int x , int y , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_SetPixelBaseImage( ref BaseImage.buffer , x , y , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPixelBaseImage( [ In , Out ] ref BASEIMAGE BaseImage , int x , int y , int r , int g , int b , int a ) ;


		/// <summary> {C[Wf[^̎w̍W̐F擾(eFvf͂O`QTT) </summary>
		public static void GetPixelBaseImage( BaseImage BaseImage , int x , int y , out int r , out int g , out int b , out int a )
		{
			lock( locker )
			{
				int result = dx_GetPixelBaseImage( ref BaseImage.buffer , x , y , out r , out g , out b , out a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetPixelBaseImage( [ In ] ref BASEIMAGE BaseImage , int x , int y , out int r , out int g , out int b , out int a ) ;


		/// <summary> {C[Wf[^̎w̍Wɐ`悷(eFvf͂O`QTT) </summary>
		public static void DrawLineBaseImage( BaseImage BaseImage , int x1 , int y1 , int x2 , int y2 , int r , int g , int b , int a )
		{
			lock( locker )
			{
				int result = dx_DrawLineBaseImage( ref BaseImage.buffer , x1 , y1 , x2 , y2 , r , g , b , a ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawLineBaseImage( [ In ] ref BASEIMAGE BaseImage , int x1 , int y1 , int x2 , int y2 , int r , int g , int b , int a ) ;


		/// <summary> {C[Wf[^] </summary>
		public static void BltBaseImage( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , BaseImage SrcBaseImage , BaseImage DestBaseImage )
		{
			lock( locker )
			{
				int result = dx_BltBaseImage( SrcX , SrcY , SrcSizeX , SrcSizeY , DestX , DestY , ref SrcBaseImage.buffer , ref DestBaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBaseImage( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , [ In ] ref BASEIMAGE SrcBaseImage , [ In , Out ] ref BASEIMAGE DestBaseImage ) ;


		/// <summary> {C[Wf[^] </summary>
		public static void BltBaseImage( int DestX , int DestY , BaseImage SrcBaseImage , BaseImage DestBaseImage )
		{
			lock( locker )
			{
				int result = dx_BltBaseImage_2( DestX , DestY , ref SrcBaseImage.buffer , ref DestBaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBaseImage_2( int DestX , int DestY , [ In ] ref BASEIMAGE SrcBaseImage , [ In , Out ] ref BASEIMAGE DestBaseImage ) ;


		/// <summary> {C[Wf[^𓧉ߐFtœ] </summary>
		public static void BltBaseImageWithTransColor( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , BaseImage SrcBaseImage , BaseImage DestBaseImage , int Tr , int Tg , int Tb , int Ta )
		{
			lock( locker )
			{
				int result = dx_BltBaseImageWithTransColor( SrcX , SrcY , SrcSizeX , SrcSizeY , DestX , DestY , ref SrcBaseImage.buffer , ref DestBaseImage.buffer , Tr , Tg , Tb , Ta ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBaseImageWithTransColor( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , [ In ] ref BASEIMAGE SrcBaseImage , [ In , Out ] ref BASEIMAGE DestBaseImage , int Tr , int Tg , int Tb , int Ta ) ;


		/// <summary> {C[Wf[^At@l̃uhlœ]( Opacity ͓x : 0( S ) ` 255( Ss ) )( o͐悪 ARGB8 `ȊȌꍇ̓G[ɂȂ܂ ) </summary>
		public static void BltBaseImageWithAlphaBlend( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , BaseImage SrcBaseImage , BaseImage DestBaseImage , int Opacity )
		{
			lock( locker )
			{
				int result = dx_BltBaseImageWithAlphaBlend( SrcX , SrcY , SrcSizeX , SrcSizeY , DestX , DestY , ref SrcBaseImage.buffer , ref DestBaseImage.buffer , Opacity ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> {C[Wf[^At@l̃uhlœ]( Opacity ͓x : 0( S ) ` 255( Ss ) )( o͐悪 ARGB8 `ȊȌꍇ̓G[ɂȂ܂ ) </summary>
		public static void BltBaseImageWithAlphaBlend( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , BaseImage SrcBaseImage , BaseImage DestBaseImage )
		{
			BltBaseImageWithAlphaBlend( SrcX , SrcY , SrcSizeX , SrcSizeY , DestX , DestY , SrcBaseImage , DestBaseImage , 255 ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBaseImageWithAlphaBlend( int SrcX , int SrcY , int SrcSizeX , int SrcSizeY , int DestX , int DestY , [ In ] ref BASEIMAGE SrcBaseImage , [ In , Out ] ref BASEIMAGE DestBaseImage , int Opacity ) ;


		/// <summary> {摜f[^alo摜Ƃĕۑ </summary>
		public static void SaveBaseImageToBmp( string FilePath , BaseImage BaseImage )
		{
			lock( locker )
			{
				int result = dx_SaveBaseImageToBmp( FilePath , ref BaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SaveBaseImageToBmp( string FilePath , [ In ] ref BASEIMAGE BaseImage ) ;


		/// <summary> {摜f[^omf摜Ƃĕۑ </summary>
		public static void SaveBaseImageToPng( string FilePath , BaseImage BaseImage , int CompressionLevel )
		{
			lock( locker )
			{
				int result = dx_SaveBaseImageToPng( FilePath , ref BaseImage.buffer , CompressionLevel ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SaveBaseImageToPng( string FilePath , [ In ] ref BASEIMAGE BaseImage , int CompressionLevel ) ;


		/// <summary> {摜f[^iodf摜Ƃĕۑ </summary>
		public static void SaveBaseImageToJpeg( string FilePath , BaseImage BaseImage , int Quality , bool Sample2x1 )
		{
			lock( locker )
			{
				int result = dx_SaveBaseImageToJpeg( FilePath , ref BaseImage.buffer , Quality , Sample2x1 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SaveBaseImageToJpeg( string FilePath , [ In ] ref BASEIMAGE BaseImage , int Quality , bool Sample2x1 ) ;

		
		/// <summary> J[}b`OȂOtBbNf[^ԓ]s Ver2 </summary>
		public static void GraphColorMatchBltVer2( IntPtr DestGraphData , int DestPitch , COLORDATA DestColorData , IntPtr SrcGraphData , int SrcPitch , COLORDATA SrcColorData , IntPtr AlphaMask , int AlphaPitch , COLORDATA AlphaColorData , POINT DestPoint , RECT SrcRect , bool ReverseFlag , bool TransColorAlphaTestFlag , COLOR_U8 TransColor , DX_SHAVEDMODE ImageShavedMode , bool AlphaOnlyFlag , bool RedIsAlphaFlag , bool TransColorNoMoveFlag )
		{
			GraphColorMatchBltVer2( DestGraphData , DestPitch , DestColorData , SrcGraphData , SrcPitch , SrcColorData , AlphaMask , AlphaPitch , AlphaColorData , DestPoint , SrcRect , ReverseFlag , TransColorAlphaTestFlag , TransColor , ImageShavedMode , AlphaOnlyFlag , RedIsAlphaFlag , TransColorNoMoveFlag , false ) ;
		}

		/// <summary> J[}b`OȂOtBbNf[^ԓ]s Ver2 </summary>
		public static void GraphColorMatchBltVer2( IntPtr DestGraphData , int DestPitch , COLORDATA DestColorData , IntPtr SrcGraphData , int SrcPitch , COLORDATA SrcColorData , IntPtr AlphaMask , int AlphaPitch , COLORDATA AlphaColorData , POINT DestPoint , RECT SrcRect , bool ReverseFlag , bool TransColorAlphaTestFlag , COLOR_U8 TransColor , DX_SHAVEDMODE ImageShavedMode , bool AlphaOnlyFlag , bool RedIsAlphaFlag )
		{
			GraphColorMatchBltVer2( DestGraphData , DestPitch , DestColorData , SrcGraphData , SrcPitch , SrcColorData , AlphaMask , AlphaPitch , AlphaColorData , DestPoint , SrcRect , ReverseFlag , TransColorAlphaTestFlag , TransColor , ImageShavedMode , AlphaOnlyFlag , RedIsAlphaFlag , false ) ;
		}

		/// <summary> J[}b`OȂOtBbNf[^ԓ]s Ver2 </summary>
		public static void GraphColorMatchBltVer2( IntPtr DestGraphData , int DestPitch , COLORDATA DestColorData , IntPtr SrcGraphData , int SrcPitch , COLORDATA SrcColorData , IntPtr AlphaMask , int AlphaPitch , COLORDATA AlphaColorData , POINT DestPoint , RECT SrcRect , bool ReverseFlag , bool TransColorAlphaTestFlag , COLOR_U8 TransColor , DX_SHAVEDMODE ImageShavedMode , bool AlphaOnlyFlag )
		{
			GraphColorMatchBltVer2( DestGraphData , DestPitch , DestColorData , SrcGraphData , SrcPitch , SrcColorData , AlphaMask , AlphaPitch , AlphaColorData , DestPoint , SrcRect , ReverseFlag , TransColorAlphaTestFlag , TransColor , ImageShavedMode , AlphaOnlyFlag , false ) ;
		}

		/// <summary> J[}b`OȂOtBbNf[^ԓ]s Ver2 </summary>
		public static void GraphColorMatchBltVer2( IntPtr DestGraphData , int DestPitch , COLORDATA DestColorData , IntPtr SrcGraphData , int SrcPitch , COLORDATA SrcColorData , IntPtr AlphaMask , int AlphaPitch , COLORDATA AlphaColorData , POINT DestPoint , RECT SrcRect , bool ReverseFlag , bool TransColorAlphaTestFlag , COLOR_U8 TransColor , DX_SHAVEDMODE ImageShavedMode )
		{
			GraphColorMatchBltVer2( DestGraphData , DestPitch , DestColorData , SrcGraphData , SrcPitch , SrcColorData , AlphaMask , AlphaPitch , AlphaColorData , DestPoint , SrcRect , ReverseFlag , TransColorAlphaTestFlag , TransColor , ImageShavedMode , false ) ;
		}

		/// <summary> J[}b`OȂOtBbNf[^ԓ]s Ver2 </summary>
		public static void GraphColorMatchBltVer2( IntPtr DestGraphData , int DestPitch , COLORDATA DestColorData , IntPtr SrcGraphData , int SrcPitch , COLORDATA SrcColorData , IntPtr AlphaMask , int AlphaPitch , COLORDATA AlphaColorData , POINT DestPoint , RECT SrcRect , bool ReverseFlag , bool TransColorAlphaTestFlag , COLOR_U8 TransColor , DX_SHAVEDMODE ImageShavedMode , bool AlphaOnlyFlag , bool RedIsAlphaFlag , bool TransColorNoMoveFlag , bool Pal8ColorMatch )
		{
			lock( locker )
			{
				int result = dx_GraphColorMatchBltVer2( DestGraphData , DestPitch , ref DestColorData , SrcGraphData , SrcPitch , ref SrcColorData , AlphaMask , AlphaPitch ,ref AlphaColorData , DestPoint , ref SrcRect , ReverseFlag , TransColorAlphaTestFlag , TransColor , ImageShavedMode , AlphaOnlyFlag , RedIsAlphaFlag , TransColorNoMoveFlag , Pal8ColorMatch ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GraphColorMatchBltVer2( IntPtr DestGraphData , int DestPitch , [ In ] ref COLORDATA DestColorData , IntPtr SrcGraphData , int SrcPitch , [ In ] ref COLORDATA SrcColorData , IntPtr AlphaMask , int AlphaPitch , [ In ] ref COLORDATA AlphaColorData , POINT DestPoint , [ In ] ref RECT SrcRect , bool ReverseFlag , bool TransColorAlphaTestFlag , COLOR_U8 TransColor , DX_SHAVEDMODE ImageShavedMode , bool AlphaOnlyFlag , bool RedIsAlphaFlag , bool TransColorNoMoveFlag , bool Pal8ColorMatch ) ;


		/// <summary> s_^̃J[l쐬 </summary>
		public static COLOR_F GetColorF( float Red , float Green , float Blue , float Alpha )
		{
			lock( locker )
			{
				COLOR_F result = dx_GetColorF( Red , Green , Blue , Alpha ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetColorF( float Red , float Green , float Blue , float Alpha ) ;


		/// <summary> ȂWrbg̃J[l쐬 </summary>
		public static COLOR_U8 GetColorU8( int Red , int Green , int Blue , int Alpha )
		{
			lock( locker )
			{
				COLOR_U8 result = dx_GetColorU8( Red , Green , Blue , Alpha ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_U8 dx_GetColorU8( int Red , int Green , int Blue , int Alpha ) ;


		/// <summary> RFl猻݂̉ʃ[hɑΉFf[^l𓾂 </summary>
		public static int GetColor( int Red , int Green , int Blue )
		{
			lock( locker )
			{
				int result = dx_GetColor( Red , Green , Blue ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetColor( int Red , int Green , int Blue ) ;


		/// <summary> ʃ[hɑΉFf[^lX̂RFf[^𔲂o </summary>
		public static void GetColor2( int Color , out int Red , out int Green , out int Blue )
		{
			lock( locker )
			{
				int result = dx_GetColor2( Color , out Red , out Green , out Blue ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetColor2( int Color , out int Red , out int Green , out int Blue ) ;


		/// <summary> RFlw̃sNZtH[}bgɑΉFf[^l𓾂 </summary>
		public static int GetColor3( COLORDATA ColorData , int Red , int Green , int Blue )
		{
			return GetColor3( ColorData , Red , Green , Blue , 255 ) ;
		}

		/// <summary> RFlw̃sNZtH[}bgɑΉFf[^l𓾂 </summary>
		public static int GetColor3( COLORDATA ColorData , int Red , int Green , int Blue , int Alpha )
		{
			lock( locker )
			{
				int result = dx_GetColor3( ref ColorData , Red , Green , Blue , Alpha ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetColor3( [ In ] ref COLORDATA ColorData , int Red , int Green , int Blue , int Alpha ) ;


		/// <summary> Q̃J[tH[}bgԂ̃f[^ϊs𓾂  </summary>
		public static int GetColor4( COLORDATA DestColorData , COLORDATA SrcColorData , int SrcColor )
		{
			lock( locker )
			{
				int result = dx_GetColor4( ref DestColorData , ref SrcColorData , SrcColor ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetColor4( [ In ] ref COLORDATA DestColorData , [ In ] ref COLORDATA SrcColorData , int SrcColor ) ;


		/// <summary> wJ[tH[}bgɑΉFf[^lX̂RFf[^𔲂o </summary>
		public static void GetColor5( COLORDATA ColorData , int Color , out int Red , out int Green , out int Blue )
		{
			int Alpha ;
			GetColor5( ColorData , Color , out Red , out Green , out Blue , out Alpha ) ;
		}

		/// <summary> wJ[tH[}bgɑΉFf[^lX̂RFf[^𔲂o </summary>
		public static void GetColor5( COLORDATA ColorData , int Color , out int Red , out int Green , out int Blue , out int Alpha )
		{
			lock( locker )
			{
				int result = dx_GetColor5( ref ColorData , Color , out Red , out Green , out Blue , out Alpha ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetColor5( [ In ] ref COLORDATA ColorData , int Color , out int Red , out int Green , out int Blue , out int Alpha ) ;


		/// <summary> pbgJ[̃J[\z </summary>
		public static void CreatePaletteColorData( out COLORDATA ColorDataBuf )
		{
			lock( locker )
			{
				int result = dx_CreatePaletteColorData( out ColorDataBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreatePaletteColorData( out COLORDATA ColorDataBuf ) ;


		/// <summary> wqfaWJ[̃J[\z </summary>
		public static void CreateXRGB8ColorData( out COLORDATA ColorDataBuf )
		{
			lock( locker )
			{
				int result = dx_CreateXRGB8ColorData( out ColorDataBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateXRGB8ColorData( out COLORDATA ColorDataBuf ) ;


		/// <summary> `qfaWJ[̃J[\z </summary>
		public static void CreateARGB8ColorData( out COLORDATA ColorDataBuf )
		{
			lock( locker )
			{
				int result = dx_CreateARGB8ColorData( out ColorDataBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateARGB8ColorData( out COLORDATA ColorDataBuf ) ;


		/// <summary> tJ[chãJ[\z </summary>
		public static void CreateFullColorData( out COLORDATA ColorDataBuf )
		{
			lock( locker )
			{
				int result = dx_CreateFullColorData( out ColorDataBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateFullColorData( out COLORDATA ColorDataBuf ) ;


		/// <summary> O[XP[̃J[\z </summary>
		public static void CreateGrayColorData( out COLORDATA ColorDataBuf )
		{
			lock( locker )
			{
				int result = dx_CreateGrayColorData( out ColorDataBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGrayColorData( out COLORDATA ColorDataBuf ) ;


		/// <summary> pbgQTUF̃J[\z </summary>
		public static void CreatePal8ColorData( out COLORDATA ColorDataBuf )
		{
			lock( locker )
			{
				int result = dx_CreatePal8ColorData( out ColorDataBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreatePal8ColorData( out COLORDATA ColorDataBuf ) ;


		/// <summary> J[f[^쐬 </summary>
		public static void CreateColorData( out COLORDATA ColorDataBuf , int ColorBitDepth , int RedMask , int GreenMask , int BlueMask , int AlphaMask )
		{
			lock( locker )
			{
				int result = dx_CreateColorData( out ColorDataBuf , ColorBitDepth , RedMask , GreenMask , BlueMask , AlphaMask ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateColorData( out COLORDATA ColorDataBuf , int ColorBitDepth , int RedMask , int GreenMask , int BlueMask , int AlphaMask ) ;


		/// <summary> NoneMask ȊO̗vf𖄂߂ COLORDATA \̂̏ NoneMask Zbg </summary>
		public static void SetColorDataNoneMask( ref COLORDATA ColorData )
		{
			lock( locker )
			{
				dx_SetColorDataNoneMask( ref ColorData ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern void dx_SetColorDataNoneMask( [ In , Out ] ref COLORDATA ColorData ) ;


		/// <summary> ̃J[f[^ǂׂ( TRUE:  FALSE:Ȃ ) </summary>
		public static bool CmpColorData( COLORDATA ColorData1 , COLORDATA ColorData2 )
		{
			lock( locker )
			{
				int result = dx_CmpColorData( ref ColorData1 , ref ColorData2 ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CmpColorData( [ In ] ref COLORDATA ColorData1 , [ In ] ref COLORDATA ColorData2 ) ;
	}
}
