using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		/// <summary> gp̂cRccIuWFNg𓾂 </summary>
		/// <returns> D_IDirect3DDevice7 * </returns>
		public static IntPtr GetUseD3DDevObj()
		{
			lock( locker )
			{
				IntPtr result = dx_GetUseD3DDevObj() ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetUseD3DDevObj() ;


		/// <summary> KvȂOtBbN̕sAtÕZbg </summary>
		public static void SetUseDivGraphFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseDivGraphFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseDivGraphFlag( bool Flag ) ;


		/// <summary> gpeNX`[̍őTCYZbg(0ŃftHg) </summary>
		public static void SetUseMaxTextureSize( int Size )
		{
			lock( locker )
			{
				int result = dx_SetUseMaxTextureSize( Size ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseMaxTextureSize( int Size ) ;


		/// <summary> _obt@gp邩ǂݒ肷 </summary>
		public static void SetUseVertexBufferFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseVertexBufferFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseVertexBufferFlag( bool Flag ) ;


		/// <summary> ȑO DrawModiGraph ֐̃R[hgp邩ǂ̃tOZbg </summary>
		public static void SetUseOldDrawModiGraphCodeFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseOldDrawModiGraphCodeFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseOldDrawModiGraphCodeFlag( bool Flag ) ;


		/// <summary> J[f[^𓾂 </summary>
		public static COLORDATA GetTexColorData( bool AlphaCh , bool AlphaTest , TEX_BITDEPTH ColorBitDepth )
		{
			return GetTexColorData( AlphaCh , AlphaTest , ColorBitDepth , false ) ;
		}

		/// <summary> J[f[^𓾂 </summary>
		public static COLORDATA GetTexColorData( bool AlphaCh , bool AlphaTest , TEX_BITDEPTH ColorBitDepth , bool DrawValid )
		{
			lock( locker )
			{
				IntPtr result = dx_GetTexColorData( AlphaCh , AlphaTest , ColorBitDepth , DrawValid ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return ( COLORDATA )( Marshal.PtrToStructure( result , typeof( COLORDATA ) ) ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetTexColorData( bool AlphaCh , bool AlphaTest , TEX_BITDEPTH ColorBitDepth , bool DrawValid ) ;


		/// <summary> tH[}bgɊÂJ[f[^𓾂 </summary>
		public static COLORDATA GetTexColorData( IMAGEFORMATDESC Format )
		{
			lock( locker )
			{
				IntPtr result = dx_GetTexColorData_2( ref Format ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return ( COLORDATA )( Marshal.PtrToStructure( result , typeof( COLORDATA ) ) ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetTexColorData_2( [ In ] ref IMAGEFORMATDESC Format ) ;


		/// <summary> w̃tH[}bgCfbNX̃J[f[^𓾂 </summary>
		public static COLORDATA GetTexColorData( int FormatIndex )
		{
			lock( locker )
			{
				IntPtr result = dx_GetTexColorData_3( FormatIndex ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return ( COLORDATA )( Marshal.PtrToStructure( result , typeof( COLORDATA ) ) ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetTexColorData_3( int FormatIndex ) ;
	}
}
