echo '// Translated by Nina'
echo '// This source code is under public domain'
[ -z "$PACKAGE" ] || echo "package $PACKAGE;"

cat << EOF

public class $CLASSNAME {

	private int state;
	private int unread = -1;

	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(unread < 0) {
			return rd.read();
		} else {
			c = unread;
			unread = -1;
			return c;
		}
	}

	private boolean _step(int c) {
		switch(state) {
EOF

print_states
cat << EOF
		}
		return false;
	}

	private boolean _accepted() {
EOF

print_accepts
cat << EOF
	}

	private Object _gettoken(StringBuffer b) {
EOF

echo '		String $$ = b.toString();'
echo
echo '		switch(state) {'

print_token
cat << EOF
		default:  return null;
		}
	}

	public boolean matches(String s) {
		int n;

		for(n = 0; n < s.length(); n++) {
			if(!_step(s.charAt(n))) {
				return false;
			}
		}
		return _accepted();
	}

	public boolean lookingAt(String s) {
		int n;

		for(n = 0; n < s.length(); n++) {
			if(_accepted()) {
				return true;
			} else if(!_step(s.charAt(n))) {
				return false;
			}
		}
		return _accepted();
	}

	public boolean find(String s) {
		int n, k;

		for(k = 0; k < s.length(); k++) {
			for(n = k; n < s.length(); n++) {
				if(_accepted()) {
					return true;
				} else if(!_step(s.charAt(n))) {
					state = 0;
					break;
				}
			}
		}
		return false;
	}

	public Object searchToken(
			java.io.Reader rd) throws java.io.IOException {
		StringBuffer b = new StringBuffer();
		boolean f = false;
		Object o = null;
		int c;

		while((c = _read(rd)) >= 0) {
			b.appendCodePoint(c);
			if(!_step(c)) {
				if(f) {
					unread = c;
					state = 0;
					return o;
				} else {
					return null;
				}
			} else if(f & !(f = _accepted())) {
				unread = c;
				state = 0;
				return o;
			} else if(f) {
				o = _gettoken(b);
			}
		}
		return f ? o : null;
	}

}
EOF
