/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate.sh;

import java.io.InputStream;

import net.morilib.sh.AbstractShFileSystem;
import net.morilib.sh.DefaultShVirtualDirectory;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShSecurityPolicy;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/25
 */
public class ShNinatFileSystem extends AbstractShFileSystem {

	private static final DefaultShVirtualDirectory ROOT;

	static {
		ROOT = new DefaultShVirtualDirectory(null, null);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getRoot()
	 */
	@Override
	public ShFile getRoot() {
		return ROOT;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getFile(java.lang.String)
	 */
	@Override
	public ShFile getFile(String s) {
		return s.equals("/") ? ROOT : null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getFile(java.lang.String, java.lang.String)
	 */
	@Override
	public ShFile getFile(String dir, String name) {
		return getFile(getFile(dir), name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getFile(net.morilib.sh.ShFile, java.lang.String)
	 */
	@Override
	public ShFile getFile(ShFile dir, String name) {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getNativeFile(java.lang.String)
	 */
	@Override
	public ShFile getNativeFile(String s) {
		return getFile(s);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getSecurityPolicy()
	 */
	@Override
	public ShSecurityPolicy getSecurityPolicy() {
		return ShSecurityPolicy.ALL_PERMITTED;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getProfile()
	 */
	@Override
	public InputStream getProfile() {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getRc()
	 */
	@Override
	public InputStream getRc() {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getHome()
	 */
	@Override
	public ShFile getHome() {
		return getRoot();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#searchPath(net.morilib.sh.ShEnvironment, java.lang.String)
	 */
	@Override
	public ShFile searchPath(ShEnvironment env, String name) {
		return null;
	}

}
