/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ResourceBundle;

import net.morilib.nina.Nina;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.NinaTranslator;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class Ninat {

	private static final String CLSNAME =
			Ninat.class.getPackage().getName().replace('.', '/');

	private static NinatOptions opts = new NinatOptions();
	private static ResourceBundle msgs;

	static void perror(String p, Object... a) {
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	static void usage() {
		int l = Integer.parseInt(msgs.getString("usage.length"));
		String x;

		perror("title", Nina.VERSION);
		for(int i = 1; i <= l; i++) {
			x = String.format("%03d", i);
			perror("usage." + x);
		}
	}

	static int parseOptions(String[] args) {
		NinaTranslator t;
		int k = 0, x;
		String s;

		for(; k < args.length; k++) {
			if(!(s = args[k]).startsWith("--")) {
				return k;
			} else if(s.equals("--help")) {
				usage();
				System.exit(2);
			} else if(s.startsWith("--lang=")) {
				t = AbstractNinaTranslator.getTranslator(
						s.substring(7));
				opts.setTranslator(t);
			} else if((x = s.indexOf('=')) < 0) {
				opts.setOption(s.substring(2), "");
			} else {
				opts.setOption(s.substring(2, x), s.substring(x + 1));
			}
		}
		return k;
	}

	static void process(String arg) {
		InputStream ins = null;
		NinaTranslator tr;
		Reader rd = null;
		String s;
		int x;

		if((x = arg.lastIndexOf('.')) < 0) {
			s = arg + ".nina";
			opts.setFilename(arg);
		} else {
			s = arg;
			opts.setFilename(arg.substring(0, x));
		}

		try {
			ins = new FileInputStream(s);
			rd  = new InputStreamReader(ins);
			tr  = opts.getTranslator();
			tr.translate(rd, opts);
		} catch(FileNotFoundException e) {
			perror("filenotfound", s);
		} catch(IOException e) {
			throw new RuntimeException(e);
		} finally {
			if(ins != null) {
				try {
					ins.close();
				} catch (IOException e) {
					throw new RuntimeException(e);
				}
			}
		}
	}

	public static void main(String[] args) {
		int k;

		msgs = ResourceBundle.getBundle(CLSNAME + "/ninat_messages");
		if(args.length == 0) {
			usage();
			System.exit(2);
		} else if((k = parseOptions(args)) == args.length) {
			perror("nofiles");
			System.exit(2);
		} else {
			for(; k < args.length; k++) {
				process(args[k]);
			}
			System.exit(0);
		}
	}

}
