/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * {@link ServiceProxyFactory}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class ServiceProxyFactoryTest{
    
    @DataProvider(name = "CreateServiceBaseProxy")
    public Object[][] dataCreateServiceBaseProxy(){
        return new Object[][]{
            {new MyServiceBaseSupport()},
            {new MyServiceBaseSupport2()}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceProxyFactory#createServiceBaseProxy(jp.ossc.nimbus.core.ServiceBaseSupport)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.GenericsServiceProxy#.*"},
          dataProvider = "CreateServiceBaseProxy")
    public void testCreateServiceBaseProxy(ServiceBaseSupport support) throws Exception{
        ServiceBase service = ServiceProxyFactory.createServiceBaseProxy(support);
        assertEquals(service.getClass(), GenericsServiceProxy.class);
        assertNotNull(service.getTarget());
        assertEquals(service.getTarget().getClass(), support.getClass());
    }
    
    @DataProvider(name = "CreateServiceBaseProxy2")
    public Object[][] dataCreateServiceBaseProxy2(){
        return new Object[][]{
            {new POJO()},
            {new POJOService()}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceProxyFactory#createServiceBaseProxy(java.lang.Object)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.GenericsServiceProxy#.*"},
          dataProvider = "CreateServiceBaseProxy2")
    public void testCreateServiceBaseProxy2(Object obj) throws Exception{
        ServiceBase service = ServiceProxyFactory.createServiceBaseProxy(obj);
        assertEquals(service.getClass(), GenericsServiceProxy.class);
        assertNotNull(service.getTarget());
        assertTrue(ServiceBaseSupport.class.isAssignableFrom(service.getTarget().getClass()));
        assertTrue(ServiceProxy.class.isAssignableFrom(service.getTarget().getClass()));
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        if(interfaces.length != 0){
            for(Class<?> interfaceClazz : interfaces){
                assertTrue(interfaceClazz.isAssignableFrom(service.getTarget().getClass()));
            }
        }
    }
    
    private static class MyServiceBaseSupport implements ServiceBaseSupport{

        @Override
        public void createService() throws Exception{
        }

        @Override
        public void destroyService() throws Exception{
        }

        @Override
        public void startService() throws Exception{
        }

        @Override
        public void stopService() throws Exception{
        }

        @Override
        public void setServiceBase(ServiceBase service){
        }
        
    }
    
    public static class MyServiceBaseSupport2 implements ServiceBaseSupport, MyServiceBaseSupport2MBean{
        
        @Override
        public void createService() throws Exception{
        }

        @Override
        public void destroyService() throws Exception{
        }

        @Override
        public void startService() throws Exception{
        }

        @Override
        public void stopService() throws Exception{
        }

        @Override
        public String foo(int index){
            return "foo" + index;
        }

        @Override
        public int getFuga(){
            return 100;
        }
        
        private String hoge;

        @Override
        public String getHoge(){
            return hoge;
        }

        @Override
        public void setHoge(String val){
            hoge = val;
        }
        
        Object bar;
        
        @Override
        public void setBar(Object obj){
            bar = obj;
        }

        @Override
        public void setServiceBase(ServiceBase service){
        }
    }
    
    private static interface MyServiceBaseSupport2MBean{
        
        public void setHoge(String val);
        public String getHoge();
        
        public int getFuga();
        
        public void setBar(Object obj);
        
        public String foo(int index);
    }
    
    public static class POJO{
    }
    
    public static class POJOService implements POJOInterface{
        
        public void create(){
        }
        public void start(){
        }
        public void stop(){
        }
        public void destroy(){
        }
        public String getHoge(){
            return "hoge";
        }
    }
    
    public interface POJOInterface{
        public String getHoge();
    }
}