/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link DefaultServiceLoaderConfig}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class DefaultServiceLoaderConfigTest{
    
    @Test(groups = {"jp.ossc.nimbus.core.DefaultServiceLoaderConfig#DefaultServiceLoaderConfig()",
                    "Normal"})
    public void testDefaultServiceLoaderConfig(){
        DefaultServiceLoaderConfig config = new DefaultServiceLoaderConfig();
        assertNull(config.getServiceLoaderClassName());
        assertEquals(config.getPropertyNameSet().size(), 0);
    }

    @DataProvider(name = "SetServiceLoaderClassName")
    public Object[][] dataSetServiceLoaderClassName(){
        return new Object[][]{
            {null},
            {"test.MyServiceLoader"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultServiceLoaderConfig#setServiceLoaderClassName(java.lang.String)",
                    "jp.ossc.nimbus.core.DefaultServiceLoaderConfig#getServiceLoaderClassName()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.DefaultServiceLoaderConfig#DefaultServiceLoaderConfig\\(\\)"},
          dataProvider = "SetServiceLoaderClassName")
    public void testSetServiceLoaderClassName(String name){
        DefaultServiceLoaderConfig config = new DefaultServiceLoaderConfig();
        config.setServiceLoaderClassName(name);
        assertEquals(config.getServiceLoaderClassName(), name);
    }

    @DataProvider(name = "SetProperty")
    public Object[][] dataSetProperty(){
        return new Object[][]{
            {null},
            {new String[][]{{"prop1", "1"}}},
            {new String[][]{{"prop1", "1"}, {"prop2", "2"}, {"prop3", "3"}, {"prop4", "4"}, {"prop5", "5"}, {"prop6", "6"}, {"prop7", "7"}, {"prop8", "8"}, {"prop9", "9"}, {"prop10", "10"}}},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.DefaultServiceLoaderConfig#setProperty(java.lang.String,java.lang.String)",
                    "jp.ossc.nimbus.core.DefaultServiceLoaderConfig#getPropertyNameSet()",
                    "jp.ossc.nimbus.core.DefaultServiceLoaderConfig#getProperty(java.lang.String)",
                    "jp.ossc.nimbus.core.DefaultServiceLoaderConfig#clearProperty(java.lang.String)",
                    "jp.ossc.nimbus.core.DefaultServiceLoaderConfig#clearProperties()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.DefaultServiceLoaderConfig#DefaultServiceLoaderConfig\\(\\)"},
          dataProvider = "SetProperty")
    public void testSetProperty(String[][] propertySet){
        DefaultServiceLoaderConfig config = new DefaultServiceLoaderConfig();
        if(propertySet == null || propertySet.length == 0){
            assertEquals(config.getPropertyNameSet().size(), 0);
        }else{
            Map<String, String> properties = new HashMap<String, String>();
            for(String[] property : propertySet){
                config.setProperty(property[0], property[1]);
                properties.put(property[0], property[1]);
            }
            for(String name : config.getPropertyNameSet()){
                assertEquals(config.getProperty(name), properties.get(name));
            }
            for(int i = 0, imax = propertySet.length; i < imax; i+=2){
                config.clearProperty(propertySet[i][0]);
                properties.remove(propertySet[i][0]);
            }
            Set<String> names = config.getPropertyNameSet();
            assertEquals(names, properties.keySet());
            config.clearProperties();
            assertEquals(config.getPropertyNameSet().size(), 0);
        }
    }
}
