/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;


import java.net.MalformedURLException;
import java.net.URL;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link URLEditorTest}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class URLEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText() throws MalformedURLException{
        return new Object[][]{
            {"http://nimbus.ossc.jp/hoge/fuga.html", new URL("http://nimbus.ossc.jp/hoge/fuga.html")}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.URLEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.URLEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsText")
    public void testSetAsText(String paramStr, URL answer){
        editorSetText(URLEditor.class, paramStr, answer);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty() throws MalformedURLException{
        return new Object[][]{
            {"test.URLEditor.value", "http://nimbus.ossc.jp/hoge/fuga.html", "${test.URLEditor.value}", new URL("http://nimbus.ossc.jp/hoge/fuga.html")}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.URLEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.URLEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, URL answer){
        editorSetTextSystemProperty(URLEditor.class, propertyKeyStr, propertyValStr, paramStr, answer);
    }
    
    @DataProvider(name = "SetValue")
    public Object[][] dataSetValue() throws MalformedURLException{
        return new Object[][]{
            {new URL("http://nimbus.ossc.jp/hoge/fuga.html"), "http://nimbus.ossc.jp/hoge/fuga.html"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.URLEditor#setValue(java.math.BigDecimal)",
                    "jp.ossc.nimbus.beans.URLEditor#getAsText()",
                    "Normal"},
        dataProvider = "SetValue")
    public void testSetValue(URL param, String answerStr){
        editorSetValue(URLEditor.class, param, answerStr);
    }
}
