/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.io.*;
import java.util.zip.*;

/**
 * SerializableIuWFNg̃Xg[Ro[^B<p>
 * 
 * @author M.Takata
 */
public class SerializeStreamConverter extends BufferedStreamConverter implements StreamConverter, Serializable{
    
    private static final long serialVersionUID = -4260884667278852436L;
    
    /**
     * ϊʁB<p>
     */
    protected int convertType;
    
    /**
     * k邩ǂ̃tOB<p>
     */
    protected boolean isCompress;
    
    /**
     * SerializableIuWFNgXg[ϊsRo[^𐶐B<p>
     */
    public SerializeStreamConverter(){
        this(OBJECT_TO_STREAM);
    }
    
    /**
     * w肳ꂽϊʂ̃Ro[^𐶐B<p>
     *
     * @param type ϊ
     * @see #OBJECT_TO_STREAM
     * @see #STREAM_TO_OBJECT
     */
    public SerializeStreamConverter(int type){
        convertType = type;
    }
    
    /**
     * ϊʂݒ肷B<p>
     *
     * @param type ϊ
     * @see #getConvertType()
     * @see #OBJECT_TO_STREAM
     * @see #STREAM_TO_OBJECT
     */
    @Override
    public void setConvertType(int type){
        convertType = type;
    }
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * k邩ǂݒ肷B<p>
     * truȅꍇAGZIPkBftHǵAfalseB<br>
     * 
     * @param compress kꍇtrue
     */
    public void setCompress(boolean compress){
        isCompress = compress;
    }
    
    /**
     * k邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAk
     */
    public boolean isCompress(){
        return isCompress;
    }
    
    /**
     * w肳ꂽIuWFNgϊB<p>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{
        if(obj == null){
            return null;
        }
        switch(convertType){
        case OBJECT_TO_STREAM:
            return convertToStream(obj);
        case STREAM_TO_OBJECT:
            if(!(obj instanceof InputStream)){
                throw new ConvertException(
                    "Invalid input type : " + obj.getClass()
                );
            }
            return convertToObject((InputStream)obj);
        default:
            throw new ConvertException(
                "Invalid convert type : " + convertType
            );
        }
    }
    
    /**
     * SerializableIuWFNgoCgzɕϊB<p>
     *
     * @param obj SerializableIuWFNg
     * @return oCgz
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    protected byte[] convertToByteArray(Object obj) throws ConvertException{
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try{
            if(obj != null){
                OutputStream os = baos;
                try{
                    if(isCompress){
                        os = new GZIPOutputStream(os);
                    }
                    final ObjectOutputStream oos = new ObjectOutputStream(os);
                    oos.writeObject((Serializable)obj);
                    oos.flush();
                    if(isCompress){
                        ((GZIPOutputStream)os).finish();
                    }
                }catch(IOException e){
                    throw new ConvertException(e);
                }finally{
                }
            }
            return baos.toByteArray();
        }finally{
            try{
                baos.close();
            }catch(IOException e){}
        }
    }
    
    /**
     * Xg[SerializableIuWFNgɕϊB<p>
     *
     * @param is Xg[
     * @return SerializableIuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convertToObject(InputStream is) throws ConvertException{
        try{
            if(isCompress){
                is = new GZIPInputStream(is);
            }
            final ObjectInputStream ois = new ObjectInputStream(is);
            return ois.readObject();
        }catch(IOException e){
            throw new ConvertException(e);
        }catch(ClassNotFoundException e){
            throw new ConvertException(e);
        }
    }
}
