/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.text.*;
import java.io.Serializable;
import java.math.*;

/**
 * 10itH[}bgRo[^B<p>
 * 
 * @author M.Takata
 */
public class DecimalFormatConverter implements FormatConverter, Serializable{
    
    private static final long serialVersionUID = -1183874197480695923L;
    
    /**
     * l\ϊʒ萔B<p>
     */
    public static final int NUMBER_TO_STRING = OBJECT_TO_STRING;
    
    /**
     * 񁨐lϊ\ϊʒ萔B<p>
     */
    public static final int STRING_TO_NUMBER = STRING_TO_OBJECT;
    
    protected static final String DOUBLE_NAN_STR;
    
    protected static final String DOUBLE_POSITIVE_INFINITY_STR;
    
    protected static final String DOUBLE_NEGATIVE_INFINITY_STR;
    
    static{
        DecimalFormat f = new DecimalFormat("#.#");
        DOUBLE_NAN_STR = f.format(Double.NaN);
        DOUBLE_POSITIVE_INFINITY_STR = f.format(Double.POSITIVE_INFINITY);
        DOUBLE_NEGATIVE_INFINITY_STR = f.format(Double.NEGATIVE_INFINITY);
    }
    
    /**
     * ϊʁB<p>
     */
    protected int convertType;
    
    /**
     * tH[}bgB<p>
     */
    protected String format;
    
    /**
     * NAlgp邩ǂ̃tOB<p>
     * ftHǵAfalseŎgpȂB<br>
     */
    protected boolean isUseNotApplicable;
    
    /**
     * byteNAlB<p>
     */
    protected Byte notApplicableForByte;
    
    /**
     * shortNAlB<p>
     */
    protected Short notApplicableForShort;
    
    /**
     * intNAlB<p>
     */
    protected Integer notApplicableForInt;
    
    /**
     * longNAlB<p>
     */
    protected Long notApplicableForLong;
    
    /**
     * floatNAlB<p>
     */
    protected Float notApplicableForFloat;
    
    /**
     * doubleNAlB<p>
     */
    protected Double notApplicableForDouble;
    
    /**
     * BigIntegerNAlB<p>
     */
    protected BigInteger notApplicableForBigInteger;
    
    /**
     * BigDecimalNAlB<p>
     */
    protected BigDecimal notApplicableForBigDecimal;
    
    /**
     * byteNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForByte;
    
    /**
     * shortNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForShort;
    
    /**
     * intNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForInt;
    
    /**
     * longNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForLong;
    
    /**
     * floatNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForFloat;
    
    /**
     * doubleNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForDouble;
    
    /**
     * BigIntegerNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForBigInteger;
    
    /**
     * BigDecimalNAl̕B<p>
     * ftHǵAnullB<br>
     */
    protected String notApplicableStringForBigDecimal;
    
    /**
     * tH[}bgȂŐlϊsRo[^𐶐B<p>
     */
    public DecimalFormatConverter(){
        this(NUMBER_TO_STRING, "");
    }
    
    /**
     * w肳ꂽϊʂ̃Ro[^𐶐B<p>
     *
     * @param type ϊ
     * @param format ltH[}bg
     * @see #NUMBER_TO_STRING
     * @see #STRING_TO_NUMBER
     */
    public DecimalFormatConverter(int type, String format){
        convertType = type;
        this.format = format;
        new DecimalFormat(format);
    }
    
    /**
     * ϊʂݒ肷B<p>
     *
     * @param type ϊ
     * @see #getConvertType()
     * @see #NUMBER_TO_STRING
     * @see #STRING_TO_NUMBER
     */
    @Override
    public void setConvertType(int type){
        convertType = type;
    }
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * ϊtH[}bgݒ肷B<p>
     *
     * @param format {@link DecimalFormat}̕ϊtH[}bg
     */
    @Override
    public void setFormat(String format){
        this.format = format;
    }
    
    /**
     * ϊtH[}bg擾B<p>
     *
     * @return ϊtH[}bg
     * @see #setFormat(String)
     */
    public String getFormat(){
        return format;
    }
    
    /**
     * NAlgp邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇANAlgp
     */
    public boolean isUseNotApplicable(){
        return isUseNotApplicable;
    }
    
    /**
     * NAlgp邩ǂ𔻒肷B<p>
     * ftHǵAfalseŁANAlgpȂB<br>
     *
     * @param isUse NAlgpꍇAtrue
     */
    public void setUseNotApplicable(boolean isUse){
        isUseNotApplicable = isUse;
    }
    
    /**
     * byteNAl擾B<p>
     *
     * @return byteNAl
     */
    public Byte getNotApplicableForByte(){
        return notApplicableForByte;
    }
    
    /**
     * byteNAlݒ肷B<p>
     *
     * @param na byteNAl
     */
    public void setNotApplicableForByte(Byte na){
        notApplicableForByte = na;
    }
    
    /**
     * shortNAl擾B<p>
     *
     * @return shortNAl
     */
    public Short getNotApplicableForShort(){
        return notApplicableForShort;
    }
    
    /**
     * shortNAlݒ肷B<p>
     *
     * @param na shortNAl
     */
    public void setNotApplicableForShort(Short na){
        notApplicableForShort = na;
    }
    
    /**
     * intNAl擾B<p>
     *
     * @return intNAl
     */
    public Integer getNotApplicableForInt(){
        return notApplicableForInt;
    }
    
    /**
     * intNAlݒ肷B<p>
     *
     * @param na intNAl
     */
    public void setNotApplicableForInt(Integer na){
        notApplicableForInt = na;
    }
    
    /**
     * longNAl擾B<p>
     *
     * @return longNAl
     */
    public Long getNotApplicableForLong(){
        return notApplicableForLong;
    }
    
    /**
     * longNAlݒ肷B<p>
     *
     * @param na longNAl
     */
    public void setNotApplicableForLong(Long na){
        notApplicableForLong = na;
    }
    
    /**
     * floatNAl擾B<p>
     *
     * @return byteNAl
     */
    public Float getNotApplicableForFloat(){
        return notApplicableForFloat;
    }
    
    /**
     * floatNAlݒ肷B<p>
     *
     * @param na floatNAl
     */
    public void setNotApplicableForFloat(Float na){
        notApplicableForFloat = na;
    }
    
    /**
     * doubleNAl擾B<p>
     *
     * @return byteNAl
     */
    public Double getNotApplicableForDouble(){
        return notApplicableForDouble;
    }
    
    /**
     * doubleNAlݒ肷B<p>
     *
     * @param na doubleNAl
     */
    public void setNotApplicableForDouble(Double na){
        notApplicableForDouble = na;
    }
    
    /**
     * BigIntegerNAl擾B<p>
     *
     * @return byteNAl
     */
    public BigInteger getNotApplicableForBigInteger(){
        return notApplicableForBigInteger;
    }
    
    /**
     * BigIntegerNAlݒ肷B<p>
     *
     * @param na BigIntegerNAl
     */
    public void setNotApplicableForBigInteger(BigInteger na){
        notApplicableForBigInteger = na;
    }
    
    /**
     * BigDecimalNAl擾B<p>
     *
     * @return byteNAl
     */
    public BigDecimal getNotApplicableForBigDecimal(){
        return notApplicableForBigDecimal;
    }
    
    /**
     * BigDecimalNAlݒ肷B<p>
     *
     * @param na BigDecimalNAl
     */
    public void setNotApplicableForBigDecimal(BigDecimal na){
        notApplicableForBigDecimal = na;
    }
    
    /**
     * byteNAl̕擾B<p>
     *
     * @return byteNAl̕
     */
    public String getNotApplicableStringForByte(){
        return notApplicableStringForByte;
    }
    
    /**
     * byteNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na byteNAl̕
     */
    public void setNotApplicableStringForByte(String na){
        notApplicableStringForByte = na;
    }
    
    /**
     * shortNAl̕擾B<p>
     *
     * @return shortNAl̕
     */
    public String getNotApplicableStringForShort(){
        return notApplicableStringForShort;
    }
    
    /**
     * shortNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na shortNAl̕
     */
    public void setNotApplicableStringForShort(String na){
        notApplicableStringForShort = na;
    }
    
    /**
     * intNAl̕擾B<p>
     *
     * @return intNAl̕
     */
    public String getNotApplicableStringForInt(){
        return notApplicableStringForInt;
    }
    
    /**
     * intNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na intNAl̕
     */
    public void setNotApplicableStringForInt(String na){
        notApplicableStringForInt = na;
    }
    
    /**
     * longNAl̕擾B<p>
     *
     * @return longNAl̕
     */
    public String getNotApplicableStringForLong(){
        return notApplicableStringForLong;
    }
    
    /**
     * longNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na longNAl̕
     */
    public void setNotApplicableStringForLong(String na){
        notApplicableStringForLong = na;
    }
    
    /**
     * floatNAl̕擾B<p>
     *
     * @return floatNAl̕
     */
    public String getNotApplicableStringForFloat(){
        return notApplicableStringForFloat;
    }
    
    /**
     * floatNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na floatNAl̕
     */
    public void setNotApplicableStringForFloat(String na){
        notApplicableStringForFloat = na;
    }
    
    /**
     * doubleNAl̕擾B<p>
     *
     * @return doubleNAl̕
     */
    public String getNotApplicableStringForDouble(){
        return notApplicableStringForDouble;
    }
    
    /**
     * doubleNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na doubleNAl̕
     */
    public void setNotApplicableStringForDouble(String na){
        notApplicableStringForDouble = na;
    }
    
    /**
     * BigIntegerNAl̕擾B<p>
     *
     * @return BigIntegerNAl̕
     */
    public String getNotApplicableStringForBigInteger(){
        return notApplicableStringForBigInteger;
    }
    
    /**
     * BigIntegerNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na BigIntegerNAl̕
     */
    public void setNotApplicableStringForBigInteger(String na){
        notApplicableStringForBigInteger = na;
    }
    
    /**
     * BigDecimalNAl̕擾B<p>
     *
     * @return BigDecimalNAl̕
     */
    public String getNotApplicableStringForBigDecimal(){
        return notApplicableStringForBigDecimal;
    }
    
    /**
     * BigDecimalNAl̕ݒ肷B<p>
     * ftHǵAnullB<br>
     *
     * @param na BigDecimalNAl̕
     */
    public void setNotApplicableStringForBigDecimal(String na){
        notApplicableStringForBigDecimal = na;
    }
    
    /**
     * w肳ꂽIuWFNgϊB<p>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{
        
        switch(convertType){
        case NUMBER_TO_STRING:
            if(isUseNotApplicable){
                if(obj instanceof Byte){
                    if((notApplicableForByte == null && obj == null)
                        || (notApplicableForByte != null
                                && notApplicableForByte.equals(obj))){
                        return notApplicableStringForByte;
                    }
                }else if(obj instanceof Short){
                    if((notApplicableForShort == null && obj == null)
                        || (notApplicableForShort != null
                                && notApplicableForShort.equals(obj))){
                        return notApplicableStringForShort;
                    }
                }else if(obj instanceof Integer){
                    if((notApplicableForInt == null && obj == null)
                        || (notApplicableForInt != null
                                && notApplicableForInt.equals(obj))){
                        return notApplicableStringForInt;
                    }
                }else if(obj instanceof Long){
                    if((notApplicableForLong == null && obj == null)
                        || (notApplicableForLong != null
                                && notApplicableForLong.equals(obj))){
                        return notApplicableStringForLong;
                    }
                }else if(obj instanceof Float){
                    if((notApplicableForFloat == null && obj == null)
                        || (notApplicableForFloat != null
                                && notApplicableForFloat.equals(obj))){
                        return notApplicableStringForFloat;
                    }
                }else if(obj instanceof Double){
                    if((notApplicableForDouble == null && obj == null)
                        || (notApplicableForDouble != null
                                && notApplicableForDouble.equals(obj))){
                        return notApplicableStringForDouble;
                    }
                }else if(obj instanceof BigInteger){
                    if((notApplicableForBigInteger == null && obj == null)
                        || (notApplicableForBigInteger != null
                                && notApplicableForBigInteger.equals(obj))){
                        return notApplicableStringForBigInteger;
                    }
                }else if(obj instanceof BigDecimal){
                    if((notApplicableForBigDecimal == null && obj == null)
                        || (notApplicableForBigDecimal != null
                                && notApplicableForBigDecimal.equals(obj))){
                        return notApplicableStringForBigDecimal;
                    }
                }
            }
            if(obj == null){
                return new DecimalFormat(format).format(new Long(0));
            }
            return new DecimalFormat(format).format(obj);
        case STRING_TO_NUMBER:
            if(isUseNotApplicable){
                if((notApplicableStringForByte == null && obj == null)
                    || (notApplicableStringForByte != null
                            && notApplicableStringForByte.equals(obj))){
                    return notApplicableForByte;
                }
                if((notApplicableStringForShort == null && obj == null)
                    || (notApplicableStringForShort != null
                            && notApplicableStringForShort.equals(obj))){
                    return notApplicableForShort;
                }
                if((notApplicableStringForInt == null && obj == null)
                    || (notApplicableStringForInt != null
                            && notApplicableStringForInt.equals(obj))){
                    return notApplicableForInt;
                }
                if((notApplicableStringForLong == null && obj == null)
                    || (notApplicableStringForLong != null
                            && notApplicableStringForLong.equals(obj))){
                    return notApplicableForLong;
                }
                if((notApplicableStringForFloat == null && obj == null)
                    || (notApplicableStringForFloat != null
                            && notApplicableStringForFloat.equals(obj))){
                    return notApplicableForFloat;
                }
                if((notApplicableStringForDouble == null && obj == null)
                    || (notApplicableStringForDouble != null
                            && notApplicableStringForDouble.equals(obj))){
                    return notApplicableForDouble;
                }
                if((notApplicableStringForBigInteger == null && obj == null)
                    || (notApplicableStringForBigInteger != null
                            && notApplicableStringForBigInteger.equals(obj))){
                    return notApplicableForBigInteger;
                }
                if((notApplicableStringForBigDecimal == null && obj == null)
                    || (notApplicableStringForBigDecimal != null
                            && notApplicableStringForBigDecimal.equals(obj))){
                    return notApplicableForBigDecimal;
                }
            }
            if(obj == null){
                return new Long(0);
            }
            if(obj instanceof String){
                final String val = (String)obj;
                if(DOUBLE_NAN_STR.equals(val)){
                    return new Double(Double.NaN);
                }else if(DOUBLE_NEGATIVE_INFINITY_STR.equals(val)){
                    return new Double(Double.NEGATIVE_INFINITY);
                }else if(DOUBLE_POSITIVE_INFINITY_STR.equals(val)){
                    return new Double(Double.POSITIVE_INFINITY);
                }
            }
            try{
                return new DecimalFormat(format).parse((String)obj);
            }catch(ParseException e){
                throw new ConvertException(e);
            }
        default:
            throw new ConvertException(
                "Invalid convert type : " + convertType
            );
        }
    }
}
