/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.io.Serializable;
import java.sql.*;
import javax.sql.DataSource;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.jndi.*;

/**
 * f[^\[XRlNVt@NgB<p>
 * JNDIAw肳ꂽf[^\[X̃f[^\[X擾āARlNV擾B<br>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="ConnectionFactory"
 *                  code="jp.ossc.nimbus.service.sql.DataSourceConnectionFactoryService"&gt;
 *             &lt;attribute name="Name"&gt;java:DefaultDS&lt;/attribute&gt;
 *             &lt;attribute name="JndiFinderServiceName"&gt;#DataSourceFinder&lt;/attribute&gt;
 *             &lt;depends&gt;DataSourceFinder&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="DataSourceFinder"
 *                  code="jp.ossc.nimbus.service.jndi.DefaultJndiFinderService"&gt;
 *             &lt;attribute name="Environment"&gt;
 *                 java.naming.factory.initial=org.jnp.interfaces.NamingContextFactory
 *                 java.naming.factory.url.pkgs=org.jboss.naming:org.jnp.interfaces
 *                 java.naming.provider.url=localhost
 *             &lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 * @see jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder
 */
public class DataSourceConnectionFactoryService extends ServiceBase
 implements ConnectionFactory, DataSourceConnectionFactoryServiceMBean, Serializable{
    
    private static final long serialVersionUID = -5837939620922806932L;
    
    /**
     * f[^\[XB<p>
     */
    private String dataSourceName;
    
    /**
     * {@link JndiFinder}IuWFNgB<p>
     */
    private JndiFinder jndiFinder;
    
    /**
     * {@link JndiFinder}T[rXB<p>
     */
    private ServiceName jndiFinderName;
    
    /**
     * {@link Context}IuWFNgB<p>
     */
    private Context<?, ?> context;
    
    /**
     * {@link Context}T[rXB<p>
     */
    private ServiceName contextName;
    
    /**
     * {@link Context}̃f[^\[X̃L[B<p>
     */
    private String dataSourceNameKey = DEFAULT_DATASOURCE_NAME_KEY;
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public void setName(String name){
        dataSourceName = name;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public String getName(){
        return dataSourceName;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public void setJndiFinderServiceName(ServiceName name){
        jndiFinderName = name;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public ServiceName getJndiFinderServiceName(){
        return jndiFinderName;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public JndiFinder getJndiFinderService(){
        return jndiFinder;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public void setJndiFinderService(JndiFinder finder){
        jndiFinder = finder;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public void setContextServiceName(ServiceName name){
        contextName = name;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public ServiceName getContextServiceName(){
        return contextName;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public Context<?, ?> getContextService(){
        return context;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public void setContextService(Context<?, ?> context){
        this.context = context;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public void setDataSourceNameKey(String key){
        dataSourceNameKey = key;
    }
    
    // DataSourceConnectionFactoryServiceMBeanJavaDoc
    public String getDataSourceNameKey(){
        return dataSourceNameKey;
    }
    
    /**
     * JnsB<p>
     * {@link JndiFinder}T[rXݒ肳ĂȂꍇ͗OthrowB<br>
     * f[^\[Xݒ肳ĂȂꍇ͗OthrowB<br>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        
        if(getJndiFinderServiceName() != null){
            jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(
                getJndiFinderServiceName()
            );
        } else if(jndiFinder == null) {
            throw new IllegalArgumentException("Argument : JndiFinderName or JndiFinder is null.");
        }
        
        if(getContextServiceName() != null){
            context = ServiceManagerFactory.getServiceObject(
                getContextServiceName()
            );
        }
        if(context == null && getName() == null){
            throw new IllegalArgumentException("DataSource name is null.");
        }
    }
    
    // ConnectionFactoryJavaDoc
    public Connection getConnection() throws ConnectionFactoryException{
        Connection con = null;
        try{
            String name = getName();
            if(context != null){
                final String tmpName
                     = (String)context.get(getDataSourceNameKey());
                if(tmpName != null){
                    name = tmpName;
                }
            }
            final DataSource dataSource
                 = (DataSource)jndiFinder.lookup(name);
            con = dataSource.getConnection();
        }catch(SQLException e){
            throw new ConnectionFactoryException(e);
        }catch(javax.naming.NamingException e){
            throw new ConnectionFactoryException(e);
        }
        return con;
    }
}
