/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.semaphore;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link DefaultSemaphoreService}MBeanC^[tFCXB<p>
 * 
 * @author H.Nakano
 */
public interface DefaultSemaphoreServiceMBean extends ServiceBaseMBean{
    
    /**
     * Z}tH̃\[XԂB<p>
     *
     * @return \[X
     */
    public int getResourceCapacity() ;
    
    /**
     * Z}tH̃\[Xݒ肷B<p>
     *
     * @param capa \[X
     */
    public void setResourceCapacity(int capa) ;
    
    /**
     * Z}tHɑ΂Ė擾҂Xbhsleep鎞Ԃݒ肷B<p>
     * Z}tH҂̐擪łȂꍇ́AĂsleepB<br>
     *
     * @param millis Z}tHɑ΂Ė擾҂Xbhsleep鎞[ms]
     */
    public void setSleepTime(long millis);
    
    /**
     * Z}tHɑ΂Ė擾҂Xbhsleep鎞Ԃ擾B<p>
     *
     * @return Z}tHɑ΂Ė擾҂Xbhsleep鎞[ms]
     */
    public long getSleepTime();
    
    /**
     * \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]ݒ肷B<p>
     * \[X󂢂Ăđ҂ĂXbhꍇ́ÃXbhNB<br>
     * ftHǵA`FbNȂB
     *
     * @param millis \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]
     */
    public void setCheckInterval(long millis);
    
    /**
     * \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]擾B<p>
     *
     * @return \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]
     */
    public long getCheckInterval();
    
    /**
     * Z}tHl܂ł̍ő҂[ms]擾B<p>
     *
     * @return ő҂[ms]
     */
    public long getTimeoutMillis();
    
    /**
     * Z}tHl܂ł̍ő҂[ms]ݒ肷B<p>
     *
     * @param timeout ő҂[ms]
     */
    public void setTimeoutMillis(long timeout);
    
    /**
     * Z}tHl҂̍ő吔擾B<p>
     *
     * @return ő哯l҂
     */
    public int getMaxWaitCount();
    
    /**
     * Z}tHl҂̍ő吔ݒ肷B<p>
     *
     * @param count ő哯l҂
     */
    public void setMaxWaitCount(int count);
    
    /**
     * Z}tHl̋Z}tHJ[ms]擾B<p>
     *
     * @return Z}tHJ
     */
    public long getForceFreeTimeoutMillis();
    
    /**
     * Z}tHl̋Z}tHJ[ms]ݒ肷B<p>
     *
     * @param timeout Z}tHJ
     */
    public void setForceFreeTimeoutMillis(long timeout);
    
    /**
     * [\[X̎擾Ɖ̃Xbh֘At邩ǂݒ肷B<p>
     * ftHgtrueŁA\[X擾Xbh̉󂯕tȂB<br>
     * ܂Afalseɂꍇ́A^CAEg͖ƂȂB<br>
     *
     * @param isBinding \[X擾Xbh̉󂯕tȂ悤ɂꍇ́Atrue
     */
    public void setThreadBinding(boolean isBinding);
    
    /**
     * [\[X̎擾Ɖ̃Xbh֘At邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A\[X擾Xbh̉󂯕tȂ
     */
    public boolean isThreadBinding();
    
    /**
     * Z}tH̎c胊\[XԂB<p>
     *
     * @return \[X
     */
    public int getResourceRemain();
    
    /**
     * Z}tH擾҂Ă鐔擾B<p>
     * 
     * @return Z}tH擾҂Ă鐔
     */
    public int getWaitingCount();
    
    /**
     * Z}tHl҂XbhJAZ}tHl҂󂯕tȂ悤ɂB<p>
     */
    public void release();
    
    /**
     * Z}tHl҂̎tJnB<p>
     * {@link #release()}ďoɁAZ}tHl҂󂯕t悤ɂB
     */
    public void accept();
    
    /**
     * Z}tH̍őgpт擾B<p>
     *
     * @return őgp
     */
    public int getMaxUsedResource();
    
    /**
     * Z}tH̍ő҂т擾B<p>
     *
     * @return ő҂
     */
    public int getMaxWaitedCount();
}
