/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import jp.ossc.nimbus.core.*;

/**
 * {@link JMSSchedulerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface JMSSchedulerServiceMBean
 extends AbstractSchedulerServiceMBean{
    
    /**
     * JMSSession𐶐{@link jp.ossc.nimbus.service.jms.JMSSessionFactory JMSSessionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JMSSessionFactoryT[rX̃T[rX
     */
    public void setJMSSessionFactoryServiceName(ServiceName name);
    
    /**
     * JMSSession𐶐{@link jp.ossc.nimbus.service.jms.JMSSessionFactory JMSSessionFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSSessionFactoryT[rX̃T[rX
     */
    public ServiceName getJMSSessionFactoryServiceName();
    
    /**
     * JMSMessageProducer𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageProducerFactory JMSMessageProducerFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JMSMessageProducerFactoryT[rX̃T[rX
     */
    public void setJMSMessageProducerFactoryServiceName(ServiceName name);
    
    /**
     * JMSMessageProducer𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageProducerFactory JMSMessageProducerFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSMessageProducerFactoryT[rX̃T[rX
     */
    public ServiceName getJMSMessageProducerFactoryServiceName();
    
    /**
     * JMSMessageConsumer𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory JMSMessageConsumerFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JMSMessageConsumerFactoryT[rX̃T[rX
     */
    public void setJMSMessageConsumerFactoryServiceName(ServiceName name);
    
    /**
     * JMSMessageConsumer𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory JMSMessageConsumerFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSMessageConsumerFactoryT[rX̃T[rX
     */
    public ServiceName getJMSMessageConsumerFactoryServiceName();
    
    /**
     * JMS̈悩瓊ꂽXPW[oMessageConsumerXbh̐ݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param size MessageConsumerXbh̐
     */
    public void setMessageConsumerSize(int size);
    
    /**
     * JMS̈悩瓊ꂽXPW[oMessageConsumerXbh̐擾B<p>
     *
     * @return MessageConsumerXbh̐
     */
    public int getMessageConsumerSize();
    
    /**
     * XPW[JMS̈ɓ鎞̔zM[hݒ肷B<p>
     * ftHǵA{@link javax.jms.Message#DEFAULT_DELIVERY_MODE}B<br>
     *
     * @param mode zM[h
     */
    public void setDeliveryMode(int mode);
    
    /**
     * XPW[JMS̈ɓ鎞̔zM[h擾B<p>
     *
     * @return zM[h
     */
    public int getDeliveryMode();
    
    /**
     * XPW[JMS̈ɓ鎞̗D揇ʂݒ肷B<p>
     * ftHǵA{@link javax.jms.Message#DEFAULT_PRIORITY}B<br>
     *
     * @param priority D揇
     */
    public void setPriority(int priority);
    
    /**
     * XPW[JMS̈ɓ鎞̗D揇ʂ擾B<p>
     *
     * @return D揇
     */
    public int getPriority();
    
    /**
     * XPW[JMS̈ɓ鎞̐[ms]ݒ肷B<p>
     * ftHǵA{@link javax.jms.Message#DEFAULT_TIME_TO_LIVE}B<br>
     *
     * @param millis [ms]
     */
    public void setTimeToLive(long millis);
    
    /**
     * XPW[JMS̈ɓ鎞̐[ms]擾B<p>
     *
     * @return [ms]
     */
    public long getTimeToLive();
}
