/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;
import java.io.Serializable;
import java.text.SimpleDateFormat;

/**
 * ftHgXPW[B<p>
 *
 * @author M.Takata
 */
public class DefaultSchedule
 implements Schedule, Serializable{
    
    private static final long serialVersionUID = -2668833951199708052L;
    
    protected String id;
    
    protected String masterId;
    
    protected Date time;
    
    protected String taskName;
    
    protected Object input;
    
    protected String[] depends;
    
    protected Object output;
    
    protected boolean isRetry;
    
    protected Date initialTime;
    
    protected long retryInterval;
    
    protected Date retryEndTime;
    
    protected long maxDelayTime;
    
    protected int state = Schedule.STATE_INITIAL;
    
    protected int controlState = Schedule.CONTROL_STATE_INITIAL;
    
    protected int checkState = Schedule.CHECK_STATE_INITIAL;
    
    protected String executorKey;
    
    protected String executorType;
    
    protected Date executeStartTime;
    
    protected Date executeEndTime;
    
    /**
     * ̃CX^X𐶐B<p>
     */
    public DefaultSchedule(){
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param id XPW[ID
     */
    public DefaultSchedule(String id){
        setId(id);
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param time XPW[
     */
    public DefaultSchedule(Date time){
        setTime(time);
        setInitialTime(time);
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param masterId XPW[}X^ID
     * @param time XPW[
     * @param taskName ^XN
     * @param input ̓f[^
     * @param depends ˑXPW[}X^ID̔z
     * @param executorKey ScheduleExecutor肷L[
     * @param executorType ScheduleExecutor̎
     */
    public DefaultSchedule(
        String masterId,
        Date time,
        String taskName,
        Object input,
        String[] depends,
        String executorKey,
        String executorType
    ){
        this(masterId, time, taskName, input, depends, executorKey, executorType, 0, null, 0);
    }
    
    /**
     * CX^X𐶐B<p>
     *
     * @param masterId XPW[}X^ID
     * @param time XPW[
     * @param taskName ^XN
     * @param input ̓f[^
     * @param depends ˑXPW[}X^ID̔z
     * @param executorKey ScheduleExecutor肷L[
     * @param executorType ScheduleExecutor̎
     * @param retryInterval gCԊu[ms]
     * @param retryEndTime gCI
     * @param maxDelayTime őx[ms]
     */
    public DefaultSchedule(
        String masterId,
        Date time,
        String taskName,
        Object input,
        String[] depends,
        String executorKey,
        String executorType,
        long retryInterval,
        Date retryEndTime,
        long maxDelayTime
    ){
        setMasterId(masterId);
        setTime(time);
        setTaskName(taskName);
        setInput(input);
        setDepends(depends);
        setExecutorKey(executorKey);
        setExecutorType(executorType);
        setInitialTime(time);
        setRetryInterval(retryInterval);
        setRetryEndTime(retryEndTime);
        setMaxDelayTime(maxDelayTime);
    }
    
    // ScheduleJavaDoc
    public String getId(){
        return id;
    }
    
    // ScheduleJavaDoc
    public void setId(String id){
        this.id = id;
    }
    
    // ScheduleJavaDoc
    public String getMasterId(){
        return masterId;
    }
    
    /**
     * XPW[}X^IDݒ肷B<p>
     *
     * @param id XPW[}X^ID
     */
    public void setMasterId(String id){
        masterId = id;
    }
    
    // ScheduleJavaDoc
    public Date getTime(){
        return time;
    }
    
    // ScheduleJavaDoc
    public void setTime(Date time){
        this.time = time;
    }
    
    // ScheduleJavaDoc
    public String getTaskName(){
        return taskName;
    }
    
    /**
     * XPW[ꂽ^XNݒ肷B<p>
     *
     * @param name ^XN
     */
    public void setTaskName(String name){
        taskName = name;
    }
    
    // ScheduleJavaDoc
    public Object getInput(){
        return input;
    }
    
    /**
     * XPW[̓̓f[^ݒ肷B<p>
     *
     * @param data ̓f[^
     */
    public void setInput(Object data){
        input = data;
    }
    
    // ScheduleMasterJavaDoc
    public String[] getDepends(){
        return depends;
    }
    
    /**
     * ˑXPW[}X^IDݒ肷B<p>
     *
     * @param ids XPW[}X^ID̔z
     */
    public void setDepends(String[] ids){
        depends = ids;
    }
    
    // ScheduleJavaDoc
    public Object getOutput(){
        return output;
    }
    
    // ScheduleJavaDoc
    public void setOutput(Object out){
        output = out;
    }
    
    // ScheduleJavaDoc
    public Date getInitialTime(){
        return initialTime == null ? time : initialTime;
    }
    
    /**
     * ŏɃXPW[ꂽݒ肷B<p>
     *
     * @param time ŏɃXPW[ꂽ
     */
    public void setInitialTime(Date time){
        initialTime = time;
    }
    
    // ScheduleJavaDoc
    public long getRetryInterval(){
        return retryInterval;
    }
    
    /**
     * XPW[gCsԊu[ms]ݒ肷B<p>
     *
     * @param interval gCsԊu
     */
    public void setRetryInterval(long interval){
        retryInterval = interval;
    }
    
    // ScheduleJavaDoc
    public Date getRetryEndTime(){
        return retryEndTime;
    }
    
    /**
     * XPW[gCIݒ肷B<p>
     *
     * @param time XPW[gCI
     */
    public void setRetryEndTime(Date time){
        retryEndTime = time;
    }
    
    // ScheduleJavaDoc
    public boolean isRetry(){
        return isRetry;
    }
    
    // ScheduleJavaDoc
    public void setRetry(boolean retry){
        isRetry = retry;
    }
    
    // ScheduleJavaDoc
    public long getMaxDelayTime(){
        return maxDelayTime;
    }
    
    /**
     * XPW[̍őx[ms]ݒ肷B<p>
     *
     * @param time XPW[őx
     */
    public void setMaxDelayTime(long time){
        maxDelayTime = time;
    }
    
    // ScheduleJavaDoc
    public int getState(){
        return state;
    }
    
    // ScheduleJavaDoc
    public void setState(int state){
        this.state = state;
    }
    
    // ScheduleJavaDoc
    public int getControlState(){
        return controlState;
    }
    
    // ScheduleJavaDoc
    public void setControlState(int state){
        controlState = state;
    }
    
    // ScheduleJavaDoc
    public int getCheckState(){
        return checkState;
    }
    
    // ScheduleJavaDoc
    public void setCheckState(int state){
        checkState = state;
    }
    
    // ScheduleJavaDoc
    public void setExecutorKey(String key){
        executorKey = key;
    }
    
    // ScheduleJavaDoc
    public String getExecutorKey(){
        return executorKey;
    }
    
    // ScheduleMasterJavaDoc
    public void setExecutorType(String type){
        executorType = type;
    }
    
    // ScheduleMasterJavaDoc
    public String getExecutorType(){
        return executorType;
    }
    
    // ScheduleJavaDoc
    public Date getExecuteStartTime(){
        return executeStartTime;
    }
    
    // ScheduleJavaDoc
    public void setExecuteStartTime(Date time){
        executeStartTime = time;
    }
    
    // ScheduleJavaDoc
    public Date getExecuteEndTime(){
        return executeEndTime;
    }
    
    // ScheduleJavaDoc
    public void setExecuteEndTime(Date time){
        executeEndTime = time;
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    public int hashCode(){
        return id == null ? 0 : id.hashCode();
    }
    
    /**
     * w肳ꂽIuWFNg̃CX^XƓǂ𔻒肷B<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return w肳ꂽIuWFNg̃CX^XƓꍇtrue
     */
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj == this){
            return true;
        }
        if(!(obj instanceof Schedule)){
            return false;
        }
        Schedule cmp = (Schedule)obj;
        return (id == null && cmp.getId() == null)
            || (id != null && id.equals(cmp.getId()));
    }
    
    // ComparableJavaDoc
    public int compareTo(Schedule o){
        if(o == null){
            return -1;
        }
        if(o == this){
            return 0;
        }
        final Schedule cmp = o;
        if(time != null && cmp.getTime() == null){
            return -1;
        }
        if(time == null && cmp.getTime() != null){
            return 1;
        }
        if(time != null && cmp.getTime() != null){
            int result = time.compareTo(cmp.getTime());
            if(result != 0){
                return result;
            }
        }
        if(id == null && cmp.getId() == null){
            return 0;
        }
        if(id != null && cmp.getId() == null){
            return -1;
        }
        if(id == null && cmp.getId() != null){
            return 1;
        }
        return id.compareTo(cmp.getId());
    }
    
    /**
     * ̃CX^X̕\擾B<p>
     *
     * @return \
     */
    public String toString(){
        final SimpleDateFormat format
            = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
        final StringBuilder buf = new StringBuilder(super.toString());
        buf.append('{');
        buf.append("id=").append(id);
        buf.append(",masterId=").append(masterId);
        buf.append(",time=").append(time == null ? null : format.format(time));
        buf.append(",taskName=").append(taskName);
        buf.append(",input=").append(input);
        buf.append(",depends=");
        if(depends == null || depends.length == 0){
            buf.append((Object)null);
        }else{
            buf.append('[');
            for(int i = 0; i < depends.length; i++){
                buf.append(depends[i]);
                if(i != depends.length - 1){
                    buf.append(',');
                }
            }
            buf.append(']');
        }
        buf.append(",output=").append(output);
        buf.append(",isRetry=").append(isRetry);
        buf.append(",initialTime=").append(initialTime == null ? null : format.format(initialTime));
        buf.append(",retryInterval=").append(retryInterval);
        buf.append(",retryEndTime=")
            .append(retryEndTime == null ? null : format.format(retryEndTime));
        buf.append(",maxDelayTime=").append(maxDelayTime);
        buf.append(",state=").append(state);
        buf.append(",controlState=").append(controlState);
        buf.append(",checkState=").append(checkState);
        buf.append(",executorKey=").append(executorKey);
        buf.append(",executorType=").append(executorType);
        buf.append(",executeStartTime=")
            .append(executeStartTime == null ? null : format.format(executeStartTime));
        buf.append(",executeEndTime=")
            .append(executeEndTime == null ? null : format.format(executeEndTime));
        buf.append('}');
        return buf.toString();
    }
}