/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

/**
 * bZ[WMp̃RlNVC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface RequestServerConnection extends ServerConnection{
    
    /**
     * vbZ[W𑗐MāAbZ[WMB<br>
     *
     * @param message bZ[W
     * @param replyCount Kvȉ
     * @param timeout ^CAEg
     * @return bZ[Wz
     * @exception MessageSendException bZ[W̑MɎsꍇ
     */
    public Message[] request(Message message, int replyCount, long timeout) throws MessageSendException;
    
    /**
     * vbZ[W𑗐MāAbZ[WMB<br>
     *
     * @param message bZ[W
     * @param responseSubject TuWFNg
     * @param responseKey L[
     * @param replyCount Kvȉ
     * @param timeout ^CAEg
     * @return bZ[Wz
     * @exception MessageSendException bZ[W̑MɎsꍇ
     */
    public Message[] request(Message message, String responseSubject, String responseKey, int replyCount, long timeout) throws MessageSendException;
    
    /**
     * vbZ[W𑗐MāAbZ[WR[obNMB<br>
     *
     * @param message bZ[W
     * @param replyCount Kvȉ
     * @param timeout ^CAEg
     * @param callback bZ[WMp̃R[obN
     * @exception MessageSendException bZ[W̑MɎsꍇ
     */
    public void request(Message message, int replyCount, long timeout, ResponseCallBack callback) throws MessageSendException;
    
    /**
     * vbZ[W𑗐MāAbZ[WR[obNMB<br>
     *
     * @param message bZ[W
     * @param responseSubject TuWFNg
     * @param responseKey L[
     * @param replyCount Kvȉ
     * @param timeout ^CAEg
     * @param callback bZ[WMp̃R[obN
     * @exception MessageSendException bZ[W̑MɎsꍇ
     */
    public void request(Message message, String responseSubject, String responseKey, int replyCount, long timeout, ResponseCallBack callback) throws MessageSendException;
    
    /**
     * bZ[W𑗐MB<p>
     *
     * @param sourceId MID
     * @param sequence ʔ
     * @param message bZ[W
     * @exception MessageSendException bZ[W̑MɎsꍇ
     */
    public void response(Object sourceId, int sequence, Message message) throws MessageSendException;
    
    /**
     * bZ[WMp̃R[obNC^tF[XB<p>
     *
     * @author M.Takata
     */
    public interface ResponseCallBack{
        
        /**
         * ꂽbZ[WMB<p>
         *
         * @param message bZ[WB^CAEgꍇA܂̓bZ[Wv鑊肪Ȃꍇ́Anull
         * @param isLast ŏIbZ[W̏ꍇtrueԂB܂A^CAEgꍇA܂̓bZ[Wv鑊肪Ȃꍇtrue
         */
        public void onResponse(Message message, boolean isLast);
    }
}