/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.io.*;
import java.util.*;
import java.util.zip.*;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.params.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.http.*;
import jp.ossc.nimbus.util.converter.*;

/**
 * Jakarta HttpClientgHTTPNGXgۃNXB<p>
 *
 * @author M.Takata
 */
public abstract class HttpRequestImpl implements HttpRequest, Cloneable{
    
    public static final String HTTP_VERSION_0_9 = "0.9";
    public static final String HTTP_VERSION_1_0 = "1.0";
    public static final String HTTP_VERSION_1_1 = "1.1";
    
    /** wb_[ : Content-Type */
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    /** wb_[ : charset */
    protected static final String HEADER_CHARSET = "charset";
    /** wb_[ : Content-Encoding */
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    /** Content-Encoding : deflate */
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    /** Content-Encoding : gzip */
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    /** Content-Encoding : x-zip */
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    
    protected String actionName;
    protected String url;
    protected String httpVersion;
    protected Map<String, String[]> headerMap;
    protected String contentType;
    protected String characterEncoding;
    protected String queryString;
    protected Map<String, String[]> parameterMap;
    protected InputStream inputStream;
    protected ByteArrayOutputStream outputStream;
    protected boolean isDoAuthentication;
    protected boolean isFollowRedirects;
    protected Object inputObject;
    protected ServiceName streamConverterServiceName;
    protected StreamConverter streamConverter;
    protected byte[] inputBytes;
    protected int deflateLength = -1;
    protected Map<String, Object> httpMethodParamMap;
    
    // HttpRequestJavaDoc
    @Override
    public String getActionName(){
        return actionName;
    }
    
    /**
     * NGXgӂɎʂ_ANVݒ肷B<p>
     *
     * @param name ANV
     */
    public void setActionName(String name){
        actionName = name;
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getURL(){
        return url;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setURL(String url){
        this.url = url;
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getHttpVersion(){
        return httpVersion;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setHttpVersion(String version){
        httpVersion = version;
    }
    
    // HttpRequestJavaDoc
    @Override
    public Set<String> getHeaderNameSet(){
        return headerMap == null ? new HashSet<String>() : headerMap.keySet();
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getHeader(String name){
        final String[] headers = getHeaders(name);
        if(headers == null){
            return null;
        }
        return headers[0];
    }
    
    // HttpRequestJavaDoc
    @Override
    public String[] getHeaders(String name){
        if(headerMap == null){
            return null;
        }
        return headerMap.get(name);
    }
    
    /**
     * HTTPwb_̃}bv擾B<p>
     * HTTPwb_ݒ肳ĂȂꍇ́AnullB<br>
     *
     * @return HTTPwb_̃}bv
     */
    public Map<String, String[]> getHeaderMap(){
        return headerMap;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setHeader(String name, String value){
        if(headerMap == null){
            headerMap = new HashMap<String, String[]>();
        }
        headerMap.put(name, new String[]{value});
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setHeaders(String name, String[] value){
        if(headerMap == null){
            headerMap = new HashMap<String, String[]>();
        }
        headerMap.put(name, value);
    }
    
    // HttpRequestJavaDoc
    @Override
    public void addHeader(String name, String value){
        if(headerMap == null){
            headerMap = new HashMap<String, String[]>();
        }
        String[] vals = headerMap.get(name);
        if(vals == null){
            vals = new String[]{value};
            headerMap.put(name, vals);
        }else{
            final String[] newVals = new String[vals.length + 1];
            System.arraycopy(vals, 0, newVals, 0, vals.length);
            newVals[newVals.length - 1] = value;
            headerMap.put(name, newVals);
        }
    }
    
    /**
     * w肳ꂽwb_폜B<p>
     *
     * @param name wb_
     */
    public void removeHeader(String name){
        if(headerMap == null){
            return;
        }
        headerMap.remove(name);
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getContentType(){
        return contentType;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setContentType(String type){
        contentType = type;
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getCharacterEncoding(){
        return characterEncoding;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setCharacterEncoding(String encoding){
        characterEncoding = encoding;
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getQueryString(){
        return queryString;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setQueryString(String query){
        queryString = query;
    }
    
    // HttpRequestJavaDoc
    @Override
    public Set<String> getParameterNameSet(){
        return parameterMap == null ? new HashSet<String>() : parameterMap.keySet();
    }
    
    // HttpRequestJavaDoc
    @Override
    public String getParameter(String name){
        final String[] params = getParameters(name);
        if(params == null){
            return null;
        }
        return params[0];
    }
    
    // HttpRequestJavaDoc
    @Override
    public String[] getParameters(String name){
        if(parameterMap == null){
            return null;
        }
        return parameterMap.get(name);
    }
    
    /**
     * HTTPNGXgp[^̃}bv擾B<p>
     * HTTPNGXgp[^ݒ肳ĂȂꍇ́AnullB<br>
     *
     * @return HTTPNGXgp[^̃}bv
     */
    public Map<String, String[]> getParameterMap(){
        return parameterMap;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setParameter(String name, String value){
        if(parameterMap == null){
            parameterMap = new HashMap<String, String[]>();
        }
        String[] vals = (String[])parameterMap.get(name);
        if(vals == null){
            vals = new String[]{value};
            parameterMap.put(name, vals);
        }else{
            final String[] newVals = new String[vals.length + 1];
            System.arraycopy(vals, 0, newVals, 0, vals.length);
            newVals[newVals.length - 1] = value;
            parameterMap.put(name, newVals);
        }
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setParameters(String name, String[] value){
        if(parameterMap == null){
            parameterMap = new HashMap<String, String[]>();
        }
        parameterMap.put(name, value);
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setInputStream(InputStream is){
        inputStream = is;
    }
    
    // HttpRequestJavaDoc
    @Override
    public OutputStream getOutputStream(){
        if(outputStream == null){
            outputStream = new ByteArrayOutputStream();
        }
        return outputStream;
    }
    
    // HttpRequestJavaDoc
    @Override
    public void setObject(Object input){
        inputObject = input;
    }
    
    // HttpRequestJavaDoc
    @Override
    public Object getObject(){
        return inputObject;
    }
    
    /**
     * F؏𑗐M邩ǂݒ肷B<p>
     *
     * @param isDo F؏𑗐Mꍇtrue
     */
    public void setDoAuthentication(boolean isDo){
        isDoAuthentication = isDo;
    }
    
    /**
     * F؏𑗐M邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAF؏𑗐M
     */
    public boolean isDoAuthentication(){
        return isDoAuthentication;
    }
    
    /**
     * 304X|XMꍇɁAw肳ꂽURLɃ_CNg邩ǂݒ肷B<p>
     *
     * @param isRedirects _CNgꍇtrue
     */
    public void setFollowRedirects(boolean isRedirects){
        isFollowRedirects = isRedirects;
    }
    
    /**
     * 304X|XMꍇɁAw肳ꂽURLɃ_CNg邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA_CNg
     */
    public boolean isFollowRedirects(){
        return isFollowRedirects;
    }
    
    /**
     * Jakarta HttpClientHttpMethodParamsɐݒ肷p[^̏W擾B<p>
     *
     * @return p[^̏W
     */
    public Set<String> getHttpMethodParamNameSet(){
        return httpMethodParamMap == null ? new HashSet<String>() : httpMethodParamMap.keySet();
    }
    
    /**
     * Jakarta HttpClientHttpMethodParamsɐݒ肷p[^ݒ肷B<p>
     *
     * @param name p[^
     * @param value l
     */
    public void setHttpMethodParam(String name, Object value){
        if(httpMethodParamMap == null){
            httpMethodParamMap = new HashMap<String, Object>();
        }
        httpMethodParamMap.put(name, value);
    }
    
    /**
     * Jakarta HttpClientHttpMethodParamsɐݒ肷p[^擾B<p>
     *
     * @param name p[^
     * @return l
     */
    public Object getHttpMethodParam(String name){
        if(httpMethodParamMap == null){
            return null;
        }
        return httpMethodParamMap.get(name);
    }
    
    /**
     * Jakarta HttpClientHttpMethodParamsɐݒ肷p[^̃}bv擾B<p>
     *
     * @return HttpMethodParamsɐݒ肷p[^̃}bv
     */
    public Map<String, Object> getHttpMethodParamMap(){
        if(httpMethodParamMap == null){
            httpMethodParamMap = new HashMap<String, Object>();
        }
        return httpMethodParamMap;
    }
    
    /**
     * HTTPNGXgɐݒ肳ꂽ̓IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rXݒ肷B<p>
     *
     * @param name StreamConverterT[rX̃T[rX
     */
    public void setStreamConverterServiceName(ServiceName name){
        streamConverterServiceName = name;
    }
    
    /**
     * HTTPNGXgɐݒ肳ꂽ̓IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rX擾B<p>
     *
     * @return StreamConverterT[rX̃T[rX
     */
    public ServiceName getStreamConverterServiceName(){
        return streamConverterServiceName;
    }
    
    /**
     * HTTPNGXgɐݒ肳ꂽ̓IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}ݒ肷B<p>
     *
     * @param converter StreamConverter
     */
    public void setStreamConverter(StreamConverter converter){
        streamConverter = converter;
    }
    
    /**
     * HTTPNGXgɐݒ肳ꂽ̓IuWFNgXg[ɕϊ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}擾B<p>
     *
     * @return StreamConverter
     */
    public StreamConverter getStreamConverter(){
        return streamConverter;
    }
    
    /**
     * ̓Xg[kꍇ臒l[byte]ݒ肷B<p>
     * ݒ肵Ȃꍇ́A̓Xg[̃TCYɊւ炸kB<br>
     *
     * @param length 臒l[byte]
     */
    public void setDeflateLength(int length){
        deflateLength = length;
    }
    
    /**
     * ̓Xg[kꍇ臒l[byte]擾B<p>
     *
     * @return 臒l[byte]
     */
    public int getDeflateLength(){
        return deflateLength;
    }
    
    /**
     * ̓IuWFNgXg[ɕϊۂ̃oCgz擾B<p>
     *
     * @return ̓IuWFNgXg[ɕϊۂ̃oCgz
     */
    public byte[] getInputBytes(){
        return inputBytes;
    }
    
    /**
     * HTTP\bh𐶐B<p>
     *
     * @return HTTP\bh
     * @exception Exception HTTP\bh̐Ɏsꍇ
     */
    protected abstract HttpMethodBase instanciateHttpMethod() throws Exception;
    
    /**
     * HTTP\bhB<p>
     *
     * @param method HTTP\bh
     * @exception Exception HTTP\bh̏Ɏsꍇ
     */
    protected void initHttpMethod(HttpMethodBase method) throws Exception{
        if(url != null){
            method.setURI(new URI(url, true));
        }
        final HttpMethodParams params = method.getParams();
        if(httpMethodParamMap != null){
            for(Map.Entry<String, Object> entry : httpMethodParamMap.entrySet()){
                params.setParameter(entry.getKey(), entry.getValue());
            }
        }
        if(httpVersion != null){
            if(HTTP_VERSION_0_9.equals(httpVersion)){
                params.setVersion(HttpVersion.HTTP_0_9);
            }else if(HTTP_VERSION_1_0.equals(httpVersion)){
                params.setVersion(HttpVersion.HTTP_1_0);
            }else if(HTTP_VERSION_1_1.equals(httpVersion)){
                params.setVersion(HttpVersion.HTTP_1_1);
            }
        }
        if(contentType != null){
            final StringBuilder buf = new StringBuilder(contentType);
            if(characterEncoding != null){
                buf.append(';')
                   .append(HEADER_CHARSET)
                   .append('=')
                   .append(characterEncoding);
            }
            method.addRequestHeader(
                HEADER_CONTENT_TYPE,
                buf.toString()
            );
        }
        if(queryString != null){
            method.setQueryString(queryString);
        }
        if(parameterMap != null){
            initParameter(method, parameterMap);
        }
        if(inputStream != null){
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            final byte[] bytes = new byte[1024];
            int length = 0;
            while((length = inputStream.read(bytes)) != -1){
                baos.write(bytes, 0, length);
            }
            inputBytes = baos.toByteArray();
        }else if(outputStream != null && outputStream.size() != 0){
            inputBytes = outputStream.toByteArray();
        }else if(inputObject != null){
            if(streamConverter == null && streamConverterServiceName == null){
                throw new HttpRequestCreateException(
                    "StreamConverter is null."
                );
            }else{
                final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                final byte[] bytes = new byte[1024];
                int length = 0;
                StreamConverter converter = streamConverter;
                if(streamConverterServiceName != null){
                    converter = (StreamConverter)ServiceManagerFactory
                        .getServiceObject(streamConverterServiceName);
                }
                if(characterEncoding != null
                    && converter instanceof StreamStringConverter){
                    ((StreamStringConverter)converter)
                        .setCharacterEncodingToStream(characterEncoding);
                }
                InputStream is = converter.convertToStream(inputObject);
                while((length = is.read(bytes)) != -1){
                    baos.write(bytes, 0, length);
                }
                inputBytes = baos.toByteArray();
            }
        }
        if(inputBytes == null){
            removeHeader(HEADER_CONTENT_ENCODING);
        }else{
            initInputStream(
                method,
                compress(inputBytes)
            );
        }
        if(headerMap != null){
            for(Map.Entry<String, String[]> entry : headerMap.entrySet()){
                final String name = entry.getKey();
                final String[] vals = entry.getValue();
                for(int i = 0; i < vals.length; i++){
                    if(HEADER_CONTENT_TYPE.equals(name)
                        && method.getRequestHeader(name) != null){
                        continue;
                    }
                    method.addRequestHeader(name, vals[i]);
                }
            }
        }
        if(isDoAuthentication != method.getDoAuthentication()){
            method.setDoAuthentication(isDoAuthentication);
        }
        if(isFollowRedirects != method.getFollowRedirects()){
            method.setFollowRedirects(isFollowRedirects);
        }
    }
    
    /**
     * ̓Xg[kB<p>
     * (Content-EncodingɎw肳ꂽňk)
     * 
     * @param inputBytes ̓oCgz
     * @return kꂽ̓Xg[
     * @throws IOException T|[gĂȂk`(deflate, gzipȊO)w肳ꂽꍇ
     */
    protected InputStream compress(byte[] inputBytes) throws IOException {
        // wb_[[Content-Encoding]̒l擾
        String encode = getHeader(HEADER_CONTENT_ENCODING);
        if(encode == null){
            return new ByteArrayInputStream(inputBytes);
        }
        if((encode.indexOf(CONTENT_ENCODING_DEFLATE) == -1
                && encode.indexOf(CONTENT_ENCODING_GZIP) == -1
                && encode.indexOf(CONTENT_ENCODING_X_GZIP) == -1)
             || (deflateLength != -1 && inputBytes.length < deflateLength)){
            removeHeader(HEADER_CONTENT_ENCODING);
            return new ByteArrayInputStream(inputBytes);
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = baos;
        if(encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1){
            // deflatek
            os = new DeflaterOutputStream(os);
        }else if(encode.indexOf(CONTENT_ENCODING_GZIP) != -1
                    || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1){
            // gzipk
            os = new GZIPOutputStream(os);
        }else{
            throw new IOException("Can not compress. [" + encode + "]");
        }
        os.write(inputBytes, 0, inputBytes.length);
        os.flush();
        os.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
    
    /**
     * HTTP\bh̃NGXgp[^B<p>
     *
     * @param method HTTP\bh
     * @param params NGXgp[^
     * @exception Exception HTTP\bh̃NGXgp[^̏Ɏsꍇ
     */
    protected abstract void initParameter(
        HttpMethodBase method,
        Map<String, String[]> params
    ) throws Exception;
    
    /**
     * HTTP\bh̃NGXg{fBB<p>
     *
     * @param method HTTP\bh
     * @param is ̓Xg[
     * @exception Exception HTTP\bh̃NGXg{fB̏Ɏsꍇ
     */
    protected abstract void initInputStream(
        HttpMethodBase method,
        InputStream is
    ) throws Exception;
    
    /**
     * HTTP\bh𐶐B<p>
     *
     * @return HTTP\bh
     * @exception HttpRequestCreateException HTTP\bh̐Ɏsꍇ
     */
    public HttpMethodBase createHttpMethod() throws HttpRequestCreateException{
        HttpMethodBase httpMethod = null;
        try{
            httpMethod = instanciateHttpMethod();
            initHttpMethod(httpMethod);
        }catch(HttpRequestCreateException e){
            throw e;
        }catch(Exception e){
            throw new HttpRequestCreateException(e);
        }
        return httpMethod;
    }
    
    /**
     * 𐶐B<p>
     *
     * @return 
     * @exception CloneNotSupportedException Ɏsꍇ
     */
    public Object clone() throws CloneNotSupportedException{
        final HttpRequestImpl clone = (HttpRequestImpl)super.clone();
        if(clone.headerMap != null){
            clone.headerMap = new HashMap<String, String[]>(headerMap);
        }
        if(clone.parameterMap != null){
            clone.parameterMap = new HashMap<String, String[]>(parameterMap);
        }
        return clone;
    }
}
