/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.distribute;

import jp.ossc.nimbus.core.*;

/**
 * SMTPT[o`FbJ[̊ǗC^[tFCXB<p>
 *
 * @author H.Nakano
 */
public interface SmtpKeepAliveCheckerServiceMBean extends ServiceBaseMBean, SmtpKeepAliveChecker{
    
    /**
     * SMTPT[o`FbNŁASMTPT[o񂾎ɏo͂郍ÕbZ[WIDB<p>
     */
    public static final String SMTP_SERVER_DEAD_MSG_ID = "SMTP_00001";
    
    /**
     * SMTPT[o`FbNŁASMTPT[oAɏo͂郍ÕbZ[WIDB<p>
     */
    public static final String SMTP_SERVER_RECOVER_MSG_ID = "SMTP_00002";
    
    /**
     * SMTPT[õzXgݒ肷B<p>
     *
     * @param hostName SMTPT[õzXg
     */
    public void setHostName(String hostName) throws java.net.UnknownHostException;
    
    /**
     * SMTPT[õzXg擾B<p>
     *
     * @return SMTPT[õzXg
     */
    public String getHostName();
    
    /**
     * SMTPT[oPortԍݒ肷B<p>
     *
     * @param port SMTPT[oPortԍ
     */
    public void setPort(int port);
    
    /**
     * SMTPT[oPortԍ擾B<p>
     *
     * @return SMTPT[oPortԍ
     */
    public int getPort();
    
    /**
     * ڑ҂̃^CAEg[ms]ݒ肷B<p>
     * ftHǵA0Ŗ҂B<br>
     *
     * @param milisec ^CAEg[ms]
     */
    public void setConnectionTimeoutMillis(int milisec);
    
    /**
     * ڑ҂̃^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public int getConnectionTimeoutMillis();
    
    /**
     * ҂̃^CAEg[ms]ݒ肷B<p>
     * ftHǵA1bB<br>
     *
     * @param milisec ^CAEg[ms]
     */
    public void setTimeoutMillis(int milisec);
    
    /**
     * ҂̃^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public int getTimeoutMillis();
    
    /**
     * EOFmꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setEOFLogMessageId(String id);
    
    /**
     * EOFmꍇɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getEOFLogMessageId();
    
    /**
     * T[oG[ԂMꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setErrorStateLogMessageId(String id);
    
    /**
     * T[oG[ԂMꍇɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getErrorStateLogMessageId();
    
    /**
     * T[o琳ԂMꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setNormalStateLogMessageId(String id);
    
    /**
     * T[o琳ԂMꍇɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getNormalStateLogMessageId();
    
    /**
     * T[ỏ҂Ń^CAEgꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setTimeoutLogMessageId(String id);
    
    /**
     * T[ỏ҂Ń^CAEgꍇɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getTimeoutLogMessageId();
    
    /**
     * TCPxł̃vgRG[ꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setProtocolErrorLogMessageId(String id);
    
    /**
     * TCPxł̃vgRG[ꍇɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getProtocolErrorLogMessageId();
    
    /**
     * o̓G[ꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setIOErrorLogMessageId(String id);
    
    /**
     * o̓G[ꍇɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getIOErrorLogMessageId();
    
    /**
     * EOFmꍇɃOo͂邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputEOFLogMessage(boolean isOutput);
    
    /**
     * EOFmꍇɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputEOFLogMessage();
    
    /**
     * T[oG[ԂMꍇɃOo͂邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputErrorStateLogMessage(boolean isOutput);
    
    /**
     * T[oG[ԂMꍇɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputErrorStateLogMessage();
    
    /**
     * T[o琳ԂMꍇɃOo͂邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputNormalStateLogMessage(boolean isOutput);
    
    /**
     * T[o琳ԂMꍇɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputNormalStateLogMessage();
    
    /**
     * T[ỏ҂Ń^CAEgꍇɃOo͂邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputTimeoutLogMessage(boolean isOutput);
    
    /**
     * T[ỏ҂Ń^CAEgꍇɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputTimeoutLogMessage();
    
    /**
     * TCPxł̃vgRG[ꍇɃOo͂邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputProtocolErrorLogMessage(boolean isOutput);
    
    /**
     * TCPxł̃vgRG[ꍇɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputProtocolErrorLogMessage();
    
    /**
     * o̓G[ꍇɃOo͂邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputIOErrorLogMessage(boolean isOutput);
    
    /**
     * o̓G[ꍇɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputIOErrorLogMessage();
    
    /**
     * SMTPT[o̐`FbNsǂݒ肷B<p>
     * trueɐݒ肳ꂽꍇA{@link #setAliveCheckSMTPServerInterval(long)}Őݒ肳ꂽԊuŁA"HELO"bZ[W𑗐MāASMTPT[o̐`FbNsB<br>
     * "HELO"bZ[W̉łȂꍇAG[Oo͂B܂A퉞ł悤ɂȂꍇAʒmOo͂B<br>
     *
     * @param isCheck `FbNsꍇtrue
     */
    public void setAliveCheckSMTPServer(boolean isCheck);
    
    /**
     * SMTPT[o̐`FbNsǂݒ肷B<p>
     *
     * @return `FbNsꍇtrue
     */
    public boolean isAliveCheckSMTPServer();
    
    /**
     * SMTPT[o̐`FbNsԊu[msec]ݒ肷B<p>
     * ftHǵA60000[msec]B
     * 
     * @param interval SMTPT[o̐`FbNsԊu[msec]
     */
    public void setAliveCheckSMTPServerInterval(long interval);
    
    /**
     * SMTPT[o̐`FbNsԊu[msec]擾B<p>
     * 
     * @return SMTPT[o̐`FbNsԊu[msec]
     */
    public long getAliveCheckSMTPServerInterval();
    
    /**
     * SMTPT[oĂ邩ǂ𒲂ׂB<p>
     * {@link #isAliveCheckSMTPServer()}trueԂꍇ́AŌɃ`FbN̏ԂԂB<br>
     * isAliveCheckSMTPServer()falseԂꍇ́AɃ`FbNČʂԂBAAT[rXJnĂȂꍇ́AfalseԂB<br>
     * 
     * @return SMTPT[oĂꍇtrue
     */
    public boolean isAliveSMTPServer();
    
    /**
     * SMTPT[o_Em|̃Oo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput Oo͂ꍇtrue
     */
    public void setLoggingDeadSMTPServer(boolean isOutput);
    
    /**
     * SMTPT[o_Em|̃Oo͂邩ǂ𔻒肷B<p>
     *
     * @return Oo͂ꍇtrue
     */
    public boolean isLoggingDeadSMTPServer();
    
    /**
     * SMTPT[oAm|̃Oo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput Oo͂ꍇtrue
     */
    public void setLoggingRecoverSMTPServer(boolean isOutput);
    
    /**
     * SMTPT[oAm|̃Oo͂邩ǂ𔻒肷B<p>
     *
     * @return Oo͂ꍇtrue
     */
    public boolean isLoggingRecoverSMTPServer();
    
    /**
     * SMTPT[o_Em|̃Oo͂̃bZ[WIDݒ肷B<p>
     * ftHǵA{@link #SMTP_SERVER_DEAD_MSG_ID}B<br>
     *
     * @param id Oo͂̃bZ[WID
     */
    public void setDeadSMTPServerLogMessageId(String id);
    
    /**
     * SMTPT[o_Em|̃Oo͂̃bZ[WID擾B<p>
     *
     * @return Oo͂̃bZ[WID
     */
    public String getDeadSMTPServerLogMessageId();
    
    /**
     * SMTPT[oAm|̃Oo͂̃bZ[WIDݒ肷B<p>
     * ftHǵA{@link #SMTP_SERVER_RECOVER_MSG_ID}B<br>
     *
     * @param id Oo͂̃bZ[WID
     */
    public void setRecoverSMTPServerLogMessageId(String id);
    
    /**
     * SMTPT[oAm|̃Oo͂̃bZ[WID擾B<p>
     *
     * @return Oo͂̃bZ[WID
     */
    public String getRecoverSMTPServerLogMessageId();
}
