/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.crypt;

import jp.ossc.nimbus.core.*;

import java.security.*;
import java.security.spec.*;

/**
 * {@link CipherCryptService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see CipherCryptService
 */
public interface CipherCryptServiceMBean extends ServiceBaseMBean{
    
    /**
     * ftHg̕ϊB<p>
     */
    public static final String DEFAULT_TRANSFORMATION = "DES/ECB/PKCS5Padding";
    
    /**
     * ftHg̕GR[fBOB<p>
     */
    public static final String DEFAULT_ENCODING = "ISO_8859-1";
    
    /**
     * ftHg̃nbVASYB<p>
     */
    public static final String DEFAULT_HASH_ALGORITHM = "MD5";
    
    /**
     * Í/Ɏgpϊݒ肷B<p>
     * ftHǵA{@link #DEFAULT_TRANSFORMATION}B<br>
     *
     * @param trans ϊ
     */
    public void setTransformation(String trans);
    
    /**
     * Í/Ɏgpϊ擾B<p>
     *
     * @return ϊ
     */
    public String getTransformation();
    
    /**
     * ݒ肷B<p>
     *
     * @param k 
     */
    public void setKey(Key k);
    
    /**
     * 擾B<p>
     *
     * @return 
     */
    public Key getKey();
    
    /**
     * XgÃpXݒ肷B<p>
     *
     * @param path pX
     */
    public void setStorePath(String path);
    
    /**
     * XgÃpX擾B<p>
     *
     * @return pX
     */
    public String getStorePath();
    
    /**
     * XgA̎ʂݒ肷B<p>
     *
     * @param type 
     */
    public void setStoreType(String type);
    
    /**
     * XgA̎ʂ擾B<p>
     *
     * @return 
     */
    public String getStoreType();
    
    /**
     * XgAvoC_̖Oݒ肷B<p>
     *
     * @param name XgAvoC_̖O
     */
    public void setStoreProviderName(String name);
    
    /**
     * XgAvoC_̖O擾B<p>
     *
     * @return XgAvoC_̖O
     */
    public String getStoreProviderName();
    
    /**
     * XgAvoC_ݒ肷B<p>
     *
     * @param name XgAvoC_
     */
    public void setStoreProvider(Provider provider);
    
    /**
     * XgAvoC_擾B<p>
     *
     * @return XgAvoC_
     */
    public Provider getStoreProvider();
    
    /**
     * XgÃpX[hݒ肷B<p>
     *
     * @param password XgÃpX[h
     */
    public void setStorePassword(String password);
    
    /**
     * XgÃpX[h擾B<p>
     *
     * @return XgÃpX[h
     */
    public String getStorePassword();
    
    /**
     * ̃GCAXݒ肷B<p>
     *
     * @param alias ̃GCAX
     */
    public void setKeyAlias(String alias);
    
    /**
     * ̃GCAX擾B<p>
     *
     * @return ̃GCAX
     */
    public String getKeyAlias();
    
    /**
     * ̃pX[hݒ肷B<p>
     *
     * @param password ̃pX[h
     */
    public void setKeyPassword(String password);
    
    /**
     * ̃pX[h擾B<p>
     *
     * @return ̃pX[h
     */
    public String getKeyPassword();
    
    /**
     * javax.crypto.Cipher擾邽߂̃voC_ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̃voC_gp܂B<br>
     *
     * @param p voC_
     */
    public void setCipherProvider(Provider p);
    
    /**
     * javax.crypto.Cipher擾邽߂̃voC_擾B<p>
     *
     * @return voC_
     */
    public Provider getCipherProvider();
    
    /**
     * javax.crypto.Cipher擾邽߂̃voC_ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̃voC_gp܂B<br>
     *
     * @param name voC_
     */
    public void setCipherProviderName(String name);
    
    /**
     * javax.crypto.Cipher擾邽߂̃voC_擾B<p>
     *
     * @return voC_
     */
    public String getCipherProviderName();
    
    /**
     * javax.crypto.CipheȑɎgpASYp[^ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̃ASYp[^gp܂B<br>
     *
     * @param params ASYp[^
     */
    public void setAlgorithmParameters(AlgorithmParameters params);
    
    /**
     * javax.crypto.CipheȑɎgpASYp[^擾B<p>
     *
     * @return ASYp[^
     */
    public AlgorithmParameters getAlgorithmParameters();
    
    /**
     * javax.crypto.CipheȑɎgpASYp[^ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̃ASYp[^gp܂B<br>
     *
     * @param params ASYp[^
     */
    public void setAlgorithmParameterSpec(AlgorithmParameterSpec params);
    
    /**
     * javax.crypto.CipheȑɎgpASYp[^擾B<p>
     *
     * @return ASYp[^
     */
    public AlgorithmParameterSpec getAlgorithmParameterSpec();
    
    /**
     * javax.crypto.CipheȑɎgp闐ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̗gp܂B<br>
     *
     * @param random 
     */
    public void setSecureRandom(SecureRandom random);
    
    /**
     * javax.crypto.CipheȑɎgp闐擾B<p>
     *
     * @return 
     */
    public SecureRandom getSecureRandom();
    
    /**
     * GR[fBOݒ肷B<p>
     * Íۂɕ񂩂oCgzւ̕ϊɎgpB܂AۂɃoCgz񂩂當ւ̕ϊɎgpB<br>
     * ܂AnbVۂɕ񂩂oCgzւ̕ϊɎgpB<br>
     * ftHǵA{@link #DEFAULT_ENCODING}B<br>
     *
     * @param enc GR[fBO
     */
    public void setEncoding(String enc);
    
    /**
     * GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getEncoding();
    
    /**
     * nbṼASYݒ肷B<p>
     * ftHǵA{@link #DEFAULT_HASH_ALGORITHM}B<br>
     * 
     * @param algorithm nbṼASY
     */
    public void setHashAlgorithm(String algorithm);
    
    /**
     * nbṼASY擾B<p>
     * 
     * @return nbṼASY
     */
    public String getHashAlgorithm();
    
    /**
     * javax.crypto.MessageDigest擾邽߂̃voC_ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̃voC_gp܂B<br>
     *
     * @param p voC_
     */
    public void setMessageDigestProvider(Provider p);
    
    /**
     * javax.crypto.MessageDigest擾邽߂̃voC_擾B<p>
     *
     * @return voC_
     */
    public Provider getMessageDigestProvider();
    
    /**
     * javax.crypto.MessageDigest擾邽߂̃voC_ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHg̃voC_gp܂B<br>
     *
     * @param name voC_
     */
    public void setMessageDigestProviderName(String name);
    
    /**
     * javax.crypto.MessageDigest擾邽߂̃voC_擾B<p>
     *
     * @return voC_
     */
    public String getMessageDigestProviderName();
    
    /**
     * ϊʂݒ肷B<p>
     * {@link jp.ossc.nimbus.util.converter.ReversibleConverter ReversibleConverter}ƂĎgpꍇɐݒ肷B<br>
     *
     * @param type ϊ
     * @see jp.ossc.nimbus.util.converter.ReversibleConverter#POSITIVE_CONVERT Í
     * @see jp.ossc.nimbus.util.converter.ReversibleConverter#REVERSE_CONVERT 
     */
    public void setConvertType(int type);
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     */
    public int getConvertType();
}
