/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * XgALbVӂꓮT[rXB<p>
 * ӂꂽLbVIuWFNgAʂ̃LbVɑޔ邠ӂꓮłB<br>
 * ȉɁAӂꂽLbVIuWFNgt@CLbVɑޔXgALbVӂꓮT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="StoreCacheOverflowAction"
 *                  code="jp.ossc.nimbus.service.cache.StoreCacheOverflowActionService"&gt;
 *             &lt;attribute name="CacheServiceName"&gt;#FileCache&lt;/attribute&gt;
 *             &lt;depends&gt;FileCache&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="FileCache"
 *                  code="jp.ossc.nimbus.service.cache.FileCacheService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class StoreCacheOverflowActionService<E> extends ServiceBase
 implements OverflowAction<E>, LinkedReference<E>, CacheRemoveListener<E>,
            CacheChangeListener<E>, java.io.Serializable,
            StoreCacheOverflowActionServiceMBean{
    
    private static final long serialVersionUID = 7281680512746664647L;
    
    // bZ[WID`
    private static final String SCOA_ = "SCOA_";
    private static final String SCOA_0 = SCOA_ + 0;
    private static final String SCOA_00 = SCOA_0 + 0;
    private static final String SCOA_000 = SCOA_00 + 0;
    private static final String SCOA_0000 = SCOA_000 + 0;
    private static final String SCOA_00001 = SCOA_0000 + 1;
    private static final String SCOA_00002 = SCOA_0000 + 2;
    
    private ServiceName cacheServiceName;
    private Cache<E> cache;
    
    private ServiceName cacheMapServiceName;
    private CacheMap<Object, E> cacheMap;
    
    private OverflowController<E> controller;
    
    private MemoryCacheService<E> defaultCache;
    
    private Map<CachedReference<E>, CachedReference<E>> references;
    
    // StoreCacheOverflowActionServiceMBeanJavaDoc
    @Override
    public void setCacheServiceName(ServiceName name){
        cacheServiceName = name;
    }
    // StoreCacheOverflowActionServiceMBeanJavaDoc
    @Override
    public ServiceName getCacheServiceName(){
        return cacheServiceName;
    }
    
    // StoreCacheOverflowActionServiceMBeanJavaDoc
    @Override
    public void setCacheMapServiceName(ServiceName name){
        cacheMapServiceName = name;
    }
    // StoreCacheOverflowActionServiceMBeanJavaDoc
    @Override
    public ServiceName getCacheMapServiceName(){
        return cacheMapServiceName;
    }
    
    /**
     * Cacheݒ肷B
     */
    public void setCache(Cache<E> cache) {
		this.cache = cache;
	}
    /**
     * CacheMapݒ肷B
     */
	public void setCacheMap(CacheMap<Object, E> cacheMap) {
		this.cacheMap = cacheMap;
	}
	
	/**
     * T[rX̐sB<p>
     * CX^Xϐ̏sB
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        references = Collections.synchronizedMap(new HashMap<CachedReference<E>, CachedReference<E>>());
    }
    
    /**
     * T[rX̊JnsB<p>
     * ޔ̃LbVT[rX̎擾sB<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(cacheServiceName != null){
            cache = ServiceManagerFactory
                .getServiceObject(cacheServiceName);
        }else{
            cache = getDefaultCacheService();
        }
        if(cacheMapServiceName != null){
            cacheMap = ServiceManagerFactory
                .getServiceObject(cacheMapServiceName);
        }
    }
    
    /**
     * T[rX̒~sB<p>
     * ޔ̃LbVT[rXQƂ̊JsB<br>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        if(defaultCache != null && cache == defaultCache){
            defaultCache.stop();
        }
        cache = null;
        cacheMap = null;
    }
    
    /**
     * T[rX̔jsB<p>
     * CX^Xϐ̊JsB
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        if(defaultCache != null){
            defaultCache.destroy();
            defaultCache = null;
        }
        references = null;
    }
    
    /**
     * ޔ̃LbVT[rXݒ肳ĂȂꍇ̃ftHg̃LbVT[rX擾B<p>
     *
     * @return ftHg̃LbVT[rXi{@link MemoryCacheService}j
     * @exception Exception ftHg̃LbVT[rX̐EJnɎsꍇ
     */
    protected Cache<E> getDefaultCacheService() throws Exception{
        if(defaultCache == null){
            final MemoryCacheService<E> c = new MemoryCacheService<E>();
            c.create();
            c.start();
            defaultCache = c;
        }else if(defaultCache.getState() != State.STARTED){
            defaultCache.start();
        }
        return defaultCache;
    }
    
    // OverflowActionJavaDoc
    @Override
    public void setOverflowController(OverflowController<E> controller){
        this.controller = controller;
    }
    
    /**
     * ӂꂽLbVIuWFNgޔLbVɑޔB<p>
     *
     * @param validator ӂꌟ؂sOverflowValidator
     * @param algorithm ӂLbVQƂ肵OverflowAlgorithm
     * @param ref ӂꂽLbVQ
     */
    @SuppressWarnings("unchecked")
    @Override
    public void action(
        OverflowValidator<E> validator,
        OverflowAlgorithm<E> algorithm,
        CachedReference<E> ref
    ){
        if(ref == null || references == null){
            return;
        }
        synchronized(references){
            final E obj = ref.get(this, false);
            if(obj == null){
                return;
            }
            CachedReference<E> newRef = null;
            if(ref instanceof KeyCachedReference && cacheMap != null){
                final KeyCachedReference<Object, E> keyRef = (KeyCachedReference<Object, E>)ref;
                final Object key = keyRef.getKey();
                if(key != null && obj != null){
                    cacheMap.put(key, obj);
                    newRef = cacheMap.getCachedReference(key);
                }
            }else{
                newRef = cache.add(obj);
            }
            if(newRef != null){
                try{
                    ref.set(this, null);
                    ref.addLinkedReference(this);
                    ref.addCacheRemoveListener(this);
                    ref.addCacheChangeListener(this);
                    references.put(ref, newRef);
                    if(validator != null){
                        validator.remove(ref);
                    }
                    if(algorithm != null){
                        algorithm.remove(ref);
                    }
                }catch(IllegalCachedReferenceException e){
                    getLogger().write(SCOA_00001, e);
                    newRef.remove(this);
                }
                if(ref.isRemoved()){
                    newRef.remove(this);
                }
            }else{
                if(algorithm != null){
                    algorithm.remove(ref);
                }
            }
        }
    }
    
    /**
     * ӂꓮs邽߂ɕێĂB<p>
     */
    @Override
    public void reset(){
        if(references != null){
            references.clear();
        }
    }
    
    /**
     * ޔLbVLbVIuWFNg擾B<p>
     *
     * @param ref Qƌ̃LbVQ
     * @return LbVIuWFNg
     */
    @Override
    public E get(CachedReference<E> ref){
        if(ref == null || references == null){
            return null;
        }
        synchronized(references){
            final CachedReference<E> newRef = references.get(ref);
            E obj = null;
            if(newRef != null){
                obj = newRef.get(this);
                try{
                    ref.set(this, obj);
                    newRef.remove(this);
                    references.remove(ref);
                    ref.removeLinkedReference(this);
                    ref.removeCacheRemoveListener(this);
                    ref.removeCacheChangeListener(this);
                    if(controller != null){
                        controller.control(ref);
                    }
                }catch(IllegalCachedReferenceException e){
                    getLogger().write(SCOA_00002, obj, e);
                }
            }
            return obj;
        }
    }
    
    /**
     * LbV폜ꂽLbVQƂ̒ʒm󂯂B<p>
     * 폜ꂽLbVQƂɃNޔ̃LbV폜B<br>
     *
     * @param ref LbV폜ꂽLbVQ
     */
    @Override
    public void removed(CachedReference<E> ref){
        if(references == null){
            return;
        }
        synchronized(references){
            if(references != null && references.containsKey(ref)){
                final CachedReference<E> newRef = references.remove(ref);
                newRef.remove(this);
            }
        }
    }
    
    /**
     * LbVQƂ̃LbVIuWFNgύXꂽʒm󂯂B<p>
     * ύXꂽLbVQƂɃNޔ̃LbV폜B<br>
     *
     * @param ref ύXꂽLbVIuWFNg̃LbVQ
     * @param obj ύX̃LbVIuWFNg
     */
    @Override
    public void changed(CachedReference<E> ref, E obj){
        if(references == null){
            return;
        }
        synchronized(references){
            if(references != null && references.containsKey(ref)){
                final CachedReference<E> newRef = references.remove(ref);
                newRef.remove(this);
                ref.removeLinkedReference(this);
                ref.removeCacheRemoveListener(this);
                ref.removeCacheChangeListener(this);
            }
        }
    }
}
