/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.io.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.io.Externalizer;

/**
 * L[t񉻃LbVQƁB<p>
 *
 * @author M.Takata
 */
public class SerializeKeyCachedReference<K, V> extends DefaultKeyCachedReference<K, V>
 implements Serializable{
    
    private static final long serialVersionUID = -2231571982502593180L;
    
    private transient Externalizer<V> externalizer;
    
    /**
     * w肳ꂽLbVL[ALbVIuWFNgێVL[tLbVQƂ𐶐B<p>
     * LbVIuWFNǵA񉻂ĕۑB<br>
     * 
     * @param key LbVL[
     * @param obj LbVIuWFNg
     * @exception IOException LbVIuWFNg̒񉻂Ɏsꍇ
     */
    public SerializeKeyCachedReference(K key, V obj)
     throws IOException{
        super(key, null);
        serializeObject(obj);
    }
    
    /**
     * w肳ꂽLbVL[ALbVIuWFNgێVL[tLbVQƂ𐶐B<p>
     * LbVIuWFNǵA񉻂ĕۑB<br>
     * 
     * @param key LbVL[
     * @param obj LbVIuWFNg
     * @exception IOException LbVIuWFNg̒񉻂Ɏsꍇ
     */
    public SerializeKeyCachedReference(K key, V obj, Externalizer<V> ext)
     throws IOException{
        super(key, null);
        externalizer = ext;
        serializeObject(obj);
    }
    
    /**
     * IuWFNgVACYĊi[B<p>
     * 
     * @param obj LbVIuWFNg
     * @exception IOException 񉻂Ɏsꍇ
     */
    protected void serializeObject(V obj)
     throws IOException{
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if(externalizer == null){
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
        }else{
            externalizer.writeExternal(obj, baos);
        }
        cacheObj = baos.toByteArray();
    }
    
    /**
     * IuWFNg𕜌B<p>
     * 
     * @param bytes 񉻃oCgz
     * @return IuWFNg
     * @exception IOException LbVt@C̕Ɏsꍇ
     * @exception ClassNotFoundException LbVt@C̕ʂ̃NX ݂Ȃꍇ
     */
    @SuppressWarnings("unchecked")
    protected V deserializeObject(byte[] bytes)
     throws IOException, ClassNotFoundException{
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        V entry = null;
        if(externalizer == null){
            ObjectInputStream ois = new ObjectInputStream(bais);
            entry = (V)ois.readObject();
        }else{
            entry = externalizer.readExternal(bais);
        }
        return entry;
    }
    
    /**
     * 񉻂LbVIuWFNg擾B<p>
     *
     * @return 񉻂LbVIuWFNg
     */
    public byte[] getBytes(){
        return (byte[])super.get(null, false);
    }
    
    /**
     * LbVꂽIuWFNgLbVt@C畜Ď擾B<p>
     * truȅꍇ́A{@link #addCacheAccessListener(CacheAccessListener)}œo^ꂽ{@link CacheAccessListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheAccessListener̃CX^XƓꍇ́AʒmȂB<br>
     * gێLbVIuWFNgnullłȂꍇ́AԂBnull̏ꍇ́A{@link #addLinkedReference(LinkedReference)}œo^ꂽ{@link LinkedReference}擾݂B<br>
     *
     * @param source LbV擾邱̃\bȟĂяoIuWFNg
     * @param notify LbVANZXXiɒʒmꍇtrue
     * @return LbVIuWFNg
     */
    @Override
    public V get(Object source, boolean notify){
        final V obj = super.get(source, notify);
        if(obj instanceof byte[]){
            try{
                return deserializeObject((byte[])obj);
            }catch(IOException e){
                return null;
            }catch(ClassNotFoundException e){
                return null;
            }
        }else{
            return obj;
        }
    }
    
    /**
     * LbVIuWFNg𒼗񉻂ăt@CɕۑB<p>
     * {@link #addCacheChangeListener(CacheChangeListener)}œo^ꂽ{@link CacheChangeListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheChangeListener̃CX^XƓꍇ́AʒmȂB<br>
     *
     * @param source LbVIuWFNgύX邱̃\bȟĂяoIuWFNg
     * @param obj ݒ肷LbVIuWFNg
     * @exception IllegalCachedReferenceException LbVQƂ̏ԂsȈ׃LbVIuWFNg̐ݒɎsꍇ
     */
    @Override
    public void set(Object source, V obj)
     throws IllegalCachedReferenceException{
        notifyChange(source, obj);
        if(obj != null){
            try{
                serializeObject(obj);
            }catch(IOException e){
                throw new IllegalCachedReferenceException(e);
            }
        }else{
            cacheObj = null;
        }
    }
    
    /**
     * LbVIuWFNgۑLbVt@C폜B<p>
     * {@link #addCacheRemoveListener(CacheRemoveListener)}œo^ꂽ{@link CacheRemoveListener}ɒʒmBAAœnꂽĂяoIuWFNgʒmCacheChangeListener̃CX^XƓꍇ́AʒmȂB<br>
     *
     * @param source LbVIuWFNg폜邱̃\bȟĂяoIuWFNg
     */
    @Override
    public void remove(Object source){
        if(cacheObj != null){
            notifyRemoved(source);
            cacheObj = null;
            if(linkedReferences != null){
                linkedReferences.clear();
            }
        }
    }
    
    private void writeObject(ObjectOutputStream out) throws IOException{
        out.defaultWriteObject();
        writeSet(out, linkedReferences);
        writeSet(out, removeListeners);
        writeSet(out, accessListeners);
        writeSet(out, changeListeners);
        ServiceName name = null;
        if(externalizer != null){
            name = getServiceName(externalizer);
        }
        if(name != null){
            out.writeObject(name);
        }else{
            out.writeObject(externalizer);
        }
    }
    
    @SuppressWarnings("unchecked")
    private void readObject(ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        linkedReferences = readSet(in);
        removeListeners = readSet(in);
        accessListeners = readSet(in);
        changeListeners = readSet(in);
        Object obj = in.readObject();
        if(obj != null){
            if(obj instanceof ServiceName){
                externalizer = ServiceManagerFactory.getServiceObject(
                    (ServiceName)obj
                );
            }else{
                externalizer = (Externalizer<V>)obj;
            }
        }
    }
}