/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link FileCacheMapService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see FileCacheMapService
 */
public interface FileCacheMapServiceMBean<K, V> extends AbstractCacheMapServiceMBean<K, V>{
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̃t@C̃ftHgTtBbNXB<p>
     */
    public static final String DEFAULT_SUFFIX = ".obj";
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̏o͐fBNgݒ肷B<p>
     * o͐fBNgw肳ĂȂꍇ́AJVM̃e|fBNggpBAA{@link #setFileShared(boolean)}trueݒ肳Ăꍇ́Ao͐fBNgKw肵Ȃ΂ȂȂB<br>
     *
     * @param path o̓fBNgpX
     * @exception IllegalArgumentException w肳ꂽpX̃fBNg݂Ȃꍇ
     */
    public void setOutputDirectory(String path)
     throws IllegalArgumentException;
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̏o͐fBNg擾B<p>
     *
     * @return o̓fBNgpX
     */
    public String getOutputDirectory();
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂LbVt@C𑼂{@link FileCacheMapService}ƋL邩ǂݒ肷B<p>
     * truew肷ƁALbVt@CLB̂߁ÃT[rXɂāALbVt@C폜ꂽAǉꂽ肷̂ŁALbVQƂsxALbV̍ŐVsB<br>
     *
     * @param isShared LbVt@CLꍇtrue
     */
    public void setFileShared(boolean isShared);
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂LbVt@C𑼂{@link FileCacheMapService}ƋL邩ǂ𔻒肷B<p>
     *
     * @return LbVt@CLꍇtrue
     */
    public boolean isFileShared();
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̃t@C̃vtBNXݒ肷B<p>
     * ̏o̓t@CvtBNXw肳ĂȂꍇ́ALbVIuWFNgtoString()gpB<br>
     *
     * @param prefix o̓t@CvtBNX
     */
    public void setOutputPrefix(String prefix);
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̃t@C̃vtBNX擾B<p>
     *
     * @return o̓t@CvtBNX
     */
    public String getOutputPrefix();
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̃t@C̃TtBbNXݒ肷B<p>
     * ̏o̓t@CTtBbNXw肳ĂȂꍇ́A".obj"gpB<br>
     *
     * @param suffix o̓t@CTtBbNX
     */
    public void setOutputSuffix(String suffix);
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂ۂ̃t@C̃vtBNX擾B<p>
     *
     * @return o̓t@CvtBNX
     */
    public String getOutputSuffix();
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂LbVt@CT[rX̊JnɃ[h邩ǂݒ肷B<p>
     * ftHǵAfalseŁAT[rX̊JnɃ[hȂB<br>
     *
     * @param isLoad T[rX̊JnɃ[hꍇtrue
     */
    public void setLoadOnStart(boolean isLoad);
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂LbVt@CT[rX̊JnɃ[h邩ǂ𔻒肷B<p>
     *
     * @return T[rX̊JnɃ[hꍇtrue
     */
    public boolean isLoadOnStart();
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂LbVt@CJVM̏Iɍ폜邩ǂݒ肷B<p>
     * ftHǵAtrueŁAJVMIɍ폜B<br>
     *
     * @param isDeleteOnExit 폜ꍇtrue
     */
    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit);
    
    /**
     * LbVIuWFNgVACYăt@CƂďo͂LbVt@CJVM̏Iɍ폜邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA폜
     */
    public boolean isDeleteOnExitWithJVM();
    
    /**
     * LbVt@C̃[hɎsꍇɍ폜邩ǂݒ肷B<p>
     * ftHǵAfalseŁA폜ȂB<br>
     *
     * @param isDelete 폜ꍇtrue
     */
    public void setDeleteOnLoadError(boolean isDelete);
    
    /**
     * LbVt@C̃[hɎsꍇɍ폜邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA폜
     */
    public boolean isDeleteOnLoadError();
    
    /**
     * t@Cɒ񉻂ۂɒ񉻂s{@link jp.ossc.nimbus.service.io.Externalizer Externalizer}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ExternalizerT[rX̃T[rX
     */
    public void setExternalizerServiceName(ServiceName name);
    
    /**
     * t@Cɒ񉻂ۂɒ񉻂s{@link jp.ossc.nimbus.service.io.Externalizer Externalizer}T[rX̃T[rX擾B<p>
     *
     * @return ExternalizerT[rX̃T[rX
     */
    public ServiceName getExternalizerServiceName();
}
