/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.ServiceBaseMBean;

import java.util.Map;

/**
 * {@link CalculateMemorySizeOverflowValidatorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see CalculateMemorySizeOverflowValidatorService
 */
public interface CalculateMemorySizeOverflowValidatorServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * gp̍őTCYݒ肷B<p>
     * LȒl͈̔͂́A0ȏBftHg{@link Runtime#maxMemory()}Ŏ擾łl / 2B̃\bhT|[gĂȂꍇ́A32MByteB<br>
     * Pʂw肵Ȃꍇ́AoCgPʁBPʂw肷ꍇ́A"K"̏ꍇ̓LoCgPʁB"M"̏ꍇ̓KoCgPʁB"G"̏ꍇ̓MKoCgPʁB
     *
     * @param size gp̍őTCY
     * @exception IllegalArgumentException lłȂA̒lAeȂPʕw肵ꍇ
     */
    public void setMaxMemorySize(String size) throws IllegalArgumentException;
    
    /**
     * gp̍őTCY擾B<p>
     *
     * @return gp̍őTCY
     */
    public String getMaxMemorySize();
    
    /**
     * IuWFNgɐ錾Ăgetter\bhŎ擾łprimitive^ȊÕIuWFNg̃TCYvZĉZ邩ǂݒ肷B<p>
     * ftHgfalseŉZȂB<br>
     *
     * @param isCalculate Zꍇtrue
     */
    public void setCalculateProperty(boolean isCalculate);
    
    /**
     * IuWFNgɐ錾Ăgetter\bhŎ擾łprimitive^ȊÕIuWFNg̃TCYvZĉZ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAZ
     */
    public boolean isCalculateProperty();
    
    /**
     * ӂꌟ؎ɃgpʂvZǂݒ肷B<p>
     * ftHgfalseŁALbVꂽ_ŃgpʂvZB<br>
     * ̏ꍇALbVɎgpʂςĂvZȂB<br>
     *
     * @param isCalculate ӂꌟ؎ɃgpʂvZꍇtrue
     */
    public void setCalculateOnValidate(boolean isCalculate);
    
    /**
     * ӂꌟ؎ɃgpʂvZǂ𔻒肷B<p>
     *
     * @return truȅꍇAӂꌟ؎ɃgpʂvZ
     */
    public boolean isCalculateOnValidate();
    
    /**
     * ӂꌟ؂s邽߂ɕێĂB<p>
     */
    public void reset();
    
    /**
     * ӂꌟ؂sB<p>
     *
     * @return ӂꌟ؂sʂӂꂪꍇAӂꐔԂBӂȂꍇ́A0Ԃ
     */
    public int validate();
    
    /**
     * ӂꌟؑΏۂɂȂĂLbV擾B<p>
     *
     * @return LbV
     */
    public int size();
    
    /**
     * ݂̃gp[byte]擾B<p>
     *
     * @return ݂̃gp[byte]
     */
    public long getCurrentUsedMemorySize();
    
    /**
     * w肵NX̃TCY𗝘_lƂĐݒ肷B<p>
     * Pʂw肵Ȃꍇ́AoCgPʁBPʂw肷ꍇ́A"K"̏ꍇ̓LoCgPʁB"M"̏ꍇ̓KoCgPʁB"G"̏ꍇ̓MKoCgPʁB
     *
     * @param className NX
     * @param size TCY
     * @exception ClassNotFoundException w肳ꂽNXȂꍇ
     */
    public void setMemorySize(String className, String size)
     throws ClassNotFoundException;
    
    /**
     * w肵NX̃TCY̗_l擾B<p>
     *
     * @param className NX
     * @return _TCY
     * @exception ClassNotFoundException w肳ꂽNXȂꍇ
     */
    public String getMemorySize(String className) throws ClassNotFoundException;
    
    /**
     * o^ĂNXƃTCY_l̃}bsO擾B<p>
     *
     * @return NXƃTCY_l̃}bsO
     */
    public Map<Class<?>, Number> getMemorySizeMap();
}
