/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.aop.invoker;

import jp.ossc.nimbus.core.*;

/**
 * {@link ProxyServerCallInvokerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ProxyServerCallInvokerService
 */
public interface ProxyServerCallInvokerServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[X[gIuWFNglookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JndiFinderT[rX̃T[rX
     */
    public void setJndiFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[X[gIuWFNglookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @return JndiFinderT[rX̃T[rX
     */
    public ServiceName getJndiFinderServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[XRMIIuWFNglookup{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     *
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[XRMIIuWFNglookup{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     *
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[X[gIuWFNgJNDIݒ肷B<p>
     * ̑ݒ肵ĂȂA{@link #setRemoteServiceName(ServiceName)}ݒ肳Ăꍇ́AŐݒ肳ꂽ[gĂяoT[rX{@link ServiceName}A"}l[W/T[rX"ƂJNDIKpB<br>
     * ǂݒ肳ĂȂꍇłA{@link jp.ossc.nimbus.service.aop.InvocationContext#getTargetObject() InvocationContext.getTargetObject()}Ń[gĂяoT[rX̃T[rX擾ł΁ALƓ悤JNDIKpB̕@łT[rX擾łȂꍇ́AĂяoɗOB<br>
     *
     * @param name [gIuWFNgJNDI
     */
    public void setProxyServerJndiName(String name);
    
    /**
     * {@link jp.ossc.nimbus.service.proxy.ProxyServerInvoker ProxyServerInvoker}C^tF[X[gIuWFNgJNDI擾B<p>
     *
     * @return [gIuWFNgJNDI
     */
    public String getProxyServerJndiName();
    
    /**
     * Ăяo[gT[õT[rX̃T[rXݒ肷B<p>
     * Ŏw肳ꂽT[rX́A{@link jp.ossc.nimbus.service.aop.InvocationContext#setTargetObject(Object) InvocationContext.setTargetObject(Object)}ŁAĂяoΏۂ̃T[rXƂē`dB<br>
     *
     * @param name Ăяo[gT[õT[rX̃T[rX
     */
    public void setRemoteServiceName(ServiceName name);
    
    /**
     * Ăяo[gT[õT[rX̃T[rX擾B<p>
     *
     * @return Ăяo[gT[õT[rX̃T[rX
     */
    public ServiceName getRemoteServiceName();
    
    /**
     * InvokerĂ邩ǂ𔻒肷B<p>
     *
     * @return Ăꍇtrue
     */
    public boolean isAlive();
}
