/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import jp.ossc.nimbus.core.*;

/**
 * {@link ServletFilterInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ServletFilterInterceptorService
 */
public interface ServletFilterInterceptorServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * ̃C^[Zv^LɂURLݒ肷B<p>
     * NGXgURLw肳ꂽURLɊYꍇAC^[Zv^̏sB<br>
     * ݒ肵Ȃꍇ́ASĂURLɑ΂ėLɂȂB<br>
     *
     * @param urls ̃C^[Zv^LɂURLiK\j̔z
     */
    public void setEnabledURLs(String[] urls);
    
    /**
     * ̃C^[Zv^LɂURL擾B<p>
     *
     * @return ̃C^[Zv^LɂURLiK\j̔z
     */
    public String[] getEnabledURLs();
    
    /**
     * ̃C^[Zv^𖳌ɂURLݒ肷B<p>
     * NGXgURLw肳ꂽURLɊYꍇAC^[Zv^̏sȂB<br>
     * ݒ肵Ȃꍇ́ASĂURLɑ΂ėLɂȂB<br>
     *
     * @param urls ̃C^[Zv^𖳌ɂURLiK\j̔z
     */
    public void setDisabledURLs(String[] urls);
    
    /**
     * ̃C^[Zv^𖳌ɂURL擾B<p>
     *
     * @return ̃C^[Zv^𖳌ɂURLiK\j̔z
     */
    public String[] getDisabledURLs();
    
    /**
     * ̃C^[Zv^LɂURIݒ肷B<p>
     * NGXgURIw肳ꂽURIɊYꍇAC^[Zv^̏sB<br>
     * ݒ肵Ȃꍇ́ASĂURIɑ΂ėLɂȂB<br>
     *
     * @param uris ̃C^[Zv^LɂURIiK\j̔z
     */
    public void setEnabledURIs(String[] uris);
    
    /**
     * ̃C^[Zv^LɂURI擾B<p>
     *
     * @return ̃C^[Zv^LɂURIiK\j̔z
     */
    public String[] getEnabledURIs();
    
    /**
     * ̃C^[Zv^𖳌ɂURIݒ肷B<p>
     * NGXgURIw肳ꂽURIɊYꍇAC^[Zv^̏sȂB<br>
     * ݒ肵Ȃꍇ́ASĂURIɑ΂ėLɂȂB<br>
     *
     * @param uris ̃C^[Zv^𖳌ɂURIiK\j̔z
     */
    public void setDisabledURIs(String[] uris);
    
    /**
     * ̃C^[Zv^𖳌ɂURI擾B<p>
     *
     * @return ̃C^[Zv^𖳌ɂURIiK\j̔z
     */
    public String[] getDisabledURIs();
    
    /**
     * ̃C^[Zv^LɂT[ubgpXݒ肷B<p>
     * NGXgT[ubgpXw肳ꂽT[ubgpXɊYꍇAC^[Zv^̏sB<br>
     * ݒ肵Ȃꍇ́ASẴT[ubgpXɑ΂ėLɂȂB<br>
     *
     * @param paths ̃C^[Zv^LɂT[ubgpXiK\j̔z
     */
    public void setEnabledPaths(String[] paths);
    
    /**
     * ̃C^[Zv^LɂT[ubgpX擾B<p>
     *
     * @return ̃C^[Zv^LɂT[ubgpXiK\j̔z
     */
    public String[] getEnabledPaths();
    
    /**
     * ̃C^[Zv^𖳌ɂT[ubgpXݒ肷B<p>
     * NGXgT[ubgpXw肳ꂽT[ubgpXɊYꍇAC^[Zv^̏sȂB<br>
     * ݒ肵Ȃꍇ́ASẴT[ubgpXɑ΂ėLɂȂB<br>
     *
     * @param paths ̃C^[Zv^𖳌ɂT[ubgpXiK\j̔z
     */
    public void setDisabledPaths(String[] paths);
    
    /**
     * ̃C^[Zv^𖳌ɂT[ubgpX擾B<p>
     *
     * @return ̃C^[Zv^𖳌ɂT[ubgpXiK\j̔z
     */
    public String[] getDisabledPaths();
}
