/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link RetryInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see RetryInterceptorService
 */
public interface RetryInterceptorServiceMBean
 extends ServiceBaseMBean{
    
    public static final String DEFAULT_RETRY_COUNT_ATTRIBUTE_NAME
         = RetryInterceptorService.class.getName().replaceAll("\\.", "_") + "_RETRY_COUNT";
    
    /**
     * gC߂l̏ݒ肷B<p>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpB<br>
     * ߂l̂QƂꍇ́A"value"Ƃ\gpB<br>
     * ߂l̃vpeBQƂꍇ́A֐prop:get(value, "vpeB")Ŏw肷BŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     *
     * @param conditions z
     */
    public void setReturnConditions(String[] conditions);
    
    /**
     * gC߂l̏擾B<p>
     *
     * @return z
     */
    public String[] getReturnConditions();
    
    /**
     * gCÕNXƂ̏ݒ肷B<p>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpB<br>
     * ÕvpeBQƂꍇ́A֐prop:get(value, "vpeB")ň͂Ŏw肷BŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     *
     * @param conditions ONX:iKvȂꍇ́A:ȉȗ\j̕z
     */
    public void setExceptionConditions(String[] conditions);
    
    /**
     * gCÕNXƂ̏擾B<p>
     *
     * @return ONX:iKvȂꍇ́A:ȉȗ\j̕z
     */
    public String[] getExceptionConditions();
    
    /**
     * gC񐔂ݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param count gC
     */
    public void setMaxRetryCount(int count);
    
    /**
     * gC񐔂擾B<p>
     *
     * @return gC
     */
    public int getMaxRetryCount();
    
    /**
     * ݂̃gC񐔂ێ{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_RETRY_COUNT_ATTRIBUTE_NAME}B<br>
     *
     * @param name ݂̃gC񐔂ێInvocationContext̑
     */
    public void setRetryCountAttributeName(String name);
    
    /**
     * ݂̃gC񐔂ێ{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑擾B<p>
     *
     * @return ݂̃gC񐔂ێInvocationContext̑
     */
    public String getRetryCountAttributeName();
    
    /**
     * gCԊu[ms]ݒ肷B<p>
     * ftHǵA0ŊԊuɃgCB<br>
     *
     * @param millis gCԊu[ms]
     */
    public void setRetryInterval(long millis);
    
    /**
     * gCԊu[ms]擾B<p>
     *
     * @return gCԊu[ms]
     */
    public long getRetryInterval();
}