/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.net;

import java.util.*;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;
import java.io.Externalizable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import jp.ossc.nimbus.beans.*;

/**
 * T[o\Pbgt@NgB<p>
 * ̃t@Ng琶T[o\PbǵA{@link #setSocketProperty(String, Object)}ŁA\ߐݒ肳ꂽvpeBݒ肳B<br>
 *
 * @author M.Takata
 */
public class SocketFactory extends javax.net.SocketFactory implements Externalizable, java.rmi.server.RMIClientSocketFactory{
    
    protected Map<Property, Object> socketProperties;
    
    public static javax.net.SocketFactory getDefault(){
        return new SocketFactory();
    }
    
    @Override
    public Socket createSocket() throws IOException{
        return applySocketProperties(new Socket());
    }
    
    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException{
        return applySocketProperties(new Socket(host, port));
    }
    
    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException{
        return applySocketProperties(new Socket(host, port, localAddress, localPort));
    }
    
    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException{
        return applySocketProperties(new Socket(host, port));
    }
    
    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException{
        return applySocketProperties(new Socket(address, port, localAddress, localPort));
    }
    
    /**
     * {@link Socket}ɃvpeBݒ肷B<p>
     *
     * @param props vpeB}bv
     */
    public void setSocketProperties(Map<String, Object> props){
        if(props == null || props.size() == 0){
            if(socketProperties != null){
                socketProperties = null;
            }
            return;
        }
        for(Map.Entry<String, Object> entry : props.entrySet()){
            setSocketProperty(entry.getKey(), entry.getValue());
        }
    }
    
    /**
     * {@link Socket}ɃvpeBݒ肷B<p>
     *
     * @param name vpeB
     * @param value l
     */
    public void setSocketProperty(String name, Object value){
        if(socketProperties == null){
            socketProperties = new LinkedHashMap<Property, Object>();
        }
        final Property prop = PropertyFactory.createProperty(name);
        socketProperties.put(prop, value);
    }
    
    /**
     * {@link Socket}̃vpeB擾B<p>
     *
     * @param name vpeB
     * @return l
     */
    public Object getSocketProperty(String name){
        if(socketProperties == null){
            return null;
        }
        for(Map.Entry<Property, Object> entry : socketProperties.entrySet()){
            if(entry.getKey().getPropertyName().equals(name)){
                return entry.getValue();
            }
        }
        return null;
    }
    
    public Socket applySocketProperties(
        Socket socket
    ) throws IOException{
        try{
            if(socketProperties != null && socketProperties.size() != 0){
                for(Map.Entry<Property, Object> entry : socketProperties.entrySet()){
                    entry.getKey().setProperty(socket, entry.getValue());
                }
            }
        }catch(InvocationTargetException e){
            Throwable target = e.getTargetException();
            if(target instanceof IOException){
                throw (IOException)target;
            }else if(target instanceof RuntimeException){
                throw (RuntimeException)target;
            }else if(target instanceof Error){
                throw (Error)target;
            }else{
                throw new UndeclaredThrowableException(target);
            }
        }catch(NoSuchPropertyException e){
            throw new UndeclaredThrowableException(e);
        }
        return socket;
    }
    
    public void writeExternal(ObjectOutput out) throws IOException{
        out.writeObject(socketProperties);
    }
    
    @SuppressWarnings("unchecked")
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException{
        socketProperties = (Map<Property, Object>)in.readObject();
    }
}