/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * T[rX`^f[^B<p>
 * T[rX`̊evf̃^f[^̊NXłB<br>
 * T[rX`̊evf̊{I@\ƁAXMLp[X郆[eBeB\bhB<br>
 * 
 * @author M.Takata
 */
public abstract class MetaData implements Serializable, Cloneable{
    
    private static final long serialVersionUID = -5571905040948580821L;
    
    protected static final String LINE_SEPARATOR
         = System.getProperty("line.separator");
    private static final String INDENT_STRING = "    ";
    
    /**
     * ̃^f[^̐evfƂȂ郁^f[^B<p>
     *
     * @see #getParent()
     */
    private MetaData parent;
    
    private String comment;
    
    private IfDefMetaData ifdefData;
    
    /**
     * evfȂ^f[^𐶐B<p>
     */
    public MetaData(){
    }
    
    /**
     * evf^f[^𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public MetaData(MetaData parent){
        this.parent = parent;
    }
    
    /**
     * evf̃^f[^擾B<p>
     * evfȂꍇ́AnullԂB
     * 
     * @return evf̃^f[^
     */
    public MetaData getParent(){
        return parent;
    }
    
    /**
     * evf̃^f[^ݒ肷B<p>
     * 
     * @param parent evf̃^f[^
     */
    public void setParent(MetaData parent){
        this.parent = parent;
    }
    
    /**
     * ̗vfɑ΂Rgݒ肷B<p>
     *
     * @param comment Rg
     */
    public void setComment(String comment){
        this.comment = comment;
    }
    
    /**
     * ̗vfɑ΂Rg擾B<p>
     *
     * @return Rg
     */
    public String getComment(){
        return comment;
    }
    
    public IfDefMetaData getIfDefMetaData(){
        return ifdefData;
    }
    
    public void setIfDefMetaData(IfDefMetaData ifdef){
        ifdefData = ifdef;
    }
    
    /**
     * ̃^f[^\vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element ̃^f[^\vfElement
     * @exception DeploymentException vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    public void importXML(Element element) throws DeploymentException{
        comment = getElementComment(element);
    }
    
    /**
     * ̃^f[^\vfXML`ŏo͂B<p>
     *
     * @return XML`
     */
    public StringBuilder toXML(StringBuilder buf){
        return buf;
    }
    
    protected StringBuilder appendComment(StringBuilder buf){
        final String comment = getComment();
        if(comment != null){
            buf.append("<!--");
            if(comment.indexOf('\r') != -1
                || comment.indexOf('\n') != -1){
                buf.append(LINE_SEPARATOR);
                buf.append(addIndent(comment));
                buf.append(LINE_SEPARATOR);
            }else{
                buf.append(' ');
                buf.append(comment);
                buf.append(' ');
            }
            buf.append("-->");
            buf.append(LINE_SEPARATOR);
        }
        return buf;
    }
    
    /**
     * w肳ꂽobt@Ɋi[Ă镶1CfgB<p>
     *
     * @param buf obt@
     * @return obt@
     */
    protected StringBuilder addIndent(StringBuilder buf){
        return setIndent(buf, 1);
    }
    
    /**
     * w肳ꂽ1CfgB<p>
     *
     * @param str 
     * @return 
     */
    protected String addIndent(String str){
        return setIndent(str, 1);
    }
    
    /**
     * w肳ꂽobt@Ɋi[Ă镶wCfgB<p>
     *
     * @param buf obt@
     * @param indent Cfg
     * @return obt@
     */
    protected StringBuilder setIndent(StringBuilder buf, int indent){
        String str = buf.toString();
        str = setIndent(str, indent);
        buf.setLength(0);
        return buf.append(str);
    }
    
    /**
     * w肳ꂽwCfgB<p>
     *
     * @param str 
     * @param indent Cfg
     * @return 
     */
    protected String setIndent(String str, int indent){
        if(str == null){
            return null;
        }
        if(indent <= 0){
            return str;
        }
        final StringBuilder buf = new StringBuilder();
        for(int i = 0; i < indent; i++){
            buf.append(INDENT_STRING);
        }
        final String indentString = buf.toString();
        buf.setLength(0);
        final int length = str.length();
        if(length == 0){
            buf.append(indentString);
            return buf.toString();
        }
        final StringReader sr = new StringReader(str);
        final BufferedReader br = new BufferedReader(sr, length);
        try{
            String line = br.readLine();
            while(line != null){
                buf.append(indentString).append(line);
                line = br.readLine();
                if(line != null){
                    buf.append(LINE_SEPARATOR);
                }
            }
            char lastChar = str.charAt(length - 1);
            if(lastChar == '\r' || lastChar == '\n'){
                buf.append(LINE_SEPARATOR);
            }
        }catch(IOException e){
            // NȂ͂
            e.printStackTrace();
        }finally{
            try{
                br.close();
            }catch(IOException e){
                // NȂ͂
                e.printStackTrace();
            }
            sr.close();
        }
        return buf.toString();
    }
    
    /**
     * w肵vfAqvf̌JԂ锽q擾B<p>
     * Ŏw肳ꂽΏۂelementnull̏ꍇ́AnullԂB܂AqvfAȂꍇ́AJԂvfȂqԂB<br>
     *
     * @param element vf
     * @return qvf̌JԂ锽q
     */
    public static Iterator<Element> getChildren(Element element){
        if(element == null){
            return null;
        }
        
        final NodeList children = element.getChildNodes();
        final List<Element> result = new ArrayList<Element>();
        for(int i = 0, max = children.getLength(); i < max; i++){
            final Node currentChild = children.item(i);
            if(currentChild.getNodeType() == Node.ELEMENT_NODE)
            {
                result.add((Element)currentChild);
            }
        }
        return result.iterator();
    }
    
    /**
     * w肵vfAw肵O̎qvf̌JԂ锽q擾B<p>
     * Ŏw肳ꂽΏۂelementnull̏ꍇ́AnullԂB܂Aw肳ꂽvftagNameAȂꍇ́AJԂvfȂqԂB<br>
     *
     * @param element vf
     * @param tagName vf
     * @return w肵O̎qvf̌JԂ锽q
     */
    public static Iterator<Element> getChildrenByTagName(
        Element element,
        String tagName
    ){
        if(element == null){
            return null;
        }
        
        final NodeList children = element.getChildNodes();
        final List<Element> result = new ArrayList<Element>();
        for(int i = 0, max = children.getLength(); i < max; i++){
            final Node currentChild = children.item(i);
            if(currentChild.getNodeType() == Node.ELEMENT_NODE
                 && ((Element)currentChild).getTagName().equals(tagName))
            {
                result.add((Element)currentChild);
            }
        }
        return result.iterator();
    }
    
    /**
     * w肵vfAw肵OȊO̎qvf̌JԂ锽q擾B<p>
     * Ŏw肳ꂽΏۂelementnull̏ꍇ́AnullԂB܂Aw肳ꂽvftagNameȊO̗vfAȂꍇ́AJԂvfȂqԂB<br>
     *
     * @param element vf
     * @param tagNames Ovf
     * @return w肵OȊO̎qvf̌JԂ锽q
     */
    public static Iterator<Element> getChildrenWithoutTagName(
        Element element,
        String[] tagNames
    ){
        if(element == null){
            return null;
        }
        
        final NodeList children = element.getChildNodes();
        final List<Element> result = new ArrayList<Element>();
        for(int i = 0, max = children.getLength(); i < max; i++){
            final Node currentChild = children.item(i);
            if(currentChild.getNodeType() == Node.ELEMENT_NODE){
                boolean isMatch = false;
                if(tagNames != null){
                    for(int j = 0; j < tagNames.length; j++){
                        if(((Element)currentChild).getTagName()
                            .equals(tagNames[j])){
                            isMatch = true;
                            break;
                        }
                    }
                }
                if(!isMatch){
                    result.add((Element)currentChild);
                }
            }
        }
        return result.iterator();
    }
    
    /**
     * w肵vfACӂ̖O̗BK{̎qvf擾B<p>
     * qvf`Ăꍇ́AOthrowB܂A`ĂȂꍇOthrowB<br>
     *
     * @param element vf
     * @return Cӂ̗B̎qvf
     * @exception DeploymentException qvf`ĂA܂͒`ĂȂꍇ
     */
    public static Element getUniqueChild(Element element)
     throws DeploymentException{
        Element result = null;
        final NodeList children = element.getChildNodes();
        for(int i = 0, max = children.getLength(); i < max; i++){
            final Node currentChild = children.item(i);
            if(currentChild.getNodeType() == Node.ELEMENT_NODE){
                if(result != null){
                    throw new DeploymentException(
                        "Expected only one any tag"
                    );
                }
                result = (Element)currentChild;
            }
        }
        if(result == null){
            throw new DeploymentException(
                "Expected one any tag"
            );
        }
        return result;
    }
    
    /**
     * w肵vfAw肵O̗BK{̎qvf擾B<p>
     * 擾vf`Ăꍇ́AOthrowB܂A`ĂȂꍇOthrowB<br>
     *
     * @param element vf
     * @param tagName vf
     * @return w肵O̎qvf
     * @exception DeploymentException 擾vf`ĂA܂͒`ĂȂꍇ
     */
    public static Element getUniqueChild(Element element, String tagName)
     throws DeploymentException{
        final Iterator<Element> children = getChildrenByTagName(element, tagName);
        
        if(children != null && children.hasNext()){
            final Element child = children.next();
            if(children.hasNext()){
                throw new DeploymentException(
                    "Expected only one " + tagName + " tag"
                );
            }
            return child;
        }else{
            throw new DeploymentException(
                "Expected one " + tagName + " tag"
            );
        }
    }
    
    /**
     * w肵vfACӂ̖O̗B̎qvf擾B<p>
     * qvf`Ăꍇ́AOthrowB<br>
     *
     * @param element vf
     * @return Cӂ̗B̎qvf
     * @exception DeploymentException qvf`Ăꍇ
     */
    public static Element getOptionalChild(Element element)
     throws DeploymentException{
        if(element == null){
            return null;
        }
        Element result = null;
        final NodeList children = element.getChildNodes();
        for(int i = 0, max = children.getLength(); i < max; i++){
            final Node currentChild = children.item(i);
            if(currentChild.getNodeType() == Node.ELEMENT_NODE){
                if(result != null){
                    throw new DeploymentException(
                        "Expected only one any tag"
                    );
                }
                result = (Element)currentChild;
            }
        }
        return result;
    }
    
    /**
     * w肵vfAw肵O̗B̎qvf擾B<p>
     * 擾vf`Ăꍇ́AOthrowB<br>
     * w肵O̗vf`ĂȂꍇ́AnullԂB<br>
     * {@link #getOptionalChild(Element, String, Element)}AgetOptionalChild(element, tagName, null)ŌĂяôƓłB<br>
     *
     * @param element vf
     * @param tagName vf
     * @return w肵O̎qvf
     * @exception DeploymentException 擾vf`Ăꍇ
     * @see #getOptionalChild(Element, String, Element)
     */
    public static Element getOptionalChild(Element element, String tagName)
     throws DeploymentException{
        return getOptionalChild(element, tagName, null);
    }
    
    /**
     * w肵vfAw肵O̗B̎qvf擾B<p>
     * 擾vf`Ăꍇ́AOthrowB<br>
     * w肵O̗vf`ĂȂꍇ́AŎw肳ꂽdefaultElementԂB<br>
     *
     * @param element vf
     * @param tagName vf
     * @param defaultElement ftHgl
     * @return w肵O̎qvf
     * @exception DeploymentException 擾vf`Ăꍇ
     */
    public static Element getOptionalChild(
        Element element,
        String tagName,
        Element defaultElement
    ) throws DeploymentException{
        final Iterator<Element> children = getChildrenByTagName(element, tagName);
        
        if(children != null && children.hasNext()){
            final Element child = children.next();
            if(children.hasNext()){
                throw new DeploymentException(
                    "Expected only one " + tagName + " tag"
                );
            }
            return child;
        }else{
            return defaultElement;
        }
    }
    
    /**
     * w肵vf̓e擾B<p>
     * ȅꍇ́A󕶎ԂB<br>
     * {@link #getElementContent(Element, String)}AgetElementContent(element,  null)ŌĂяôƓłB<br>
     *
     * @param element vf
     * @return vf̓e
     * @see #getElementContent(Element, String)
     */
    public static String getElementContent(Element element){
        return getElementContent(element, null);
    }
    
    /**
     * w肵vf̓e擾B<p>
     * ȅꍇ́AŎw肳ꂽdefaultStrԂB<br>
     *
     * @param element vf
     * @param defaultStr ftHgl
     * @return vf̓e
     */
    public static String getElementContent(Element element, String defaultStr){
        if(element == null){
            return defaultStr;
        }
        
        final NodeList children = element.getChildNodes();
        if(children.getLength() == 0){
            return defaultStr;
        }
        String result = null;
        for(int i = 0, max = children.getLength(); i < max; i++){
            if(children.item(i).getNodeType() == Node.TEXT_NODE
                 || children.item(i).getNodeType() == Node.CDATA_SECTION_NODE
            ){
                if(result == null){
                    result = "";
                }
                result += children.item(i).getNodeValue();
            }else if(children.item(i).getNodeType() == Node.COMMENT_NODE){
                // Rg͖
            }
        }
        return trim(result);
    }
    
    /**
     * w肵vf̃Rg擾B<p>
     * Rg݂Ȃꍇ́AnullԂB<br>
     *
     * @param element vf
     * @return vf̃Rg
     */
    public static String getElementComment(Element element){
        Node currentNode = element;
        boolean isComment = false;
        while((currentNode = currentNode.getPreviousSibling()) != null){
            switch(currentNode.getNodeType()){
            case Node.TEXT_NODE:
            case Node.CDATA_SECTION_NODE:
                continue;
            case Node.COMMENT_NODE:
                isComment = true;
                break;
            default:
                return null;
            }
            if(isComment){
                break;
            }
        }
        return currentNode == null ? null : trim(currentNode.getNodeValue());
    }
    
    public static String trim(String str){
        if(str == null){
            return null;
        }
        final StringBuilder buf = new StringBuilder();
        int line = 0;
        boolean isFirst = true;
        for(int i = 0, max = str.length(); i < max; i++){
            char c = str.charAt(i);
            switch(c){
            case '\r':
                if(line != 0 || !isFirst){
                    buf.append(c);
                }
                if(i != max - 1 && str.charAt(i + 1) == '\n'){
                    if(line != 0 || !isFirst){
                        buf.append('\n');
                    }
                    i++;
                }
                isFirst = true;
                line++;
                break;
            case '\n':
                if(line != 0 || !isFirst){
                    buf.append(c);
                }
                line++;
                isFirst = true;
                break;
            case '\t':
                if(!isFirst){
                    buf.append(c);
                }
                break;
            case ' ':
                if(!isFirst){
                    buf.append(c);
                }
                break;
            default:
                isFirst = false;
                buf.append(c);
            }
        }
        return buf.toString().trim();
    }
    
    /**
     * w肵vfAw肵O̗BK{̎qvf擾A̓e擾B<p>
     * 擾vf`Ăꍇ́AOthrowB܂A`ĂȂꍇOthrowB<br>
     * {@link #getUniqueChild(Element, String)}Ŏ擾ElementɂāA{@link #getElementContent(Element)}ĂяôƓłB<br>
     *
     * @param element vf
     * @param tagName vf
     * @return w肵O̎qvf̓e
     * @exception DeploymentException 擾vf`ĂA܂͒`ĂȂꍇ
     * @see #getUniqueChild(Element, String)
     * @see #getElementContent(Element)
     */
    public static String getUniqueChildContent(Element element, String tagName)
     throws DeploymentException{
        return getElementContent(getUniqueChild(element, tagName));
    }
    
    /**
     * w肵vfAw肵O̗B̎qvf擾A̓e擾B<p>
     * 擾vf`Ăꍇ́AOthrowB<br>
     * {@link #getOptionalChild(Element, String)}Ŏ擾ElementɂāA{@link #getElementContent(Element)}ĂяôƓłB<br>
     *
     * @param element vf
     * @param tagName vf
     * @return w肵O̎qvf̓e
     * @exception DeploymentException 擾vf`Ăꍇ
     * @see #getOptionalChild(Element, String)
     * @see #getElementContent(Element)
     */
    public static String getOptionalChildContent(
        Element element,
        String tagName
    ) throws DeploymentException{
        return getElementContent(getOptionalChild(element, tagName));
    }
    
    /**
     * w肵vfAw肵O̗B̎qvf擾A̓ebooleanlƂĎ擾B<p>
     * 擾vf`Ăꍇ́AOthrowB<br>
     * e̕񂪁A"true"܂"yes"܂"on"i啶j̏ꍇAtrueƂȂB<br>
     *
     * @param element vf
     * @param name vf
     * @return w肵O̎qvf̓ebooleanɕϊl
     * @exception DeploymentException 擾vf`Ăꍇ
     */
     public static boolean getOptionalChildBooleanContent(
        Element element,
        String name
    ) throws DeploymentException{
        final Element child = getOptionalChild(element, name);
        if(child != null){
            String value = getElementContent(child);
            if(value == null){
                return false;
            }else{
                value = value.toLowerCase();
            }
            return Boolean.valueOf(value).booleanValue()
                 || value.equalsIgnoreCase("yes")
                 || value.equalsIgnoreCase("on");
        }
        
        return false;
    }
    
    /**
     * w肵vfAw肵O̕K{̒l擾B<p>
     * w肵݂̑ȂꍇAOthrowB<br>
     *
     * @param element vf
     * @param name 
     * @return ̒l
     * @exception DeploymentException 擾݂Ȃꍇ
     */
    public static String getUniqueAttribute(Element element, String name)
     throws DeploymentException{
        
        if(element.hasAttribute(name)){
            return element.getAttribute(name);
        }else{
            throw new DeploymentException(
                name + " attribute is require."
            );
        }
    }
    
    /**
     * w肵vfAw肵Ȏ̒l擾B<p>
     * w肵݂̑Ȃꍇ́AnullԂB<br>
     * {@link #getOptionalAttribute(Element, String, String)}AgetOptionalAttribute(element, name, null)ŌĂяôƓłB<br>
     *
     * @param element vf
     * @param name 
     * @return ̒l
     * @see #getOptionalAttribute(Element, String, String)
     */
    public static String getOptionalAttribute(Element element, String name){
        return getOptionalAttribute(element, name, null);
    }
    
    /**
     * w肵vfAw肵Ȏ̒l擾B<p>
     * w肵݂̑Ȃꍇ́AŎw肳ꂽdefaultStrԂB<br>
     *
     * @param element vf
     * @param name 
     * @param defaultStr ftHgl
     * @return ̒l
     */
    public static String getOptionalAttribute(
        Element element,
        String name,
        String defaultStr
    ){
        
        if(element.hasAttribute(name)){
            return element.getAttribute(name);
        }else{
            return defaultStr;
        }
    }
    
    /**
     * w肵vfAw肵Ȏ̒l擾A̓ebooleanlƂĎ擾B<p>
     * 擾vf`Ăꍇ́AOthrowB<br>
     * e̕񂪁A"true"܂"yes"܂"on"i啶j̏ꍇAtrueƂȂB<br>
     * w肵݂̑Ȃꍇ́AfalseԂB<br>
     *
     * @param element vf
     * @param name 
     * @return ̒l
     * @see #getOptionalAttribute(Element, String, String)
     */
    public static boolean getOptionalBooleanAttribute(
        Element element,
        String name
    ){
        final String value = getOptionalAttribute(element, name, null);
        if(value != null){
            return Boolean.valueOf(value).booleanValue()
                 || value.equalsIgnoreCase("yes")
                 || value.equalsIgnoreCase("on");
        }
        return false;
    }
    
    /**
     * w肵vfAw肵Ȏ̒l擾A̓ebooleanlƂĎ擾B<p>
     * 擾vf`Ăꍇ́AOthrowB<br>
     * e̕񂪁A"true"܂"yes"܂"on"i啶j̏ꍇAtrueƂȂB<br>
     * w肵݂̑Ȃꍇ́AŎw肳ꂽdefaultValԂB<br>
     *
     * @param element vf
     * @param name 
     * @param defaultVal ftHgl
     * @return ̒l
     * @see #getOptionalAttribute(Element, String, String)
     */
    public static boolean getOptionalBooleanAttribute(
        Element element,
        String name,
        boolean defaultVal
    ){
        final String value = getOptionalAttribute(element, name, null);
        if(value != null){
            return Boolean.valueOf(value).booleanValue()
                || value.equalsIgnoreCase("yes")
                || value.equalsIgnoreCase("on");
        }
        return defaultVal;
    }
    
    /**
     * ̃CX^X̕𐶐B<p>
     *
     * @return ̃CX^X̕
     */
    @Override
    public Object clone(){
        Object clone = null;
        try{
            clone = super.clone();
        }catch(CloneNotSupportedException ignore){
        }
        return clone;
    }
}
