/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.concurrent.*;
import java.lang.reflect.InvocationTargetException;

/**
 * vpeBANZXB<p>
 * xgp{@link Property}LbVčėpB<br>
 *
 * @author M.Takata
 */
public class PropertyAccess{
    
    private boolean isIgnoreNullProperty = false;
    
    private ConcurrentMap<String, Property> propertyCache = new ConcurrentHashMap<String, Property>();
    
    private static PropertyAccess instance;
    
    private static PropertyAccess instanceForIgnoreNullProperty;
    
    /**
     * CX^X𐶐B<p>
     */
    public PropertyAccess(){
    }
    
    /**
     * VOgȃCX^X擾B<p>
     *
     * @param isIgnoreNullProperty nullQƂ̎ɗOthrowȂꍇtrue
     * @return VOgȃCX^X
     */
    public static synchronized PropertyAccess getInstance(boolean isIgnoreNullProperty){
        if(isIgnoreNullProperty){
            if(instance == null){
                instance = new PropertyAccess(){
                    public void setIgnoreNullProperty(boolean isIgnore){
                    }
                };
            }
            return instance;
        }else{
            if(instanceForIgnoreNullProperty == null){
                instanceForIgnoreNullProperty = new PropertyAccess(){
                    public void setIgnoreNullProperty(boolean isIgnore){
                    }
                };
                instanceForIgnoreNullProperty.isIgnoreNullProperty = true;
            }
            return instanceForIgnoreNullProperty;
        }
    }
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isIgnore nullQƂ̎ɗOthrowȂꍇtrue
     */
    public void setIgnoreNullProperty(boolean isIgnore){
        if(this == instance || this == instanceForIgnoreNullProperty){
            return;
        }
        isIgnoreNullProperty = isIgnore;
    }
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAnullQƂ̎ɗOthrowȂ
     */
    public boolean isIgnoreNullProperty(){
        return isIgnoreNullProperty;
    }
    
    /**
     * w肵IuWFNg̎w肵vpeB̒l擾B<p>
     *
     * @param target vpeB̎擾ΏۂƂȂBean
     * @param prop vpeB
     * @return vpeBl
     * @exception IllegalArgumentException w肳ꂽvpeB̃tH[}bgȂꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanAw肵vpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public Object get(Object target, String prop) throws IllegalArgumentException, NoSuchPropertyException, InvocationTargetException{
        return getProperty(prop).getProperty(target);
    }
    
    /**
     * w肵IuWFNg̎w肵vpeBɒlݒ肷B<p>
     *
     * @param target vpeB̐ݒΏۂƂȂBean
     * @param prop vpeB
     * @param value ݒ肷vpeBl
     * @exception IllegalArgumentException w肳ꂽvpeB̃tH[}bgȂꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanAw肵vpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public void set(Object target, String prop, Object value) throws IllegalArgumentException, NoSuchPropertyException, InvocationTargetException{
        getProperty(prop).setProperty(target, value);
    }
    
    /**
     * w肵vpeB̃vpeB擾B<p>
     *
     * @param prop vpeB
     * @return vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃tH[}bgȂꍇ
     */
    public Property getProperty(String prop) throws IllegalArgumentException{
        Property property = propertyCache.get(prop);
        if(property == null){
            property = PropertyFactory.createProperty(prop);
            property.setIgnoreNullProperty(isIgnoreNullProperty);
            Property exists = propertyCache.putIfAbsent(prop, property);
            if(exists != null){
                property = exists;
            }
        }
        return property;
    }
    
    /**
     * LbVĂvpeBNAB<p>
     */
    public void clear(){
        propertyCache.clear();
    }
}