/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Element;

import static jp.ossc.nimbus.TestUtility.*;

/**
 * {@link StaticFieldRefMetaData}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class StaticFieldRefMetaDataTest{

    @DataProvider(name = "StaticFieldRefMetaData")
    public Object[][] dataStaticFieldRefMetaData(){
        return new Object[][]{
            {null},
            {new ObjectMetaData()},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.StaticFieldRefMetaData#StaticFieldRefMetaData(jp.ossc.nimbus.core.MetaData)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*"},
          dataProvider = "StaticFieldRefMetaData")
    public void testStaticFieldRefMetaData(MetaData parent){
        StaticFieldRefMetaData metaData = new StaticFieldRefMetaData(parent);
        assertEquals(metaData.getParent(), parent);
        assertNull(metaData.getCode());
        assertNull(metaData.getName());
    }

    @DataProvider(name = "SetCode")
    public Object[][] dataSetCode(){
        return new Object[][]{
            {null},
            {"test.Hoge"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.StaticFieldRefMetaData#setCode(java.lang.String)",
                    "jp.ossc.nimbus.core.StaticFieldRefMetaData#getCode()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#StaticFieldRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetCode")
    public void testSetCode(String code){
        StaticFieldRefMetaData metaData = new StaticFieldRefMetaData(null);
        metaData.setCode(code);
        assertEquals(metaData.getCode(), code);
    }

    @DataProvider(name = "SetName")
    public Object[][] dataSetName(){
        return new Object[][]{
            {null},
            {"hoge"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.StaticFieldRefMetaData#setName(java.lang.String)",
                    "jp.ossc.nimbus.core.StaticFieldRefMetaData#getName()",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#StaticFieldRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "SetName")
    public void testSetName(String name){
        StaticFieldRefMetaData metaData = new StaticFieldRefMetaData(null);
        metaData.setName(name);
        assertEquals(metaData.getName(), name);
    }

    @DataProvider(name = "ImportXML")
    public Object[][] dataImportXML() throws Exception{
        return new Object[][]{
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"hoge\"/>"), new Object[]{"test.Hoge", "hoge"}},
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"hoge\"><unknown/></static-field-ref>"), new Object[]{"test.Hoge", "hoge"}},
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"hoge\" unknown=\"hoge\"/>"), new Object[]{"test.Hoge", "hoge"}},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.StaticFieldRefMetaData#importXML(org.w3c.dom.Element)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#StaticFieldRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#getCode\\(\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#getName\\(\\)"},
          dataProvider = "ImportXML")
    public void testImportXML(
        Element element,
        Object[] assertValues
    ) throws DeploymentException{
        StaticFieldRefMetaData metaData = new StaticFieldRefMetaData(null);
        metaData.importXML(element);
        assertEquals(metaData.getCode(), assertValues[0]);
        assertEquals(metaData.getName(), assertValues[1]);
    }

    @DataProvider(name = "ImportXMLError")
    public Object[][] dataImportXMLError() throws Exception{
        return new Object[][]{
            {null},
            {createElement("<hoge/>")},
            {createElement("<static-field-ref/>")},
            {createElement("<static-field-ref code=\"test.Hoge\"/>")},
            {createElement("<static-field-ref name=\"hoge\"/>")},
            {createElement("<static-field-ref code=\"\" name=\"hoge\"/>")},
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"\"/>")},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.StaticFieldRefMetaData#importXML(org.w3c.dom.Element)",
                    "Error"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#StaticFieldRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          expectedExceptions = {NullPointerException.class, DeploymentException.class},
          dataProvider = "ImportXMLError")
    public void testImportXMLError(Element element) throws DeploymentException{
        StaticFieldRefMetaData metaData = new StaticFieldRefMetaData(null);
        metaData.importXML(element);
    }

    @DataProvider(name = "ToXML")
    public Object[][] dataToXML() throws Exception{
        return new Object[][]{
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"hoge\"/>"), "<static-field-ref code=\"test.Hoge\" name=\"hoge\"/>"},
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"hoge\"></static-field-ref>"), "<static-field-ref code=\"test.Hoge\" name=\"hoge\"/>"},
            {createElement("<static-field-ref code=\"test.Hoge\" name=\"hoge\"><unknown/></static-field-ref>"), "<static-field-ref code=\"test.Hoge\" name=\"hoge\"/>"},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.StaticFieldRefMetaData#toXML(java.lang.StringBuilder)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.MetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#StaticFieldRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)",
                             "jp\\.ossc\\.nimbus\\.core\\.StaticFieldRefMetaData#importXML\\(org\\.w3c\\.dom\\.Element\\)"},
          dataProvider = "ToXML")
    public void testToXML(Element element, String expected) throws DeploymentException{
        StaticFieldRefMetaData metaData = new StaticFieldRefMetaData(null);
        metaData.importXML(element);
        StringBuilder buf = new StringBuilder();
        metaData.toXML(buf);
        assertEquals(buf.toString(), expected);
    }
}
