/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.math.BigDecimal;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link BigDecimalEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class BigDecimalEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
            {"100", new BigDecimal("100")},
            {"100.123", new BigDecimal("100.123")}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.BigDecimalEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.BigDecimalEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsText")
    public void testSetAsText(String paramStr, BigDecimal answer){
        editorSetText(BigDecimalEditor.class, paramStr, answer);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
            {"test.BigDecimalEditor.value", "123.4", "${test.BigDecimalEditor.value}", new BigDecimal("123.4")}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.BigDecimalEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.BigDecimalEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsTextProperty")
    public void testSetTextSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, BigDecimal answer){
        editorSetTextSystemProperty(BigDecimalEditor.class, propertyKeyStr, propertyValStr, paramStr, answer);
    }
    
    @DataProvider(name = "SetValue")
    public Object[][] dataSetValue(){
        return new Object[][]{
            {new BigDecimal("100"), "100"},
            {new BigDecimal("200.1"), "200.1"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.BigDecimalEditor#setValue(java.math.BigDecimal)",
                    "jp.ossc.nimbus.beans.BigDecimalEditor#getAsText()",
                    "Normal"},
        dataProvider = "SetValue")
    public void testSetValue(BigDecimal param, String answerStr){
        editorSetValue(BigDecimalEditor.class, param, answerStr);
    }
}
