package jp.ossc.nimbus.beans;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.fail;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;

public abstract class BeansTestBase {
    
    public void editorSetText(
            Class<? extends PropertyEditorSupport> clazz, 
            String paramStr, 
            Object answer
            ){
        
        PropertyEditorSupport editor = null;
        try {
            editor = clazz.newInstance();
        } catch (InstantiationException e) {
            fail(e.getMessage());
        } catch (IllegalAccessException e) {
            fail(e.getMessage());
        }
        
        editor.setAsText(paramStr);
        assertEquals(editor.getValue(), answer);
    }
    
    public void arrayEditorSetText(
            Class<? extends ArrayEditor> clazz, 
            String paramStr, 
            Object[] answerArray
            ){
        ArrayEditor editor = null;
        try {
            editor = clazz.newInstance();
        } catch (InstantiationException e) {
            fail(e.getMessage());
        } catch (IllegalAccessException e) {
            fail(e.getMessage());
        }
        
        editor.setAsText(paramStr);
        
        Object val = editor.getValue();
        if(answerArray == null || answerArray.length <= 0){
            assertEquals(null, val);
        }else if(answerArray.length == 1 && answerArray[0] == null){
            assertEquals(null, val);
        }else{
            int paramLength = answerArray.length;
            assertEquals(paramLength, Array.getLength(val));
            for(int i = 0 ; i < answerArray.length ; i++){
                assertEquals(Array.get(val, i), answerArray[i]);
            }
        }
    }
    
    public void editorSetTextSystemProperty(
            Class<? extends PropertyEditorSupport> clazz, 
            String propertyKeyStr, 
            String propertyValStr, 
            String paramStr, 
            Object answer
            ){
        
        System.setProperty(propertyKeyStr, propertyValStr);
        PropertyEditorSupport editor = null;
        try {
            editor = clazz.newInstance();
        } catch (InstantiationException e) {
            fail(e.getMessage());
        } catch (IllegalAccessException e) {
            fail(e.getMessage());
        }
        
        editor.setAsText(paramStr);
        assertEquals(answer, editor.getValue());
    }
    
    public void arrayEditorSetTextSystemProperty(
            Class<? extends ArrayEditor> clazz, 
            String propertyKeyStr, 
            String propertyValStr, 
            String paramStr, 
            Object[] answerArray
            ){
        System.setProperty(propertyKeyStr, propertyValStr);
        ArrayEditor editor = null;
        try {
            editor = clazz.newInstance();
        } catch (InstantiationException e) {
            fail(e.getMessage());
        } catch (IllegalAccessException e) {
            fail(e.getMessage());
        }
        
        editor.setAsText(paramStr);
        int paramLength = answerArray.length;
        Object val = editor.getValue();
        assertEquals(paramLength, Array.getLength(val));
        for(int i = 0 ; i < answerArray.length ; i++){
            assertEquals(answerArray[i], Array.get(val, i));
        }
    }
    
    public void editorSetValue(
            Class<? extends PropertyEditorSupport> clazz, 
            Object param,
            String answerStr
            ){
        PropertyEditorSupport editor = null;
        try {
            editor = clazz.newInstance();
        } catch (InstantiationException e) {
            fail(e.getMessage());
        } catch (IllegalAccessException e) {
            fail(e.getMessage());
        }
        
        editor.setValue(param);
        assertEquals(answerStr, editor.getAsText());
    }
    
    public void arrayEditorSetValue(
            Class<? extends ArrayEditor> clazz, 
            Object[] paramArray, 
            String answerStr
            ){
        ArrayEditor editor = null;
        try {
            editor = clazz.newInstance();
        } catch (InstantiationException e) {
            fail(e.getMessage());
        } catch (IllegalAccessException e) {
            fail(e.getMessage());
        }
        editor.setValue(paramArray);
        assertEquals(answerStr, editor.getAsText());
    }
}
