/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 *
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.text.*;

/**
 * ttH[}bgRo[^B<p>
 *
 * @author M.Takata
 */
public class DateFormatConverter
 implements FormatConverter, java.io.Serializable{

    private static final long serialVersionUID = -1183874197480695923L;

    /**
     * t\ϊʒ萔B<p>
     */
    public static final int DATE_TO_STRING = OBJECT_TO_STRING;

    /**
     * 񁨓t\ϊʒ萔B<p>
     */
    public static final int STRING_TO_DATE = STRING_TO_OBJECT;

    /**
     * ϊʁB<p>
     */
    protected int convertType;

    /**
     * tH[}bgB<p>
     */
    protected String format;

    /**
     * nꂽDatenull̏ꍇɕԂB<p>
     */
    protected String nullString = "";

    /**
     * tH[}bg"yyyy/MM/dd HH:mm:ss.SSS"œtϊsRo[^𐶐B<p>
     */
    public DateFormatConverter(){
        this(DATE_TO_STRING, "yyyy/MM/dd HH:mm:ss.SSS");
    }

    /**
     * w肳ꂽϊʂ̃Ro[^𐶐B<p>
     *
     * @param type ϊ
     * @param format ltH[}bg
     * @see #DATE_TO_STRING
     * @see #STRING_TO_DATE
     */
    public DateFormatConverter(int type, String format){
        setConvertType(type);
        setFormat(format);
    }

    /**
     * ϊʂݒ肷B<p>
     *
     * @param type ϊ
     * @see #getConvertType()
     * @see #DATE_TO_STRING
     * @see #STRING_TO_DATE
     */
    @Override
    public void setConvertType(int type){
        convertType = type;
        switch(convertType){
        case DATE_TO_STRING:
        case STRING_TO_DATE:
            break;
        default:
            throw new IllegalArgumentException(
                "Invalid convert type : " + type
            );
        }
    }

    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }

    /**
     * ϊtH[}bgݒ肷B<p>
     *
     * @param format {@link SimpleDateFormat}̕ϊtH[}bg
     */
    @Override
    public void setFormat(String format){
        this.format = format;
        try{
            new SimpleDateFormat(format);
        } catch(NullPointerException e){
            throw new IllegalArgumentException(
                    "Invalid date format : " + format
                );
        }
    }

    /**
     * ϊtH[}bg擾B<p>
     *
     * @return ϊtH[}bg
     * @see #setFormat(String)
     */
    public String getFormat(){
        return format;
    }

    /**
     * nꂽDatenull̏ꍇɕԂݒ肷B<p>
     * ftHǵA󕶎B<br>
     *
     * @param str nꂽDatenull̏ꍇɕԂ
     */
    public void setNullString(String str){
        nullString = str;
    }

    /**
     * nꂽDatenull̏ꍇɕԂ擾B<p>
     *
     * @return nꂽDatenull̏ꍇɕԂ
     */
    public String getNullString(){
        return nullString;
    }

    /**
     * w肳ꂽIuWFNgϊB<p>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{

        switch(convertType){
        case STRING_TO_DATE:
            if(obj == null || ((String)obj).length() == 0){
                return null;
            }
            try{
                return new SimpleDateFormat(format).parse((String)obj);
            }catch(ParseException e){
                throw new ConvertException(e);
            }
        case DATE_TO_STRING:
        default:
            if(obj == null){
                return nullString;
            }
            return new SimpleDateFormat(format).format(obj);
        }
    }
}
