/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util;

import java.util.Iterator;
import java.util.Collections;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.LinkedHashMap;

/**
 * ҋ@j^B<p>
 * Object.wait()ɂ́AʒmA荞݁A^CAEgȂɍĊJuXvAXEFCNAbvvƂۂ݂B<br>
 * ́AwaitAnotifyfgvO}[ɂƂāAȖłB<br>
 * ̃NX́A̖A[eBeBNXłB<br>
 * 
 * @author M.Takata
 */
public class WaitSynchronizeMonitor implements SynchronizeMonitor, java.io.Serializable{
    
    private static final long serialVersionUID = -2224847461399411455L;
    
    protected transient Map<Thread,MonitorFlag> monitorFlagMap = Collections.synchronizedMap(new LinkedHashMap<Thread,MonitorFlag>());
    
    protected boolean isClosed;
    
    /**
     * CX^X𐶐B<p>
     */
    public WaitSynchronizeMonitor(){
    }
    
    /**
     * ĂяoXbhɑ΂郂j^B<p>
     * {@link #waitMonitor()}A{@link #waitMonitor(long)}ĂяoOɁÃ\bhĂԕKvB<br>
     *
     * @return j^OɒʒmĂtrue
     */
    public synchronized boolean initMonitor(){
        return initMonitor(Thread.currentThread());
    }
    
    /**
     * w肵Xbhɑ΂郂j^B<p>
     * w肵XbhA{@link #waitMonitor()}A{@link #waitMonitor(long)}ĂяoOɁÃ\bhĂԕKvB<br>
     *
     * @param thread ̃j^ɑ΂đҋ@Xbh
     * @return j^OɒʒmĂtrue
     */
    public synchronized boolean initMonitor(Thread thread){
        if(isClosed){
            return true;
        }
        MonitorFlag monitorFlag = (MonitorFlag)monitorFlagMap.get(thread);
        if(monitorFlag == null){
            monitorFlag = new MonitorFlag();
            monitorFlagMap.put(thread, monitorFlag);
        }
        boolean isNotify = monitorFlag.isNotify;
        monitorFlag.isWait = false;
        monitorFlag.isNotify = false;
        return isNotify;
    }
    
    /**
     * ĂяoXbhɑ΂郂j^B<p>
     * Xbhł̃j^ėpꍇɂ́Ã\bhĂяoȂĂǂB<br>
     */
    public synchronized void releaseMonitor(){
        final Thread currentThread = Thread.currentThread();
        monitorFlagMap.remove(currentThread);
    }
    
    /**
     * SẴj^B<p>
     */
    public synchronized void releaseAllMonitor(){
        monitorFlagMap.clear();
    }
    
    /**
     * ʒm܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public synchronized void initAndWaitMonitor() throws InterruptedException{
        initAndWaitMonitor(-1);
    }
    
    /**
     * ʒm邩Aw肳ꂽԂo߂܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @return ʒmɂċNꂽꍇtrueB^CAEgꍇfalse
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public synchronized boolean initAndWaitMonitor(long timeout) throws InterruptedException{
        return !initMonitor() ? waitMonitor(timeout) : true;
    }
    
    /**
     * ʒm܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public synchronized void waitMonitor() throws InterruptedException{
        waitMonitor(-1);
    }
    
    /**
     * ʒm邩Aw肳ꂽԂo߂܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @return ʒmɂċNꂽꍇtrueB^CAEgꍇfalse
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public synchronized boolean waitMonitor(long timeout) throws InterruptedException{
        if(isClosed){
            return true;
        }
        long startTime = System.currentTimeMillis();
        final Thread currentThread = Thread.currentThread();
        MonitorFlag monitorFlag = (MonitorFlag)monitorFlagMap.get(currentThread);
        if(monitorFlag == null){
            return false;
        }
        if(monitorFlag.isNotify){
            return true;
        }
        monitorFlag.isWait = true;
        try{
            long waitTime = timeout;
            while(!monitorFlag.isNotify){
                if(timeout > 0){
                    if(waitTime >= 0){
                        wait(waitTime);
                    }
                    waitTime = timeout - (System.currentTimeMillis() - startTime);
                    if(waitTime <= 0){
                        break;
                    }
                }else{
                    wait();
                }
                if(isClosed){
                    return true;
                }
            }
        }finally{
            monitorFlag.isWait = false;
        }
        boolean isNotify = monitorFlag.isNotify;
        monitorFlag.isNotify = false;
        return isNotify;
    }
    
    /**
     * ҋ@Ăŏ̃XbhɒʒmB<p>
     */
    public synchronized void notifyMonitor(){
        if(monitorFlagMap.size() != 0){
            ((MonitorFlag)monitorFlagMap.values().iterator().next()).isNotify = true;
        }
        notifyAll();
    }
    
    /**
     * ҋ@ĂSẴXbhɒʒmB<p>
     */
    public synchronized void notifyAllMonitor(){
        if(monitorFlagMap.size() != 0){
            final Iterator<MonitorFlag> itr = monitorFlagMap.values().iterator();
            while(itr.hasNext()){
                itr.next().isNotify = true;
            }
        }
        notifyAll();
    }
    
    /**
     * ̃XbhʒmɂċNꂽǂ𔻒肷B<p>
     * 
     * @return ʒmɂċNꂽꍇtrue
     */
    public synchronized boolean isNotify(){
        if(isClosed){
            return true;
        }
        final Thread currentThread = Thread.currentThread();
        MonitorFlag monitorFlag = (MonitorFlag)monitorFlagMap.get(currentThread);
        return monitorFlag != null && monitorFlag.isNotify;
    }
    
    /**
     * ŏɑҋ@ĂXbh݂̃Xbhǂ𔻒肷B<p>
     * 
     * @return ŏɑҋ@ĂXbh݂̃Xbhłꍇtrue
     */
    public synchronized boolean isFirst(){
        if(monitorFlagMap.size() == 0){
            return false;
        }
        final Thread currentThread = Thread.currentThread();
        if(!monitorFlagMap.containsKey(currentThread)){
            return false;
        }
        Thread first = (Thread)monitorFlagMap.keySet().iterator().next();
        return first == null ? false : first.equals(currentThread);
    }
    
    /**
     * ҋ@ĂXbh݂邩ǂ𔻒肷B<p>
     * 
     * @return ҋ@ĂXbh݂ꍇtrue
     */
    public synchronized boolean isWait(){
        if(monitorFlagMap.size() != 0){
            final Iterator<MonitorFlag> itr = monitorFlagMap.values().iterator();
            while(itr.hasNext()){
                if(itr.next().isWait){
                    return true;
                }
            }
        }
        return false;
    }
    
    /**
     * ҋ@ĂXbh̐擾B<p>
     * 
     * @return ҋ@ĂXbh̐
     */
    public synchronized int getWaitCount(){
        int count = 0;
        if(monitorFlagMap.size() != 0){
            final Iterator<MonitorFlag> itr = monitorFlagMap.values().iterator();
            while(itr.hasNext()){
                if(itr.next().isWait){
                    count++;
                }
            }
        }
        return count;
    }
    
    /**
     * ҋ@ĂXbh擾B<p>
     * 
     * @return ҋ@ĂXbh̔z
     */
    public synchronized Thread[] getWaitThreads(){
        final List<Thread> result = new ArrayList<Thread>();
        if(monitorFlagMap.size() != 0){
            final Iterator<Map.Entry<Thread, MonitorFlag>> entries = monitorFlagMap.entrySet().iterator();
            while(entries.hasNext()){
                Map.Entry<Thread, MonitorFlag> entry = entries.next();
                if(entry.getValue().isWait){
                    result.add(entry.getKey());
                }
            }
        }
        return (Thread[])result.toArray(new Thread[result.size()]);
    }
    
    public synchronized void close(){
        isClosed = true;
        notifyAllMonitor();
    }
    
    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException{
        in.defaultReadObject();
        monitorFlagMap = Collections.synchronizedMap(new LinkedHashMap<Thread, MonitorFlag>());
    }
    
    protected static final class MonitorFlag implements java.io.Serializable{
        private static final long serialVersionUID = -4683612743846239879L;
        public boolean isWait;
        public boolean isNotify;
    }
}