/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.servlet;

import java.util.Properties;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link MappingBeanFlowSelectorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MappingBeanFlowSelectorService
 */
public interface MappingBeanFlowSelectorServiceMBean extends ServiceBaseMBean{
    
    /**
     * NGXgpXƃANVt[̃}bsOݒ肷B<p>
     *
     * @param mapping NGXgpXƃANVt[̃}bsOBNGXgpX=ANVt[
     */
    public void setMapping(Properties mapping);
    
    /**
     * NGXgpXƃANVt[̃}bsO擾B<p>
     *
     * @return NGXgpXƃANVt[̃}bsO
     */
    public Properties getMapping();
    
    /**
     * NGXgpXƃANVt[̃}bsOɂāANGXgpXɐK\wł悤ɂ邩ǂݒ肷B<p>
     * ftHǵAfalseŐK\gpȂB<br>
     *
     * @param isEnable K\gpꍇ́Atrue
     */
    public void setRegexEnabled(boolean isEnable);
    
    /**
     * NGXgpXƃANVt[̃}bsOɂāANGXgpXɐK\wł邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAK\gp
     */
    public boolean isRegexEnabled();
    
    /**
     * K\rsꍇɎgp}b`tOݒ肷B<p>
     * AA{@link #isRegexEnabled()}truȅꍇ̂ݗLłB<br>
     * ftHǵA0B<br>
     *
     * @param flag }b`tO
     * @see java.util.regex.Pattern#CANON_EQ
     * @see java.util.regex.Pattern#CASE_INSENSITIVE
     * @see java.util.regex.Pattern#DOTALL
     * @see java.util.regex.Pattern#MULTILINE
     * @see java.util.regex.Pattern#UNICODE_CASE
     * @see java.util.regex.Pattern#UNIX_LINES
     */
    public void setRegexMatchFlag(int flag);
    
    /**
     * K\rsꍇɎgp}b`tO擾B<p>
     *
     * @return }b`tO
     */
    public int getRegexMatchFlag();
}
