/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 *
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.websocket.tomcat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;

import org.apache.catalina.websocket.StreamInbound;

/**
 * {@link WebSocketFactory}T[rXB<p>
 *
 * @author M.Ishida
 */
public class DefaultWebSocketFactoryService extends ServiceBase implements WebSocketFactory, DefaultWebSocketFactoryServiceMBean{

    private static final long serialVersionUID = 4414937188526913621L;

    protected Map<String, ServiceName> protocolMapping;
    protected ServiceName defaultWebSocketFactoryServiceName;

    @Override
    public void setProtocolMapping(String protocol, ServiceName name){
        if(protocolMapping == null){
            protocolMapping = new HashMap<String, ServiceName>();
        }
        protocolMapping.put(protocol, name);
    }

    @Override
    public ServiceName getProtocolMapping(String protocol){
        return protocolMapping == null ? null : protocolMapping.get(protocol);
    }

    @Override
    public Map<String, ServiceName> getProtocolMappings(){
        return protocolMapping;
    }

    @Override
    public void setDefaultWebSocketFactoryServiceName(ServiceName name){
        defaultWebSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getDefaultWebSocketFactoryServiceName(){
        return defaultWebSocketFactoryServiceName;
    }

    @Override
    public StreamInbound createWebSocketInbound(HttpServletRequest request, String protocol){
        if(protocolMapping == null || !protocolMapping.containsKey(protocol)){
            if(defaultWebSocketFactoryServiceName != null){
                return ServiceManagerFactory.getServiceObject(defaultWebSocketFactoryServiceName);
            }
            return null;
        }

        return ServiceManagerFactory.getServiceObject(protocolMapping.get(protocol));
    }

    @Override
    public String selectSubProtocol(List<String> subProtocols){
        if(protocolMapping == null){
            return null;
        }
        for(String subProtocol : subProtocols){
            if(protocolMapping.containsKey(subProtocol)){
                return subProtocol;
            }
        }
        return null;
    }

}