/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.websocket;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.beanflow.BeanFlowFactory;
import jp.ossc.nimbus.service.beanflow.BeanFlow;

/**
 * BeanFlowF؃T[rXB<p>
 * F؏{@link BeanFlow}ɈϏėpF؃T[rXłB<br>
 *
 * @author M.Takata
 */
public class BeanFlowAuthenticatorService extends ServiceBase implements Authenticator, BeanFlowAuthenticatorServiceMBean{
    
    private static final long serialVersionUID = 4818367473169729577L;
    
    private ServiceName beanFlowFactoryServiceName;
    private String loginFlowName;
    private String logoutFlowName;
    
    private BeanFlowFactory beanFlowFactory;
    
    @Override
    public void setBeanFlowFactoryServiceName(ServiceName name){
        beanFlowFactoryServiceName = name;
    }
    @Override
    public ServiceName getBeanFlowFactoryServiceName(){
        return beanFlowFactoryServiceName;
    }
    
    @Override
    public void setLoginFlowName(String name){
        loginFlowName = name;
    }
    @Override
    public String getLoginFlowName(){
        return loginFlowName;
    }
    
    @Override
    public void setLogoutFlowName(String name){
        logoutFlowName = name;
    }
    @Override
    public String getLogoutFlowName(){
        return logoutFlowName;
    }
    
    public void setBeanFlowFactory(BeanFlowFactory factory){
        beanFlowFactory = factory;
    }
    
    @Override
    public void startService() throws Exception{
        if(beanFlowFactoryServiceName != null){
            beanFlowFactory = ServiceManagerFactory.getServiceObject(beanFlowFactoryServiceName);
        }
        if(beanFlowFactory == null){
            throw new IllegalArgumentException("BeanFlowFactory is null.");
        }
    }
    
    @Override
    public boolean login(String id, String ticket) throws AuthenticateException{
        if(loginFlowName == null){
            return true;
        }
        try{
            BeanFlow beanFlow = beanFlowFactory.createFlow(loginFlowName);
            Boolean result = (Boolean)beanFlow.execute(new String[]{id, ticket});
            return result.booleanValue();
        }catch(Exception e){
            throw new AuthenticateException(e);
        }
    }
    
    @Override
    public void logout(String id, boolean isForce) throws AuthenticateException{
        if(logoutFlowName == null){
            return;
        }
        try{
            BeanFlow beanFlow = beanFlowFactory.createFlow(logoutFlowName);
            beanFlow.execute(new Object[]{id, isForce ? Boolean.TRUE : Boolean.FALSE});
        }catch(Exception e){
            throw new AuthenticateException(e);
        }
    }
}
