/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.sql.SQLException;
import java.io.IOException;

import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.util.converter.ConvertException;

/**
 * {@link TableCreatorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see TableCreatorService
 */
public interface TableCreatorServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactorỹT[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactorỹT[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rXݒ肷B<p>
     * StreamConvertergāA{@link #setInsertRecords(String)}{@link #setInsertRecordsFilePath(String)}Ŏw肳ꂽ}R[h{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}ɕϊāAe[uINSERTĂB<br>
     * ܂A{@link #setBackupFilePath(String)}Ŏw肳ꂽt@CɃobNAbvۂAlɂ̃t@C畜ۂɂgpB<br>
     *
     * @param name StreamConverter̃T[rX
     */
    public void setRecordListConverterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rX̃T[rX擾B<p>
     *
     * @return StreamConverter̃T[rX
     */
    public ServiceName getRecordListConverterServiceName();
    
    /**
     * ΏۂƂȂe[ȗ݊mFSQLݒ肷B<p>
     * ʂƂāAe[ǔԂSQLɂKvB<br>
     *
     * @param query e[ȗ݊mFSQL
     */
    public void setExistsTableQuery(String query);
    
    /**
     * ΏۂƂȂe[ȗ݊mFSQL擾B<p>
     *
     * @return e[ȗ݊mFSQL
     */
    public String getExistsTableQuery();
    
    /**
     * obNAbvΏۂ̃R[hSQLݒ肷B<p>
     *
     * @param query obNAbvΏۂ̃R[hSQL
     */
    public void setSelectQuery(String query);
    
    /**
     * obNAbvΏۂ̃R[hSQL擾B<p>
     *
     * @return obNAbvΏۂ̃R[hSQL
     */
    public String getSelectQuery();
    
    /**
     * ΏۂƂȂe[u쐬SQLݒ肷B<p>
     *
     * @param query e[u쐬SQL
     */
    public void setCreateTableQuery(String query);
    
    /**
     * ΏۂƂȂe[u쐬SQL擾B<p>
     *
     * @return e[u쐬SQL
     */
    public String getCreateTableQuery();
    
    /**
     * ΏۂƂȂe[u쐬钼OɎsSQLݒ肷B<p>
     *
     * @param queries e[u쐬钼OɎsSQL
     */
    public void setPreCreateTableQueries(String[] queries);
    
    /**
     * ΏۂƂȂe[u쐬钼OɎsSQL擾B<p>
     *
     * @return e[u쐬钼OɎsSQL
     */
    public String[] getPreCreateTableQueries();
    
    /**
     * ΏۂƂȂe[u쐬ɎsSQLݒ肷B<p>
     *
     * @param queries e[u쐬ɎsSQL
     */
    public void setPostCreateTableQueries(String[] queries);
    
    /**
     * ΏۂƂȂe[u쐬ɎsSQL擾B<p>
     *
     * @return e[u쐬ɎsSQL
     */
    public String[] getPostCreateTableQueries();
    
    /**
     * ΏۂƂȂe[u폜SQLݒ肷B<p>
     *
     * @param query e[u폜SQL
     */
    public void setDropTableQuery(String query);
    
    /**
     * ΏۂƂȂe[u폜SQL擾B<p>
     *
     * @return e[u폜SQL
     */
    public String getDropTableQuery();
    
    /**
     * ΏۂƂȂe[u폜钼OɎsSQLݒ肷B<p>
     *
     * @param queries e[u폜钼OɎsSQL
     */
    public void setPreDropTableQueries(String[] queries);
    
    /**
     * ΏۂƂȂe[u폜钼OɎsSQL擾B<p>
     *
     * @return e[u폜钼OɎsSQL
     */
    public String[] getPreDropTableQueries();
    
    /**
     * ΏۂƂȂe[u폜ɎsSQLݒ肷B<p>
     *
     * @param queries e[u폜ɎsSQL
     */
    public void setPostDropTableQueries(String[] queries);
    
    /**
     * ΏۂƂȂe[u폜ɎsSQL擾B<p>
     *
     * @return e[u폜ɎsSQL
     */
    public String[] getPostDropTableQueries();
    
    /**
     * ΏۂƂȂe[ũR[h폜SQLݒ肷B<p>
     *
     * @param query e[ũR[h폜SQL
     */
    public void setDeleteQuery(String query);
    
    /**
     * ΏۂƂȂe[ũR[h폜SQL擾B<p>
     *
     * @return e[ũR[h폜SQL
     */
    public String getDeleteQuery();
    
    /**
     * ΏۂƂȂe[ũR[h}閄ߍSQLݒ肷B<p>
     *
     * @param query e[ũR[h}閄ߍSQL
     */
    public void setInsertQuery(String query);
    
    /**
     * ΏۂƂȂe[ũR[h}閄ߍSQL擾B<p>
     *
     * @return e[ũR[h}閄ߍSQL
     */
    public String getInsertQuery();
    
    /**
     * }郌R[hݒ肷B<p>
     * R[h́AoCgXg[ɕϊA{@link #setRecordListConverterServiceName(ServiceName)}Őݒ肳ꂽ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rXɂāA{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}ɕϊB<br>
     * ϊꂽRecordList{@link jp.ossc.nimbus.beans.dataset.Record Record}A{@link #setInsertQuery(String)}Ŏw肳ꂽߍSQLɂāAe[uɑ}B<br>
     * R[h̎wOt@Cōsꍇ́A{@link #setInsertRecordsFilePath(String)}Őݒ肷B<br>
     *
     * @param records R[h
     */
    public void setInsertRecords(String records);
    
    /**
     * }郌R[h擾B<p>
     *
     * @return R[h
     */
    public String getInsertRecords();
    
    /**
     * }郌R[ht@C̃pXݒ肷B<p>
     * t@ĆAXg[ɕϊA{@link #setRecordListConverterServiceName(ServiceName)}Őݒ肳ꂽ{@link jp.ossc.nimbus.util.converter.StreamConverter StreamConverter}T[rXɂāA{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}ɕϊB<br>
     * ϊꂽRecordList{@link jp.ossc.nimbus.beans.dataset.Record Record}A{@link #setInsertQuery(String)}Ŏw肳ꂽߍSQLɂāAe[uɑ}B<br>
     * R[h̎w𒼐ڍsꍇ́A{@link #setInsertRecords(String)}Őݒ肷B<br>
     *
     * @param path R[ht@CpX
     */
    public void setInsertRecordsFilePath(String path);
    
    /**
     * }郌R[ht@C̃pXݒ肷B<p>
     *
     * @return R[ht@C̃pX
     */
    public String getInsertRecordsFilePath();
    
    /**
     * }郌R[ht@CyуobNAbvt@C̕GR[fBOݒ肷B<p>
     *
     * @param enc GR[fBO
     */
    public void setFileEncoding(String enc);
    
    /**
     * }郌R[ht@CyуobNAbvt@C̕GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getFileEncoding();
    
    /**
     * R[hǂݍ{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}̃XL[}ݒ肷B<p>
     *
     * @param schema XL[}
     */
    public void setRecordListSchema(String schema);
    
    /**
     * R[hǂݍ{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}̃XL[}擾B<p>
     *
     * @return XL[}
     */
    public String getRecordListSchema();
    
    /**
     * R[hǂݍ{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}ݒ肷B<p>
     *
     * @param list RecordList
     */
    public void setRecordList(RecordList list);
    
    /**
     * R[hǂݍ{@link jp.ossc.nimbus.beans.dataset.RecordList RecordList}擾B<p>
     *
     * @return RecordList
     */
    public RecordList getRecordList();
    
    /**
     * e[uɃR[hob`ső}ꍇ̃ob`ݒ肷B<p>
     * ftHǵA0Ńob`sȂB<br>
     *
     * @param size ob`
     */
    public void setInsertBatchSize(int size);
    
    /**
     * e[uɃR[hob`ső}ꍇ̃ob`擾B<p>
     *
     * @return ob`
     */
    public int getInsertBatchSize();
    
    /**
     * e[u烌R[hۂ̃tFb`TCYݒ肷B<p>
     *
     * @param size tFb`TCY
     */
    public void setFetchSize(int size);
    
    /**
     * e[u烌R[hۂ̃tFb`TCY擾B<p>
     *
     * @return tFb`TCY
     */
    public int getFetchSize();
    
    /**
     * T[rX̊JnɁÃ݂e[u̓eobNAbv邩ǂݒ肷B<p>
     * ftHǵAfalseŃobNAbvȂB<br>
     *
     * @param isBackup obNAbvꍇ́Atrue
     */
    public void setBackupOnStart(boolean isBackup);
    
    /**
     * T[rX̊JnɁÃ݂e[u̓eobNAbv邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́AobNAbv
     */
    public boolean isBackupOnStart();
    
    /**
     * T[rX̊JnɁÃ݂e[u̓e𕜌邩ǂݒ肷B<p>
     * ftHǵAfalseŕȂB<br>
     *
     * @param isRestore ꍇ́Atrue
     */
    public void setRestoreOnStart(boolean isRestore);
    
    /**
     * T[rX̊JnɁÃ݂e[u̓e𕜌邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A
     */
    public boolean isRestoreOnStart();
    
    /**
     * T[rX̊JnɁAe[u폜邩ǂݒ肷B<p>
     * ftHǵAfalseō폜ȂB<br>
     *
     * @param isDrop 폜ꍇ́Atrue
     */
    public void setDropTableOnStart(boolean isDrop);
    
    /**
     * T[rX̊JnɁAe[u폜邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A폜
     */
    public boolean isDropTableOnStart();
    
    /**
     * T[rX̊JnɁAe[u쐬邩ǂݒ肷B<p>
     * ftHǵAfalseō쐬ȂB<br>
     *
     * @param isCreate 쐬ꍇ́Atrue
     */
    public void setCreateTableOnStart(boolean isCreate);
    
    /**
     * T[rX̊JnɁAe[u쐬邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A쐬
     */
    public boolean isCreateTableOnStart();
    
    /**
     * T[rX̊JnɁAe[ũR[h폜邩ǂݒ肷B<p>
     * ftHǵAfalseō폜ȂB<br>
     *
     * @param isDelete 폜ꍇ́Atrue
     */
    public void setDeleteOnStart(boolean isDelete);
    
    /**
     * T[rX̊JnɁAe[ũR[h폜邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A폜
     */
    public boolean isDeleteOnStart();
    
    /**
     * T[rX̊JnɁAe[ũR[h}邩ǂݒ肷B<p>
     * ftHǵAfalseő}ȂB<br>
     *
     * @param isInsert }ꍇ́Atrue
     */
    public void setInsertOnStart(boolean isInsert);
    
    /**
     * T[rX̊JnɁAe[ũR[h}邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A}
     */
    public boolean isInsertOnStart();
    
    /**
     * T[rX̒~ɁAe[ũR[h폜邩ǂݒ肷B<p>
     * ftHǵAfalseō폜ȂB<br>
     *
     * @param isDelete 폜ꍇ́Atrue
     */
    public void setDeleteOnStop(boolean isDelete);
    
    /**
     * T[rX̒~ɁAe[ũR[h폜邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A폜
     */
    public boolean isDeleteOnStop();
    
    /**
     * T[rX̒~ɁAe[ũR[h}邩ǂݒ肷B<p>
     * ftHǵAfalseő}ȂB<br>
     *
     * @param isInsert }ꍇ́Atrue
     */
    public void setInsertOnStop(boolean isInsert);
    
    /**
     * T[rX̒~ɁAe[ũR[h}邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A}
     */
    public boolean isInsertOnStop();
    
    /**
     * T[rX̒~ɁAe[u폜邩ǂݒ肷B<p>
     * ftHǵAfalseō폜ȂB<br>
     *
     * @param isDrop 폜ꍇ́Atrue
     */
    public void setDropTableOnStop(boolean isDrop);
    
    /**
     * T[rX̒~ɁAe[u폜邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A폜
     */
    public boolean isDropTableOnStop();
    
    /**
     * T[rX̒~ɁAe[u𕜌邩ǂݒ肷B<p>
     * ftHǵAfalseŕȂB<br>
     *
     * @param isRestore ꍇ́Atrue
     */
    public void setRestoreOnStop(boolean isRestore);
    
    /**
     * T[rX̒~ɁAe[u𕜌邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A
     */
    public boolean isRestoreOnStop();
    
    /**
     * T[rX̒~ɁÃ݂e[uobNAbv邩ǂݒ肷B<p>
     * ftHǵAfalseŃobNAbvȂB<br>
     *
     * @param isBackup obNAbvꍇ́Atrue
     */
    public void setBackupOnStop(boolean isBackup);
    
    /**
     * T[rX̒~ɁÃ݂e[uobNAbv邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́AobNAbv
     */
    public boolean isBackupOnStop();
    
    /**
     * e[u폜ۂɖSQLExceptioñG[R[hݒ肷B<p>
     * ftHgł́ASĂSQLException𖳎ȂB<br>
     *
     * @param code G[R[h̔z
     */
    public void setIgnoreSQLExceptionErrorCodeOnDropTable(int[] code);
    
    /**
     * e[u폜ۂɖSQLExceptioñG[R[h擾B<p>
     *
     * @return G[R[h̔z
     */
    public int[] getIgnoreSQLExceptionErrorCodeOnDropTable();
    
    /**
     * e[ũR[h폜ۂɖSQLExceptioñG[R[hݒ肷B<p>
     * ftHgł́ASĂSQLException𖳎ȂB<br>
     *
     * @param code G[R[h̔z
     */
    public void setIgnoreSQLExceptionErrorCodeOnDelete(int[] code);
    
    /**
     * e[ũR[h폜ۂɖSQLExceptioñG[R[h擾B<p>
     *
     * @return G[R[h̔z
     */
    public int[] getIgnoreSQLExceptionErrorCodeOnDelete();
    
    /**
     * e[u쐬ۂɖSQLExceptioñG[R[hݒ肷B<p>
     * ftHgł́ASĂSQLException𖳎ȂB<br>
     *
     * @param code G[R[h̔z
     */
    public void setIgnoreSQLExceptionErrorCodeOnCreateTable(int[] code);
    
    /**
     * e[u쐬ۂɖSQLExceptioñG[R[h擾B<p>
     *
     * @return G[R[h̔z
     */
    public int[] getIgnoreSQLExceptionErrorCodeOnCreateTable();
    
    /**
     * e[ũR[h}ۂɖSQLExceptioñG[R[hݒ肷B<p>
     * ftHgł́ASĂSQLException𖳎ȂB<br>
     *
     * @param code G[R[h̔z
     */
    public void setIgnoreSQLExceptionErrorCodeOnInsert(int[] code);
    
    /**
     * e[ũR[h}ۂɖSQLExceptioñG[R[h擾B<p>
     *
     * @return G[R[h̔z
     */
    public int[] getIgnoreSQLExceptionErrorCodeOnInsert();
    
    /**
     * Ãe[ugUNVIɎs邩ǂݒ肷B<p>
     * Ãe[uƂ́AT[rX̊Jnyђ~̃e[uA{@link #executeAllQuery()}ĂяȏłB<br>
     *
     * @param isTransacted gUNVIɎsꍇtrue
     */
    public void setTransacted(boolean isTransacted);
    
    /**
     * Ãe[ugUNVIɎs邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAgUNVIɎs
     */
    public boolean isTransacted();
    
    /**
     * Javǎ^ɑ΂AJDBČ^ݒ肷B<p>
     * e[uɃR[h}鎞ɁAlnull̏ꍇɁÃ}bsOpāA{@link java.sql.PreparedStatement#setNull(int, int)}ĂяoB<br>
     *
     * @param type Javǎ^
     * @param sqlType JDBČ^B{@link java.sql.Types}̒萔l
     */
    public void setSqlType(Class<?> type, int sqlType);
    
    /**
     * obNAbvt@C̃pXݒ肷B<p>
     * ̃pXw肵Ȃꍇ́AɃobNAbvB<br>
     * ߖ񂵂ꍇAobNAbviꍇȂǂɎw肷B<br>
     *
     * @param path obNAbvt@C̃pX
     */
    public void setBackupFilePath(String path);
    
    /**
     * obNAbvt@C̃pX擾B<p>
     *
     * @return obNAbvt@C̃pX
     */
    public String getBackupFilePath();
    
    /**
     * e[u폜B<p>
     * {@link #setDropTableQuery(String)}ݒ肳ĂȂꍇ́AȂB<br>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     */
    public void dropTable() throws ConnectionFactoryException, SQLException;
    
    /**
     * e[ũR[h폜B<p>
     * {@link #setDeleteQuery(String)}ݒ肳ĂȂꍇ́AȂB<br>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     */
    public void deleteRecords() throws ConnectionFactoryException, SQLException;
    
    /**
     * e[u쐬B<p>
     * {@link #setCreateTableQuery(String)}ݒ肳ĂȂꍇ́AȂB<br>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     */
    public void createTable() throws ConnectionFactoryException, SQLException;
    
    /**
     * e[ũR[h}B<p>
     * {@link #setInsertQuery(String)}ƁA{@link #setInsertRecords(String)}܂{@link #setInsertRecordsFilePath(String)}ݒ肳ĂȂꍇ́AȂB<br>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     * @exception ConvertException R[h̕ϊɎsꍇ
     * @exception IOException R[ht@C݂ȂꍇAǂݍ݂Ɏsꍇ
     */
    public void insertRecords()
     throws ConnectionFactoryException, SQLException,
            ConvertException, IOException;
    
    /**
     * e[ũR[hobNAbvB<p>
     * {@link #setSelectQuery(String)}ƁA{@link #setRecordListSchema(String)}܂{@link #setRecordList(jp.ossc.nimbus.beans.dataset.RecordList)}ݒ肳ĂȂꍇ́AȂB<br>
     * ʏAobNAbv́Aɍs邪A{@link #setBackupFilePath(String)}ݒ肵Ăꍇ́At@CɃobNAbvB<br>
     * obNAbvR[h́A{@link #restoreRecords()}ŕ鎖łB<br>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     * @exception ConvertException R[h̕ϊɎsꍇ
     * @exception IOException obNAbvt@C̃pX݂ȂꍇA݂Ɏsꍇ
     */
    public void backupRecords()
     throws ConnectionFactoryException, SQLException,
            IOException, ConvertException;
    
    /**
     * e[ũR[h𕜌B<p>
     * {@link #setInsertQuery(String)}ƁA{@link #setInsertRecords(String)}܂{@link #setInsertRecordsFilePath(String)}ݒ肳ĂȂꍇ́AȂB<br>
     * ʏÁAs邪A{@link #setBackupFilePath(String)}ݒ肵Ăꍇ́At@C畜B<br>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     * @exception ConvertException R[h̕ϊɎsꍇ
     * @exception IOException obNAbvt@C݂ȂꍇAǂݍ݂Ɏsꍇ
     */
    public void restoreRecords()
     throws ConnectionFactoryException, SQLException,
            IOException, ConvertException;
    
    /**
     * e[u̍폜AR[h̍폜Ae[u̍쐬AR[h̑}sB<p>
     *
     * @exception ConnectionFactoryException JDBCRlNV̎擾Ɏsꍇ
     * @exception SQLException SQL̎sɎsꍇ
     * @exception ConvertException R[h̕ϊɎsꍇ
     * @exception IOException t@C݂ȂꍇAǂݍ݂Ɏsꍇ
     */
    public void executeAllQuery()
     throws ConnectionFactoryException, SQLException,
            ConvertException, IOException;
}
