/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 *
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish.websocket.jetty;

import java.util.Set;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link DataSetWebSocketService}MBeanC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface DataSetWebSocketServiceMBean extends ServiceBaseMBean{
    
    /**
     * M[hFB<p>
     */
    public static final int SEND_MODE_STRING = 1;
    
    /**
     * M[hFoCiB<p>
     */
    public static final int SEND_MODE_BINARY = 2;
    
    /**
     * Mf[^Zbg̔zMwb_̃wb_̃ftHglB<p>
     */
    public static final String PUBLISH_HEADER_DEFAULT_NAME = "Common";
    
    /**
     * Oo̓bZ[WIDFNGXgϊG[B<p>
     */
    public static final String MSG_ID_REQUEST_CONVERT_ERROR        = "DSWS_00001";
    
    /**
     * Oo̓bZ[WIDFm̃NGXgMG[B<p>
     */
    public static final String MSG_ID_UNKNOWN_REQUEST_OBJECT_ERROR = "DSWS_00002";
    
    /**
     * Oo̓bZ[WIDFNGXgG[B<p>
     */
    public static final String MSG_ID_REQUEST_PROCESS_ERROR        = "DSWS_00003";
    
    /**
     * Oo̓bZ[WIDFMbZ[WϊG[B<p>
     */
    public static final String MSG_ID_SEND_MESSAGE_CONVERT_ERROR   = "DSWS_00004";
    
    /**
     * Oo̓bZ[WIDFbZ[WMG[B<p>
     */
    public static final String MSG_ID_SEND_MESSAGE_ERROR           = "DSWS_00005";
    
    /**
     * Oo̓bZ[WIDFPONGMG[B<p>
     */
    public static final String MSG_ID_SEND_PONG_ERROR              = "DSWS_00006";
    
    /**
     * Oo̓bZ[WIDFF؃G[B<p>
     */
    public static final String MSG_ID_NO_AUTHENTICATED_ERROR       = "DSWS_00007";
    
    /**
     * Oo̓bZ[WIDFOAEgG[B<p>
     */
    public static final String MSG_ID_LOGOUT_ERROR                 = "DSWS_00008";
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX烊NGXgID擾ꍇ́ANGXgID̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_REQUEST_ID_KEY
         = jp.ossc.nimbus.service.aop.interceptor.ThreadContextKey.REQUEST_ID;
    
    /**
     * NGXgW[ĩ[gXebṽL[̃ftHglB<p>
     */
    public static final String DEFAULT_REQUEST_JOURNAL_KEY = "Request";
    
    /**
     * NGXgW[ĩNGXgbZ[W̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_REQUEST_MESSAGE_JOURNAL_KEY = "Message";
    
    /**
     * NGXgW[ĩNGXgDataSet̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_REQUEST_DATASET_JOURNAL_KEY = "DataSet";
    
    /**
     * W[iID̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_ID_JOURNAL_KEY = "Id";
    
    /**
     * W[i̗ÕL[̃ftHglB<p>
     */
    public static final String DEFAULT_EXCEPTION_JOURNAL_KEY = "Exception";
    
    /**
     * MW[ĩ[gXebṽL[̃ftHglB<p>
     */
    public static final String DEFAULT_SEND_JOURNAL_KEY = "Send";
    
    /**
     * MW[ȋMbZ[W̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_SEND_MESSAGE_JOURNAL_KEY = "Message";
    
    /**
     * MW[ȋMDataSet̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_SEND_DATASET_JOURNAL_KEY = "DataSet";
    
    /**
     * MW[ȋMoCg̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_SEND_BYTES_JOURNAL_KEY = "Bytes";
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageReceiver MessageReceiver}T[rX̃T[rXݒ肷B<p>
     *
     * @param name MessageReceiverT[rX̃T[rX
     */
    public void setMessageReceiverServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageReceiver MessageReceiver}T[rX̃T[rX擾B<p>
     *
     * @return MessageReceiverT[rX̃T[rX
     */
    public ServiceName getMessageReceiverServiceName();
    
    /**
     * WebSocketŃNGXgꂽf[^{@link jp.ossc.nimbus.beans.dataset.DataSet DataSet}ɕϊ{@link jp.ossc.nimbus.util.converter.BindingStreamConverter BindingStreamConverter}T[rX̃T[rXݒ肷B<p>
     *
     * @param name BindingStreamConverterT[rX̃T[rX
     */
    public void setRequestDataSetConverterServiceName(ServiceName name);
    
    /**
     * WebSocketŃNGXgꂽf[^{@link jp.ossc.nimbus.beans.dataset.DataSet DataSet}ɕϊ{@link jp.ossc.nimbus.util.converter.BindingStreamConverter BindingStreamConverter}T[rX̃T[rX擾B<p>
     *
     * @return BindingStreamConverterT[rX̃T[rX
     */
    public ServiceName getRequestDataSetConverterServiceName();
    
    /**
     * WebSocketőM{@link jp.ossc.nimbus.beans.dataset.DataSet DataSet}AXg[ɕϊ{@link jp.ossc.nimbus.util.converter.BindingStreamConverter StreamConverter}T[rX̃T[rXݒ肷B<p>
     *
     * @param name StreamConverterT[rX̃T[rX
     */
    public void setSendDataSetConverterServiceName(ServiceName name);
    
    /**
     * WebSocketőM{@link jp.ossc.nimbus.beans.dataset.DataSet DataSet}AXg[ɕϊ{@link jp.ossc.nimbus.util.converter.BindingStreamConverter StreamConverter}T[rX̃T[rX擾B<p>
     *
     * @return StreamConverterT[rX̃T[rX
     */
    public ServiceName getSendDataSetConverterServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.websocket.jetty.PingSender PingSender}T[rX̃T[rXݒ肷B<p>
     *
     * @param name PingSenderT[rX̃T[rX
     */
    public void setPingSenderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.websocket.jetty.PingSender PingSender}T[rX̃T[rX擾B<p>
     *
     * @return PingSenderT[rX̃T[rX
     */
    public ServiceName getPingSenderServiceName();
    
    /**
     * WebSocketւ̃NGXgW[iO{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JournalT[rX̃T[rX
     */
    public void setRequestJournalServiceName(ServiceName name);
    
    /**
     * WebSocketւ̃NGXgW[iO{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B<p>
     *
     * @return JournalT[rX̃T[rX
     */
    public ServiceName getRequestJournalServiceName();
    
    /**
     * WebSocketւ̃NGXgW[iOۂ{@link jp.ossc.nimbus.service.journal.EditorFinder EditorFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX̃T[rX
     */
    public void setRequestEditorFinderServiceName(ServiceName name);
    
    /**
     * WebSocketւ̃NGXgW[iOۂ{@link jp.ossc.nimbus.service.journal.EditorFinder EditorFinder}T[rX̃T[rX擾B<p>
     *
     * @return EditorFinderT[rX̃T[rX
     */
    public ServiceName getRequestEditorFinderServiceName();
    
    /**
     * WebSocketւ̃NGXgW[iO鎞ɁANGXgʔԂ{@link jp.ossc.nimbus.service.context.Context Context}T[rX擾܂͐ݒ肷ۂ̃ReLXgL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_REQUEST_ID_KEY}B<br>
     *
     * @param key NGXgʔԂ̃ReLXgL[
     */
    public void setRequestIDKey(String key);
    
    /**
     * WebSocketւ̃NGXgW[iO鎞ɁANGXgʔԂ{@link jp.ossc.nimbus.service.context.Context Context}T[rX擾܂͐ݒ肷ۂ̃ReLXgL[擾B<p>
     *
     * @return NGXgʔԂ̃ReLXgL[
     */
    public String getRequestIDKey();
    
    /**
     * WebSocketւ̃NGXgW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_REQUEST_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setRequestJournalKey(String key);
    
    /**
     * WebSocketւ̃NGXgW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getRequestJournalKey();
    
    /**
     * WebSocketւ̃NGXg̃bZ[WW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_REQUEST_MESSAGE_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setRequestMessageJournalKey(String key);
    
    /**
     * WebSocketւ̃NGXg̃bZ[WW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getRequestMessageJournalKey();
    
    /**
     * WebSocketւ̃NGXgDataSetW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_REQUEST_DATASET_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setRequestDataSetJournalKey(String key);
    
    /**
     * WebSocketւ̃NGXgDataSetW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getRequestDataSetJournalKey();
    
    /**
     * WebSocketւ̃NGXg̃NCAgIDW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_ID_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setIdJournalKey(String key);
    
    /**
     * WebSocketւ̃NGXg̃NCAgIDW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getIdJournalKey();
    
    /**
     * WebSocketւ̃NGXgyёM̗OW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_EXCEPTION_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setExceptionJournalKey(String key);
    
    /**
     * WebSocketւ̃NGXgyёM̗OW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getExceptionJournalKey();
    
    /**
     * WebSocketւ̑MW[iO{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JournalT[rX̃T[rX
     */
    public void setSendJournalServiceName(ServiceName name);
    
    /**
     * WebSocketւ̑MW[iO{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B<p>
     *
     * @return JournalT[rX̃T[rX
     */
    public ServiceName getSendJournalServiceName();
    
    /**
     * WebSocketւ̑MW[iOۂ{@link jp.ossc.nimbus.service.journal.EditorFinder EditorFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX̃T[rX
     */
    public void setSendEditorFinderServiceName(ServiceName name);
    
    /**
     * WebSocketւ̑MW[iOۂ{@link jp.ossc.nimbus.service.journal.EditorFinder EditorFinder}T[rX̃T[rX擾B<p>
     *
     * @return EditorFinderT[rX̃T[rX
     */
    public ServiceName getSendEditorFinderServiceName();
    
    /**
     * WebSocketւ̑MW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SEND_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setSendJournalKey(String key);
    
    /**
     * WebSocketւ̑MW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getSendJournalKey();
    
    /**
     * WebSocketւ̑MbZ[WW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SEND_MESSAGE_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setSendMessageJournalKey(String key);
    
    /**
     * WebSocketւ̑MbZ[WW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getSendMessageJournalKey();
    
    /**
     * WebSocketւ̑MDataSetW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SEND_DATASET_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setSendDataSetJournalKey(String key);
    
    /**
     * WebSocketւ̑MDataSetW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getSendDataSetJournalKey();
    
    /**
     * WebSocketւ̑MoCgW[iOۂ̃W[iL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SEND_BYTES_JOURNAL_KEY}B<br>
     *
     * @param key W[iL[
     */
    public void setSendBytesJournalKey(String key);
    
    /**
     * WebSocketւ̑MoCgW[iOۂ̃W[iL[擾B<p>
     *
     * @return W[iL[
     */
    public String getSendBytesJournalKey();
    
    /**
     * WebSocketւ̃NGXgW[iOۂɃNGXgʔԂ𔭍s{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SequenceT[rX̃T[rX
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * WebSocketւ̃NGXgW[iOۂɃNGXgʔԂ𔭍s{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rX擾B<p>
     *
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * WebSocketւ̃NGXgW[iOۂɃNGXgʔԂ擾܂͐ݒ肷{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * WebSocketւ̃NGXgW[iOۂɃNGXgʔԂ擾܂͐ݒ肷{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * WebSocketőMf[^̕GR[fBOݒ肷B<p>
     * ftHǵAUTF-8B<br>
     *
     * @param encoding GR[fBO
     */
    public void setCharacterEncoding(String encoding);
    
    /**
     * WebSocketőMf[^̕GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getCharacterEncoding();
    
    /**
     * WebSocketւ̔F؃NGXg{@link jp.ossc.nimbus.service.websocket.Authenticator Authenticator}T[rX̃T[rXݒ肷B<p>
     *
     * @param name AuthenticatorT[rX̃T[rX
     */
    public void setAuthenticatorServiceName(ServiceName name);
    
    /**
     * WebSocketւ̔F؃NGXg{@link jp.ossc.nimbus.service.websocket.Authenticator Authenticator}T[rX̃T[rX擾B<p>
     *
     * @return AuthenticatorT[rX̃T[rX
     */
    public ServiceName getAuthenticatorServiceName();
    
    /**
     * WebSocketւ̑M[hݒ肷B<p>
     * ftHǵA{@link #SEND_MODE_STRING}B<br>
     *
     * @param mode M[h
     * @see #SEND_MODE_STRING
     * @see #SEND_MODE_BINARY
     */
    public void setSendMode(int mode) throws IllegalArgumentException;
    
    /**
     * WebSocketւ̑M[h擾B<p>
     *
     * @return M[h
     */
    public int getSendMode();
    
    /**
     * WebSocketւ̑MDataSetɔzMwb_t^邩ǂݒ肷B<p>
     * ftHǵAtrueŁAt^B<br>
     *
     * @param isAppend t^ꍇ́Atrue
     */
    public void setAppendPublishHeader(boolean isAppend);
    
    /**
     * WebSocketւ̑MDataSetɔzMwb_t^邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAt^
     */
    public boolean isAppendPublishHeader();
    
    /**
     * WebSocketւ̑MDataSetɕt^zMwb_̃wb_ݒ肷B<p>
     * ftHǵA{@link #PUBLISH_HEADER_DEFAULT_NAME}B<br>
     *
     * @param name zMwb_̃wb_
     */
    public void setPublishHeaderName(String name);
    
    /**
     * WebSocketւ̑MDataSetɕt^zMwb_̃wb_擾B<p>
     *
     * @return zMwb_̃wb_
     */
    public String getPublishHeaderName();
    
    /**
     * TuWFNg𕡐{@link jp.ossc.nimbus.service.publish.Message Message}𑗐MꍇɁATuWFNgɑM邩ǂݒ肷B<p>
     * ftHǵAtrueŁATuWFNgɑMB<br>
     *
     * @param isSend TuWFNgɑMꍇ́Atrue
     */
    public void setSendBySubject(boolean isSend);
    
    /**
     * TuWFNg𕡐{@link jp.ossc.nimbus.service.publish.Message Message}𑗐MꍇɁATuWFNgɑM邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇATuWFNgɑM
     */
    public boolean isSendBySubject();
    
    /**
     * o^ĂTuWFNg擾B<p>
     *
     * @return o^ĂTuWFNg
     */
    public Set<String> getSubjects();
    
    /**
     * WebSocketւ̃oCiNGXg̍őTCYݒ肷B<p>
     * ftHǵA0Ŏw肵ȂB<br>
     *
     * @param size őTCY
     */
    public void setMaxBinaryMessageSize(int size);
    
    /**
     * WebSocketւ̃oCiNGXg̍őTCY擾B<p>
     *
     * @return őTCY
     */
    public int getMaxBinaryMessageSize();
    
    /**
     * WebSocketւ̕񃊃NGXg̍őTCYݒ肷B<p>
     * ftHǵA0Ŏw肵ȂB<br>
     *
     * @param size őTCY
     */
    public void setMaxTextMessageSize(int size);
    
    /**
     * WebSocketւ̕񃊃NGXg̍őTCY擾B<p>
     *
     * @return őTCY
     */
    public int getMaxTextMessageSize();
    
    /**
     * WebSocket̖ʐMԂ̋e[ms]ݒ肷B<p>
     * ftHǵA0Ŏw肵ȂB<br>
     *
     * @param ms ʐMԂ̋e[ms]
     */
    public void setMaxIdleTime(int ms);
    
    /**
     * WebSocket̖ʐMԂ̋e[ms]擾B<p>
     *
     * @return ʐMԂ̋e[ms]
     */
    public int getMaxIdleTime();
    
    /**
     * WebSocketւ̃NGXg̕ϊɎsꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_REQUEST_CONVERT_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setRequestConvertErrorMessageId(String id);
    
    /**
     * WebSocketւ̃NGXg̕ϊɎsꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getRequestConvertErrorMessageId();
    
    /**
     * WebSocketւ̃NGXgm̃NGXgꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_UNKNOWN_REQUEST_OBJECT_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setUnknownRequestObjectErrorMessageId(String id);
    
    /**
     * WebSocketւ̃NGXgm̃NGXgꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getUnknownRequestObjectErrorMessageId();
    
    /**
     * WebSocketւ̃NGXgF؂ōsꂽꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_NO_AUTHENTICATED_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setNoAuthenticatedErrorMessageId(String id);
    
    /**
     * WebSocketւ̃NGXgF؂ōsꂽꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getNoAuthenticatedErrorMessageId();
    
    /**
     * WebSocketւ̃NGXgŃG[ꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_REQUEST_PROCESS_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setRequestProcessErrorMessageId(String id);
    
    /**
     * WebSocketւ̃NGXgŃG[ꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getRequestProcessErrorMessageId();
    
    /**
     * WebSocketւ̑MbZ[W̕ϊɎsꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_SEND_MESSAGE_CONVERT_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setSendMessageConvertErrorMessageId(String id);
    
    /**
     * WebSocketւ̑MbZ[W̕ϊɎsꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getSendMessageConvertErrorMessageId();
    
    /**
     * WebSocketւ̑MɎsꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_SEND_MESSAGE_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setSendMessageErrorMessageId(String id);
    
    /**
     * WebSocketւ̑MɎsꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getSendMessageErrorMessageId();
    
    /**
     * WebSocketւPONG̑MɎsꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_SEND_PONG_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setSendPongErrorMessageId(String id);
    
    /**
     * WebSocketւPONG̑MɎsꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getSendPongErrorMessageId();
    
    /**
     * OAEgɎsꍇ́AObZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_LOGOUT_ERROR}B<br>
     *
     * @param id ObZ[WID
     */
    public void setLogoutErrorMessageId(String id);
    
    /**
     * OAEgɎsꍇ́AObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public String getLogoutErrorMessageId();
    
    /**
     * WebSocketւ̃NGXg̕ϊɎsꍇ́AWebSocketIR[hݒ肷B<p>
     * ftHǵA1003B<br>
     *
     * @param code WebSocketIR[h
     */
    public void setCloseCodeForRequestConvertError(int code);
    
    /**
     * WebSocketւ̃NGXg̕ϊɎsꍇ́AWebSocketIR[h擾B<p>
     *
     * @return WebSocketIR[h
     */
    public int getCloseCodeForRequestConvertError();
    
    /**
     * WebSocketւ̃NGXgF؂ōsꂽꍇ́AWebSocketIR[hݒ肷B<p>
     * ftHǵA1008B<br>
     *
     * @param code WebSocketIR[h
     */
    public void setCloseCodeForNoAuthenticatedError(int code);
    
    /**
     * WebSocketւ̃NGXgF؂ōsꂽꍇ́AWebSocketIR[h擾B<p>
     *
     * @return WebSocketIR[h
     */
    public int getCloseCodeForNoAuthenticatedError();
    
    /**
     * WebSocketւ̃NGXgm̃NGXgꍇ́AWebSocketIR[hݒ肷B<p>
     * ftHǵA1011B<br>
     *
     * @param code WebSocketIR[h
     */
    public void setCloseCodeForUnknownRequestObjectError(int code);
    
    /**
     * WebSocketւ̃NGXgm̃NGXgꍇ́AWebSocketIR[h擾B<p>
     *
     * @return WebSocketIR[h
     */
    public int getCloseCodeForUnknownRequestObjectError();
    
    /**
     * WebSocketւ̃NGXgŃG[ꍇ́AWebSocketIR[hݒ肷B<p>
     * ftHǵA1011B<br>
     *
     * @param code WebSocketIR[h
     */
    public void setCloseCodeForRequestProcessError(int code);
    
    /**
     * WebSocketւ̃NGXgŃG[ꍇ́AWebSocketIR[h擾B<p>
     *
     * @return WebSocketIR[h
     */
    public int getCloseCodeForRequestProcessError();
    
    /**
     * WebSocketւ̑MɎsꍇ́AWebSocketIR[hݒ肷B<p>
     * ftHǵA1001B<br>
     *
     * @param code WebSocketIR[h
     */
    public void setCloseCodeForSendMessageError(int code);
    
    /**
     * WebSocketւ̑MɎsꍇ́AWebSocketIR[h擾B<p>
     *
     * @return WebSocketIR[h
     */
    public int getCloseCodeForSendMessageError();
    
    /**
     * WebSocketɐڑĂNCAgID擾B<p>
     *
     * @return NCAgID
     */
    public String getId();
    
    /**
     * WebSocket̃TuvgR擾B<p>
     *
     * @return TuvgR
     */
    public String getProtocol();
    
    /**
     * WebSocketւ̃NGXg񐔂擾B<p>
     *
     * @return NGXg
     */
    public long getReceiveRequestCount();
    
    /**
     * WebSocketւ̃bZ[WM񐔂擾B<p>
     *
     * @return bZ[WM
     */
    public long getReceiveMessageCount();
    
    /**
     * WebSocket̃bZ[WM񐔂擾B<p>
     *
     * @return bZ[WM
     */
    public long getSendMessageCount();
    
    /**
     * JE^ZbgB<p>
     */
    public void resetCount();
}