/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import java.util.Set;

/**
 * bZ[WC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface Message{
    
    /**
     * TuWFNg擾B<br>
     *
     * @return TuWFNg
     */
    public String getSubject();
    
    /**
     * TuWFNgW擾B<br>
     *
     * @return TuWFNgW
     */
    public Set<String> getSubjects();
    
    /**
     * TuWFNgݒ肷B<br>
     *
     * @param sbj TuWFNg
     * @param key L[
     */
    public void setSubject(String sbj, String key);
    
    /**
     * L[擾B<br>
     *
     * @return L[
     */
    public String getKey();
    
    /**
     * L[擾B<br>
     *
     * @param sbj TuWFNg
     * @return L[
     */
    public String getKey(String sbj);
    
    /**
     * bZ[W̃f[^ݒ肷B<br>
     *
     * @param obj bZ[W̃f[^IuWFNg
     * @exception MessageException f[^IuWFNg̐ݒɎsꍇ
     */
    public void setObject(Object obj) throws MessageException;
    
    /**
     * bZ[W̃f[^擾B<br>
     *
     * @return f[^IuWFNg
     * @exception MessageException f[^IuWFNg̎擾Ɏsꍇ
     */
    public Object getObject() throws MessageException;
    
    /**
     * M擾B<p>
     *
     * @return M
     */
    public long getReceiveTime();
    
    /**
     * MID̏W擾B<br>
     *
     * @return MID̏W
     */
    public Set<Object> getDestinationIds();
    
    /**
     * MID̏Wݒ肷B<br>
     *
     * @param ids MID̏W
     */
    public void setDestinationIds(Set<Object> ids);
    
    /**
     * MIDǉB<br>
     *
     * @param id MID
     */
    public void addDestinationId(Object id);
    
    /**
     * MID폜B<br>
     *
     * @param id MID
     */
    public void removeDestinationId(Object id);
    
    /**
     * MIDNAB<br>
     */
    public void clearDestinationIds();
    
    /**
     * w肵IDMIDɊ܂܂Ă邩肷B<br>
     *
     * @param id ID
     * @return MIDɊ܂܂ꍇtrue
     */
    public boolean containsDestinationId(Object id);
}