/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal;

import java.util.*;

/**
 * W[iC^tF[XB<p>
 * ȉ̂悤ȃW[i擾B<br>
 * <ul>
 *   <li>ANZXJn</li>
 *   <li>ANZXI</li>
 *   <li>ANZX</li>
 *   <li>ANZXʎq</li>
 *   <li>ANZXɂo͏</li>
 * </ul>
 * <p>
 * ܂AKw̃VXeŊeKwł̃W[io͂AÃW[iƂďo͂鎖邽߂ɁAW[i̓q\T|[gB<br>
 * P1Kw̃W[i擾́Aȉ̂悤ɍsB<br>
 * <pre>
 *   :
 * Journal journal = (Journal)ServiceManagerFactory.getServiceObject("Journal");
 * try{
 *     journal.startJournal("Request");
 *       :
 *     journal.addInfo("Input", input);
 *       :
 *     Fuga output = hoge.getFuga(input);
 *       :
 *     journal.addInfo("Output", output);
 *       :
 * }finally{
 *     journal.endJournal();
 * }
 * </pre>
 * ̃R[hɂ擾W[íA"Request"ƂW[i̒"Input""Output"܂܂Ƃ\ɂȂB<br>
 * ܂ALhoge.getFuga()\bh̐̉ʂ̊KwŁAȉ̂悤ȓl̃R[hꍇA<br>
 * <pre>
 *   :
 * Journal journal = (Journal)ServiceManagerFactory.getServiceObject("Journal");
 * try{
 *     journal.startJournal("Request2");
 *       :
 *     journal.addInfo("Input2", input);
 *       :
 *     journal.addInfo("Output2", output);
 *       :
 * }finally{
 *     journal.endJournal();
 * }
 * </pre>
 * 2Kw̃R[hɂ擾W[íA"Request"ƂW[i̒"Input""Request2""Output"܂܂AX"Request2"ɂ́A"Input2""Output2"܂܂Ƃq\ɂȂB<br>
 *
 * @author M.Takata
 */
public interface Journal{
    
    /**
     * W[iɏo͂郊NGXgIDݒ肷B<p>
     * 
     * @param requestID W[iɏo͂郊NGXgID
     */
    public void setRequestId(String requestID);
    
    /**
     * W[i̎擾JnB<p>
     * {@link #startJournal(String, Date, EditorFinder) startJournal(key, null, null)}ŌĂяôƓłB<br>
     * 
     * @param key 擾W[ĩL[
     * @see #startJournal(String, Date, EditorFinder)
     */
    public void startJournal(String key);
    
    /**
     * W[i̎擾JnB<p>
     * {@link #startJournal(String, Date, EditorFinder) startJournal(key, null, finder)}ŌĂяôƓłB<br>
     * 
     * @param key 擾W[ĩL[
     * @param finder W[iҏW{@link JournalEditor}{@link EditorFinder}
     * @see #startJournal(String, Date, EditorFinder)
     */
    public void startJournal(String key, EditorFinder finder);
    
    /**
     * W[i̎擾JnB<p>
     * {@link #startJournal(String, Date, EditorFinder) startJournal(key, startTime, null)}ŌĂяôƓłB<br>
     * 
     * @param key 擾W[ĩL[
     * @param startTime W[i擾Jn
     * @see #startJournal(String, Date, EditorFinder)
     */
    public void startJournal(String key, Date startTime);
    
    /**
     * W[i̎擾JnB<p>
     * W[ĩ[gXebv쐬B<br>
     * Ƀ[gXebv쐬Ăꍇ́A̎qXebv쐬B<br>
     * 쐬ꂽXebvɒǉꂽW[iqXebv́AꂼœɎw肪Ȃ΁AŎw肳ꂽ{@link EditorFinder}{@link JournalEditor}AҏWB<br>
     * EditorFinderw肳ĂȂꍇ́AeXebvJnɎw肳ꂽEditorFinderKpBɃ[gXebv̏ꍇ́Aw肪Ȃ΁AJournalT[rX̃ftHgEditorFinderKpB<br>
     * 
     * @param key 擾W[ĩL[
     * @param startTime W[i擾Jn
     * @param finder W[iҏW{@link JournalEditor}{@link EditorFinder}
     */
    public void startJournal(
        String key,
        Date startTime,
        EditorFinder finder
    );
    
    /**
     * W[i̎擾IB<p>
     * {@link #endJournal(Date) endJournal(null)}ŌĂяôƓłB<br>
     *
     * @see #endJournal(Date)
     */
    public void endJournal();
    
    /**
     * W[i̎擾IB<p>
     * Jg̃XebvIB<br>
     * ܂AJg̃Xebv[gXebv̏ꍇɂ́AW[io͂sAXebvNAB<br>
     * 
     * @param endTime W[i擾I
     */
    public void endJournal(Date endTime);
    
    /**
     * Jg̃XebvɃW[iǉB<p>
     * Jg̃XebvJnɎw肳ꂽEditorFinderKpB<br>
     * 
     * @param key XebvɒǉW[ĩL[
     * @param value ǉW[i
     */
    public void addInfo(
        String key,
        Object value
    );
}
