/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jndi;

import java.util.*;
import javax.naming.NamingException;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultJndiFinderService}MBeanC^tF[X<p>
 * 
 * @author Y.Tokuda
 * @see DefaultJndiFinderService
 */
public interface DefaultJndiFinderServiceMBean extends ServiceBaseMBean{
    
    /**
     * JNDIT[o`FbNŁAJNDIT[o񂾎ɏo͂郍ÕbZ[WIDB<p>
     */
    public static final String JNDI_SERVER_DEAD_MSG_ID = "DJF__00001";
    
    /**
     * JNDIT[o`FbNŁAJNDIT[oAɏo͂郍ÕbZ[WIDB<p>
     */
    public static final String JNDI_SERVER_RECOVER_MSG_ID = "DJF__00002";
    
    /**
     * gC̑ΏۂƂÕftHglB<p>
     * <ul>
     *     <li>javax.naming.CommunicationException</li>
     *     <li>javax.naming.InsufficientResourcesException</li>
     *     <li>javax.naming.InterruptedNamingException</li>
     *     <li>javax.naming.TimeLimitExceededException</li>
     *     <li>javax.naming.ServiceUnavailableException</li>
     * </ul>
     */
    @SuppressWarnings("unchecked")
    public static final Class<Throwable>[] DEFAULT_RETRY_EXCXEPTION = new Class[]{
        javax.naming.CommunicationException.class,
        javax.naming.InsufficientResourcesException.class,
        javax.naming.InterruptedNamingException.class,
        javax.naming.TimeLimitExceededException.class,
        javax.naming.ServiceUnavailableException.class
    };
    
    /**
     * InitialContext̏ɎgpJNDIϐݒ肷B<p>
     * 
     * @param prop JNDIϐi[vpeB
     */
    public void setEnvironment(Properties prop);
    
    /**
     * InitialContext̏ɎgpJNDIϐ擾B<p>
     * 
     * @return JNDIϐi[vpeB
     * @exception NamingException JNDIϐ擾łȂꍇ
     */
    public Properties getEnvironment() throws NamingException;
    
    /**
     * lookupɎgpJNDIvtBbNXݒ肷B<p>
     * ftHǵA󕶎B<br>
     *
     * @param prefix JNDIvtBbNX
     */
    public void setPrefix(String prefix);
    
    /**
     * lookupɎgpJNDIvtBbNX擾B<p>
     *
     * @return JNDIvtBbNX
     */
    public String getPrefix();
    
    /**
     * lookup[gIuWFNgLbVLbVT[rXݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́A[gIuWFNgLbVȂB<br>
     *
     * @param name LbVT[rX
     */
    public void setCacheMapServiceName(ServiceName name);
    
    /**
     * lookup[gIuWFNgLbVLbVT[rX擾B<p>
     *
     * @return LbVT[rX
     */
    public ServiceName getCacheMapServiceName();
    
    /** 
     * lookupɃgCOꍇɃgC񐔂ݒ肷B<p>
     * ftHǵA0ŃgCȂB<br>
     *
     * @param num gC
     * @see #setRetryExceptionClassNames(String[])
     */
    public void setRetryCount(int num);
    
    /** 
     * lookupɃgCOꍇɃgC񐔂擾B<p>
     *
     * @return gC
     */
    public int getRetryCount();
    
    /** 
     * lookupɃgCOꍇɃgCԊu[msec]ݒ肷B<p>
     * ftHǵA1000B<br>
     *
     * @param interval gCԊu
     * @see #setRetryExceptionClassNames(String[])
     */
    public void setRetryInterval(long interval);
    
    /** 
     * lookupɃgCOꍇɃgCԊu[msec]擾B<p>
     *
     * @return gCԊu
     */
    public long getRetryInterval();
    
    /** 
     * lookupjavax.naming.NamingExceptionꍇɁAgCONXݒ肷B<p>
     * ftHǵA{@link #DEFAULT_RETRY_EXCXEPTION}B<br>
     *
     * @param classes gCONXz
     */
    public void setRetryExceptionClasses(Class<Throwable>[] classes);
    
    /** 
     * lookupjavax.naming.NamingExceptionꍇɁAgCONX擾B<p>
     *
     * @return gCONXz
     */
    public Class<Throwable>[] getRetryExceptionClasses();
    
    /**
     * JNDIT[o̐`FbNsǂݒ肷B<p>
     * trueɐݒ肳ꂽꍇA{@link #setAliveCheckJNDIServerInterval(long)}Őݒ肳ꂽԊuŁA[gReLXgi"/"jlookupāAJNDIT[o̐`FbNsB<br>
     * [gReLXg擾łȂȂꍇAG[Oo͂āALbVNAB܂A[gReLXg擾ł悤ɂȂꍇAʒmOo͂B<br>
     *
     * @param isCheck `FbNsꍇtrue
     */
    public void setAliveCheckJNDIServer(boolean isCheck);
    
    /**
     * JNDIT[o̐`FbNsǂݒ肷B<p>
     *
     * @return `FbNsꍇtrue
     */
    public boolean isAliveCheckJNDIServer();
    
    /**
     * JNDIT[o̐`FbNsԊu[msec]ݒ肷B<p>
     * ftHǵA60000[msec]B
     * 
     * @param interval JNDIT[o̐`FbNsԊu[msec]
     */
    public void setAliveCheckJNDIServerInterval(long interval);
    
    /**
     * JNDIT[o̐`FbNsԊu[msec]擾B<p>
     * 
     * @return JNDIT[o̐`FbNsԊu[msec]
     */
    public long getAliveCheckJNDIServerInterval();
    
    /**
     * JNDIT[oĂ邩ǂ𒲂ׂB<p>
     * {@link #isAliveCheckJNDIServer()}trueԂꍇ́AŌɃ`FbN̏ԂԂB<br>
     * isAliveCheckJNDIServer()falseԂꍇ́AɃ`FbNČʂԂBAAT[rXJnĂȂꍇ́AfalseԂB<br>
     * 
     * @return JNDIT[oĂꍇtrue
     */
    public boolean isAliveJNDIServer();
    
    /**
     * JNDIT[o_Em|̃Oo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput Oo͂ꍇtrue
     */
    public void setLoggingDeadJNDIServer(boolean isOutput);
    
    /**
     * JNDIT[o_Em|̃Oo͂邩ǂ𔻒肷B<p>
     *
     * @return Oo͂ꍇtrue
     */
    public boolean isLoggingDeadJNDIServer();
    
    /**
     * JNDIT[oAm|̃Oo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput Oo͂ꍇtrue
     */
    public void setLoggingRecoverJNDIServer(boolean isOutput);
    
    /**
     * JNDIT[oAm|̃Oo͂邩ǂ𔻒肷B<p>
     *
     * @return Oo͂ꍇtrue
     */
    public boolean isLoggingRecoverJNDIServer();
    
    /**
     * JNDIT[o_Em|̃Oo͂̃bZ[WIDݒ肷B<p>
     * ftHǵA{@link #JNDI_SERVER_DEAD_MSG_ID}B<br>
     *
     * @param id Oo͂̃bZ[WID
     */
    public void setDeadJNDIServerLogMessageId(String id);
    
    /**
     * JNDIT[o_Em|̃Oo͂̃bZ[WID擾B<p>
     *
     * @return Oo͂̃bZ[WID
     */
    public String getDeadJNDIServerLogMessageId();
    
    /**
     * JNDIT[oAm|̃Oo͂̃bZ[WIDݒ肷B<p>
     * ftHǵA{@link #JNDI_SERVER_RECOVER_MSG_ID}B<br>
     *
     * @param id Oo͂̃bZ[WID
     */
    public void setRecoverJNDIServerLogMessageId(String id);
    
    /**
     * JNDIT[oAm|̃Oo͂̃bZ[WID擾B<p>
     *
     * @return Oo͂̃bZ[WID
     */
    public String getRecoverJNDIServerLogMessageId();
    
    /**
     * LbV[gIuWFNgSăNAB<p>
     */
    public void clearCache();
    
    /**
     * w肵JNDÎ[gIuWFNg̃LbVNAB<p>
     * 
     * @param jndiName LbV폜郊[gIuWFNgJNDI
     */
    public void clearCache(String jndiName);
    
    public String listContext() throws NamingException;
}
