/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import jp.ossc.nimbus.core.*;

/**
 * {@link JMSMessageProducerFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see JMSMessageProducerFactoryService
 */
public interface JMSMessageProducerFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * {@link JMSSessionFactory}T[rX̃T[rXݒ肷B<p>
     * SessionCreatetruȅꍇAT[rX̊JnɁAŐݒ肳ꂽJMSSessionFactoryT[rXgāASession𐶐ێB<br>
     *
     * @param name JMSSessionFactoryT[rX̃T[rX
     */
    public void setJMSSessionFactoryServiceName(ServiceName name);
    
    /**
     * {@link JMSSessionFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSSessionFactoryT[rX̃T[rX
     */
    public ServiceName getJMSSessionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     * Őݒ肳ꂽJndiFinderT[rXgāAJNDIT[ojavax.jms.DestinationlookupB<br>
     *
     * @param name JndiFinderT[rX̃T[rX
     */
    public void setDestinationFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rX擾B<p>
     *
     * @return JndiFinderT[rX̃T[rX
     */
    public ServiceName getDestinationFinderServiceName();
    
    /**
     * ƂȂjavax.jms.DestinationJNDIݒ肷B<p>
     * DestinationFinderServiceNameŐݒ肳ꂽ{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rXgāAƂȂjavax.jms.DestinationAŐݒ肳ꂽJNDIlookupB<br>
     *
     * @param name ƂȂjavax.jms.DestinationJNDI
     */
    public void setDestinationName(String name);
    
    /**
     * ƂȂjavax.jms.DestinationJNDI擾B<p>
     *
     * @return ƂȂjavax.jms.DestinationJNDI
     */
    public String getDestinationName();
    
    /**
     * T[rX̊JnSession𐶐ĕێ邩ǂݒ肷B<p>
     * trueݒ肷ꍇAJMSSessionFactoryServiceNameݒ肵Ȃ΂ȂȂB<br>
     * ftHǵAfalseB<br>
     *
     * @param isCreate T[rX̊JnSession𐶐ĕێꍇtrue
     */
    public void setSessionCreate(boolean isCreate);
    
    /**
     * T[rX̊JnSession𐶐ĕێ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAT[rX̊JnSession𐶐ĕێ
     */
    public boolean isSessionCreate();
    
    /**
     * T[rX̒~SessionN[Y邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isClose T[rX̒~SessionN[Yꍇtrue
     */
    public void setCloseSession(boolean isClose);
    
    /**
     * T[rX̒~SessionN[Y邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAT[rX̒~SessionN[Y
     */
    public boolean isCloseSession();
}
