/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.distribute;

import java.util.List;

import jp.ossc.nimbus.core.*;

/**
 * {@link AbstractKeepAliveCheckerSelectorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see AbstractKeepAliveCheckerSelectorService
 */
public interface AbstractKeepAliveCheckerSelectorServiceMBean
 extends ServiceBaseMBean{
    
    public static final String DEFAULT_ALIVE_LOG_MSG_ID = "KACS_00001";
    public static final String DEFAULT_DEAD_LOG_MSG_ID = "KACS_00002";
    
    /**
     * I\{@link KeepAliveChecker}T[rX̃T[rXzݒ肷B<p>
     *
     * @param names I\{@link KeepAliveChecker}T[rX̃T[rXz
     */
    public void setSelectableCheckerServiceNames(ServiceName[] names);
    
    /**
     * I\{@link KeepAliveChecker}T[rX̃T[rXz擾B<p>
     *
     * @return I\{@link KeepAliveChecker}T[rX̃T[rXz
     */
    public ServiceName[] getSelectableCheckerServiceNames();
    
    /**
     * I{@link KeepAliveChecker}ɐmFsԊu[ms]ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́A₢킹sBAA{@link #setClusterServiceName(ServiceName)}w肵Ăꍇ́AB<br>
     * ftHgł́A₢킹sB<br>
     *
     * @param millis KeepAliveCheckerɐmFsԊu
     */
    public void setCheckInterval(long millis);
    
    /**
     * I{@link KeepAliveChecker}ɐmFsԊu[ms]擾B<p>
     *
     * @return KeepAliveCheckerɐmFsԊu
     */
    public long getCheckInterval();
    
    /**
     * {@link KeepAliveChecker}̉ғԂ~Ԃ瑖sԂɕωɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setAliveLogMessageId(String id);
    
    /**
     * {@link KeepAliveChecker}̉ғԂ~Ԃ瑖sԂɕωɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getAliveLogMessageId();
    
    /**
     * {@link KeepAliveChecker}̉ғԂsԂ~Ԃɕωɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setDeadLogMessageId(String id);
    
    /**
     * {@link KeepAliveChecker}̉ғԂsԂ~Ԃɕωɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getDeadLogMessageId();
    
    /**
     * {@link KeepAliveChecker}̉ғԂ~Ԃ瑖sԂɕωɃOo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputAliveLogMessage(boolean isOutput);
    
    /**
     * {@link KeepAliveChecker}̉ғԂ~Ԃ瑖sԂɕωɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputAliveLogMessage();
    
    /**
     * {@link KeepAliveChecker}̉ғԂsԂ~ԂɕωɃOo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputDeadLogMessage(boolean isOutput);
    
    /**
     * {@link KeepAliveChecker}̉ғԂsԂ~ԂɕωɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Ao͂
     */
    public boolean isOutputDeadLogMessage();
    
    /**
     * {@link KeepAliveCheckerSelector#getSelectableCheckers()}ŕԂ{@link KeepAliveChecker}̏ۂǂݒ肷B<p>
     * ftHǵAfalseŁAۂȂBғ~ғƂȂꍇAԍŌɕׂB<br>
     * 
     * @param isKeep ۂꍇ́Atrue
     */
    public void setKeepOrder(boolean isKeep);
    
    /**
     * {@link KeepAliveCheckerSelector#getSelectableCheckers()}ŕԂ{@link KeepAliveChecker}̏ۂǂ𔻒肷B<p>
     * 
     * @return truȅꍇ́Aۂ
     */
    public boolean isKeepOrder();
    
    /**
     * {@link ClusterService NX^}T[rX̃T[rXݒ肷B<p>
     * ̑ݒ肵ꍇ́A{@link KeepAliveChecker}NX^T[rX̃o[񂩂擾B<br>
     *
     * @param name NX^T[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link ClusterService NX^}T[rX̃T[rX擾B<p>
     *
     * @return NX^T[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * ݑI\ȐĂ{@link KeepAliveChecker}T[rX̃T[rXXg擾B<br>
     *
     * @return KeepAliveCheckerT[rX̃T[rXXg
     */
    public List<?> getAliveCheckers();
}
