/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

/**
 * Beant[B<p>
 *
 * @author M.Takata
 */
public interface BeanFlow{
    
    /**
     * Beant[̖̂擾B<p>
     * 
     * @return Beant[̖
     */
    public String getFlowName();
    
    /**
     * ㏑Beant[擾B<p>
     *
     * @return ㏑Beant[̔z
     */
    public String[] getOverrideFlowNames();
    
    /**
     * Beant[ĎIuWFNg𐶐B<p>
     *
     * @return Beant[ĎIuWFNg
     */
    public BeanFlowMonitor createMonitor();
    
    /**
     * Beant[sB<p>
     * 
     * @param obj Beant[ւ̈
     * @return Beant[̎s
     * @exception Exception Beant[̎sɗOꍇ
     */
    public Object execute(Object obj) throws Exception;
    
    /**
     * Beant[sB<p>
     * 
     * @param obj Beant[ւ̈
     * @param monitor j^[
     * @return Beant[̎s
     * @exception Exception Beant[̎sɗOꍇ
     */
    public Object execute(Object obj, BeanFlowMonitor monitor) throws Exception;
    
    /**
     * Beant[񓯊sB<p>
     * 
     * @param obj Beant[ւ̈
     * @param monitor j^[
     * @param isReply Kvȏꍇ́Atrue
     * @param maxAsynchWait ő񓯊sҋ@
     * @return Beant[̎sReLXg
     * @exception Exception Beant[̔񓯊sŗOꍇ
     */
    public Object executeAsynch(Object obj, BeanFlowMonitor monitor, boolean isReply, int maxAsynchWait) throws Exception;
    
    /**
     * Beant[̔񓯊šʂ擾B<p>
     * 
     * @param context Beant[̎sReLXg
     * @param monitor j^[
     * @param timeout ^CAEg[ms]B-1w肵ꍇ́A҂
     * @param isCancel ^CAEgɔ񓯊sLZ邩ǂBtruew肵ꍇ́ALZ
     * @return Beant[̔񓯊s
     * @exception BeanFlowAsynchTimeoutException w肳ꂽ^CAEg߂ĂȂꍇ
     * @exception Exception Beant[̎sɗOꍇ
     */
    public Object getAsynchReply(Object context, BeanFlowMonitor monitor, long timeout, boolean isCancel) throws BeanFlowAsynchTimeoutException, Exception;
    
    /**
     * Beant[񓯊sB<p>
     * 
     * @param obj Beant[ւ̈
     * @param monitor j^[
     * @param callback R[obN
     * @param maxAsynchWait ő񓯊sҋ@
     * @return Beant[̎sReLXg
     * @exception Exception Beant[̔񓯊sŗOꍇ
     */
    public Object executeAsynch(Object obj, BeanFlowMonitor monitor, BeanFlowAsynchCallback callback, int maxAsynchWait) throws Exception;
    
    /**
     * IB<p>
     */
    public void end();
}