/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;
import java.util.Properties;

import jp.ossc.nimbus.core.*;

/**
 * {@link ThreadContextInitializeInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ThreadContextInitializeInterceptorService
 */
public interface ThreadContextInitializeInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * XbhPʂ{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * XbhPʂ{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * R[h}X^{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邽߂{@link jp.ossc.nimbus.service.codemaster.CodeMasterFinder CodeMasterFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name CodeMasterFinderT[rX̃T[rX
     * @see ThreadContextKey#CODEMASTER
     */
    public void setCodeMasterFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.codemaster.CodeMasterFinder CodeMasterFinder}T[rX̃T[rX擾B<p>
     *
     * @return CodeMasterFinderT[rX̃T[rX
     */
    public ServiceName getCodeMasterFinderServiceName();
    
    /**
     * NGXgID{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邽߂{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SequenceT[rX̃T[rX
     * @see ThreadContextKey#REQUEST_ID
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rX擾B<p>
     *
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷T[rXݒ肷B<p>
     *
     * @param names ContextT[rXɐݒ肷L[ƃT[rX̃T[rX̃}bsOBReLXgL[=T[rX
     */
    public void setContextValueServiceNames(Map<String, String> names);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷T[rX擾B<p>
     *
     * @return ContextT[rXɐݒ肷L[ƃT[rX̃T[rX̃}bsO
     */
    public Map<String, String> getContextValueServiceNames();
    
    /**
     * NGXgp[^{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷}bsOݒ肷B<p>
     *
     * @param map ContextT[rXɐݒ肷L[ƃNGXgp[^̃}bsOBReLXgL[=NGXgp[^
     */
    public void setContextValueRequestParameter(Properties map);
    
    /**
     * NGXgp[^{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷}bsO擾B<p>
>
     *
     * @return ContextT[rXɐݒ肷L[ƃNGXgp[^̃}bsO
     */
    public Properties getContextValueRequestParameter();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷lݒ肷B<p>
     *
     * @param mapping ContextT[rXɐݒ肷L[ƒl̃}bsOBReLXgL[=l
     */
    public void setContextValueMapping(Map<String, Object> mapping);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷l擾B<p>
     *
     * @return ContextT[rXɐݒ肷L[ƒl̃}bsO
     */
    public Map<String, Object> getContextValueMapping();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷L[ƒlݒ肷B<p>
     *
     * @param key L[
     * @param value l
     */
    public void setContextValue(String key, Object value);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷l擾B<p>
     *
     * @param key L[
     * @return l
     */
    public Object getContextValue(String key);
    
    /**
     * ReLXgpX{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput ContextT[rXɐݒ肷ꍇtrue
     * @see ThreadContextKey#CONTEXT_PATH
     */
    public void setOutputContextPath(boolean isOutput);
    
    /**
     * ReLXgpX{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAContextT[rXɐݒ肷
     */
    public boolean isOutputContextPath();
    
    /**
     * T[ubgpX{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput ContextT[rXɐݒ肷ꍇtrue
     * @see ThreadContextKey#SERVLET_PATH
     */
    public void setOutputServletPath(boolean isOutput);
    
    /**
     * T[ubgpX{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAContextT[rXɐݒ肷
     */
    public boolean isOutputServletPath();
    
    /**
     * ZbVID{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput ContextT[rXɐݒ肷ꍇtrue
     * @see ThreadContextKey#SESSION_ID
     */
    public void setOutputSessionID(boolean isOutput);
    
    /**
     * ZbVID{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAContextT[rXɐݒ肷
     */
    public boolean isOutputSessionID();
    
    /**
     * XbhO[v{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput ContextT[rXɐݒ肷ꍇtrue
     * @see ThreadContextKey#THREAD_GROUP_NAME
     */
    public void setOutputThreadGroupName(boolean isOutput);
    
    /**
     * XbhO[v{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAContextT[rXɐݒ肷
     */
    public boolean isOutputThreadGroupName();
    
    /**
     * Xbh{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput ContextT[rXɐݒ肷ꍇtrue
     * @see ThreadContextKey#THREAD_NAME
     */
    public void setOutputThreadName(boolean isOutput);
    
    /**
     * Xbh{@link jp.ossc.nimbus.service.context.Context Context}T[rXɐݒ肷邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAContextT[rXɐݒ肷
     */
    public boolean isOutputThreadName();
    
    /**
     * ZbV̏擾邽߂ɃZbV݂Ȃꍇ́AZbV𐶐邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isNew ZbV𐶐ꍇ́Atrue
     */
    public void setNewSession(boolean isNew);
    
    /**
     * ZbV̏擾邽߂ɃZbV݂Ȃꍇ́AZbV𐶐邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAZbV𐶐
     */
    public boolean isNewSession();
    
    /**
     * ċAIɌĂяoꂽꍇɁAXbhReLXg̏sǂݒ肷B<p>
     * ftHgtrueŏB<br>
     *
     * @param isInitialize ꍇ́Atrue
     */
    public void setInitializeRecursiveCall(boolean isInitialize);
    
    /**
     * ċAIɌĂяoꂽꍇɁAXbhReLXg̏sǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A
     */
    public boolean isInitializeRecursiveCall();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX{@link jp.ossc.nimbus.service.context.Context#clear() clear()}Ăяoǂݒ肷B<br>
     * ftHǵAtrueclearB<br>
     *
     * @param isClear clearꍇ́Atrue
     */
    public void setClear(boolean isClear);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX{@link jp.ossc.nimbus.service.context.Context#clear() clear()}Ăяoǂ𔻒肷B<br>
     *
     * @return truȅꍇ́Aclear
     */
    public boolean isClear();
}
