/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.*;
import javax.servlet.*;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.context.*;

/**
 * NGXgC^[Zv^B<p>
 *
 * @author M.Takata
 */
public class ServletRequestInitializeInterceptorService
 extends ServletFilterInterceptorService
 implements ServletRequestInitializeInterceptorServiceMBean{
    
    private static final long serialVersionUID = 2753369702347163943L;
    
    protected ServiceName contextServiceName;
    protected Context<Object, Object> context;
    protected String[] contextKeys;
    protected Map<String, Object> attributes;
    protected Map<String, String> requestAttributeServiceNames;
    protected Map<String, ServiceName> requestAttributeServiceNameMap;
    protected boolean isThrowServiceNotFoundException = true;
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public void setContextServiceName(ServiceName name){
        contextServiceName = name;
    }
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public ServiceName getContextServiceName(){
        return contextServiceName;
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public void setContextKeys(String[] keys){
        contextKeys = keys;
    }
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public String[] getContextKeys(){
        return contextKeys;
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public void setRequestAttributeServiceNames(Map<String, String> names){
        requestAttributeServiceNames = names;
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public Map<String, String> getRequestAttributeServiceNames(){
        return requestAttributeServiceNames;
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public void setRequestAttributes(Map<String, Object> attrs){
        attributes.putAll(attrs);
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public Map<String, Object> getRequestAttributes(){
        return attributes;
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public void setRequestAttribute(String name, Object attr){
        attributes.put(name, attr);
    }
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public Object getRequestAttribute(String name){
        return attributes.get(name);
    }
    
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public boolean isThrowServiceNotFoundException(){
        return isThrowServiceNotFoundException;
    }
    // ServletRequestInitializeInterceptorServiceMBeanJavaDoc
    public void setThrowServiceNotFoundException(boolean isThrow){
        isThrowServiceNotFoundException = isThrow;
    }
    
    /**
     * T[rX̐sB<p>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    public void createService() throws Exception{
        attributes = new HashMap<String, Object>();
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(contextServiceName != null){
            context = ServiceManagerFactory
                .getServiceObject(contextServiceName);
        }
        if(requestAttributeServiceNames != null){
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(getServiceManagerName());
            requestAttributeServiceNameMap = new HashMap<String, ServiceName>();
            for(Map.Entry<String, String> entry : requestAttributeServiceNames.entrySet()){
                editor.setAsText(entry.getValue());
                requestAttributeServiceNameMap.put(entry.getKey(), (ServiceName)editor.getValue());
            }
        }
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    public void destroyService() throws Exception{
        attributes = null;
    }
    
    /**
     * NGXgāÃC^[Zv^ĂяoB<p>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invokeFilter(
        ServletFilterInvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() == State.STARTED){
            
            final ServletRequest request = context.getServletRequest();
            if(context != null && contextKeys != null){
                for(int i = 0; i < contextKeys.length; i++){
                    request.setAttribute(
                        contextKeys[i],
                        this.context.get(contextKeys[i])
                    );
                }
            }
            if(attributes != null && attributes.size() != 0){
                for(Map.Entry<String, Object> entry : attributes.entrySet()){
                    final String name = entry.getKey();
                    request.setAttribute(
                        name,
                        entry.getValue()
                    );
                }
            }
            if(requestAttributeServiceNameMap != null){
                for(Map.Entry<String, ServiceName> entry : requestAttributeServiceNameMap.entrySet()){
                    try{
                        request.setAttribute(
                            entry.getKey(),
                            ServiceManagerFactory.getServiceObject(
                                entry.getValue()
                            )
                        );
                    }catch(ServiceNotFoundException e){
                        if(isThrowServiceNotFoundException){
                            throw e;
                        }
                    }
                }
            }
        }
        return chain.invokeNext(context);
    }
}
