/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import jp.ossc.nimbus.core.*;

/**
 * {@link ServletRequestExchangeInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ServletRequestExchangeInterceptorService
 */
public interface ServletRequestExchangeInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * ftHg̗vIuWFNg̃NGXgB<p>
     */
    public static final String DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME = StreamExchangeInterceptorService.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    
    /**
     * ftHg̗vIuWFNg̃ReLXgL[B<p>
     */
    public static final String DEFAULT_REQUEST_OBJECT_CONTEXT_KEY = StreamExchangeInterceptorService.DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;
    
    /**
     * ftHg̃W[ĩ[gXebvB<p>
     */
    public static final String DEFAULT_EXCHANGE_JOURNAL_KEY = "Exchange";
    
    /**
     * ftHg̃W[i̗vIuWFNgvfB<p>
     */
    public static final String DEFAULT_REQUEST_OBJECT_JOURNAL_KEY = "RequestObject";
    
    /**
     * ftHg̃W[i̗OvfB<p>
     */
    public static final String DEFAULT_EXCEPTION_JOURNAL_KEY = "Exception";
    
    /**
     * T[ubgNGXgvIuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.Converter Converter}T[rXݒ肷B<p>
     *
     * @param name ConverterT[rX
     */
    public void setConverterServiceName(ServiceName name);
    
    /**
     * T[ubgNGXgvIuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.Converter Converter}T[rX擾B<p>
     *
     * @return ConverterT[rX
     */
    public ServiceName getConverterServiceName();
    
    /**
     * vIuWFNg悹{@link jp.ossc.nimbus.service.context.Context Context}T[rXݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́ANGXĝ݂ɏ悹B<br>
     *
     * @param name ContextT[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * vIuWFNg悹{@link jp.ossc.nimbus.service.context.Context Context}T[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rXݒ肷B<p>
     *
     * @param name JournalT[rX
     */
    public void setJournalServiceName(ServiceName name);
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX擾B<p>
     *
     * @return JournalT[rX
     */
    public ServiceName getJournalServiceName();
    
    /**
     * W[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX
     */
    public void setExchangeEditorFinderServiceName(ServiceName name);
    
    /**
     * W[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX擾B<p>
     *
     * @return EditorFinderT[rX
     */
    public ServiceName getExchangeEditorFinderServiceName();
    
    /**
     * W[ĩ[gXebṽL[ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_EXCHANGE_JOURNAL_KEY}B<br>
     *
     * @param key L[
     * @see #DEFAULT_EXCHANGE_JOURNAL_KEY
     */
    public void setExchangeJournalKey(String key);
    
    /**
     * W[ĩ[gXebṽL[擾B<p>
     *
     * @return L[
     */
    public String getExchangeJournalKey();
    
    /**
     * W[i̗vIuWFNg̃L[ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_REQUEST_OBJECT_JOURNAL_KEY}B<br>
     *
     * @param key L[
     * @see #DEFAULT_REQUEST_OBJECT_JOURNAL_KEY
     */
    public void setRequestObjectJournalKey(String key);
    
    /**
     * W[i̗vIuWFNg̃L[擾B<p>
     *
     * @return L[
     */
    public String getRequestObjectJournalKey();
    
    /**
     * W[i̗ÕL[ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_EXCEPTION_JOURNAL_KEY}B<br>
     *
     * @param key L[
     * @see #DEFAULT_EXCEPTION_JOURNAL_KEY
     */
    public void setExceptionJournalKey(String key);
    
    /**
     * W[i̗ÕL[擾B<p>
     *
     * @return L[
     */
    public String getExceptionJournalKey();
    
    /**
     * vIuWFNgNGXgɐݒ肷鎞Ɏgp鑮ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME}B<br>
     *
     * @param name 
     * @see #DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME
     */
    public void setRequestObjectAttributeName(String name);
    
    /**
     * vIuWFNgNGXgɐݒ肷鎞Ɏgp鑮擾B<p>
     *
     * @return 
     */
    public String getRequestObjectAttributeName();
    
    /**
     * vIuWFNgReLXgɐݒ肷鎞ɎgpL[ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_REQUEST_OBJECT_CONTEXT_KEY}B<br>
     *
     * @param key L[
     * @see #DEFAULT_REQUEST_OBJECT_CONTEXT_KEY
     */
    public void setRequestObjectContextKey(String key);
    
    /**
     * vIuWFNgReLXgɐݒ肷鎞ɎgpL[擾B<p>
     *
     * @return L[
     */
    public String getRequestObjectContextKey();
}