/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link FlowControlInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see FlowControlInterceptorService
 */
public interface FlowControlInterceptorServiceMBean extends ServiceBaseMBean{
    
    /**
     * Z}tHT[rX̃T[rXݒ肷B<p>
     *
     * @param name Z}tHT[rX̃T[rX
     */
    public void setSemaphoreServiceName(ServiceName name);
    
    /**
     * Z}tHT[rX̃T[rX擾B<p>
     * 
     * @return Z}tHT[rX̃T[rX
     */
    public ServiceName getSemaphoreServiceName();
    
    /**
     * Z}tHl҂^CAEgݒ肷B<p>
     * 0ȉ̒lݒ肷ƖɃZ}tHl҂BftHǵA-1B
     *
     * @param timeout ^CAEg[ms]
     */
    public void setTimeout(long timeout);
    
    /**
     * Z}tHl҂^CAEg擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getTimeout();
    
    /**
     * Z}tHl҂ő吔ݒ肷B<p>
     * 0ȉ̒lݒ肷ƃZ}tHl҂𐧌ȂBftHǵA-1B
     *
     * @param count Z}tHl҂ő吔
     */
    public void setMaxWaitingCount(int count);
    
    /**
     * Z}tHl҂ő吔擾B<p>
     *
     * @return Z}tHl҂ő吔
     */
    public int getMaxWaitingCount();
    
    /**
     * Z}tHl̋Z}tHJ[ms]ݒ肷B<p>
     * 0ȉ̒lݒ肷ƋZ}tHJsȂBftHǵA-1B
     *
     * @param timeout Z}tHJ
     */
    public void setForceFreeTimeout(long timeout);
    
    /**
     * Z}tHl̋Z}tHJ[ms]擾B<p>
     *
     * @return Z}tHJ
     */
    public long getForceFreeTimeout();
    
    /**
     * Z}tHlɎsꍇɗOthrow邩ǂݒ肷B<p>
     * ftHgtrueB
     * 
     * @param isThrow Z}tHlɎsꍇɗOthrowꍇtrue
     */
    public void setFailToObtainSemaphore(boolean isThrow);
    
    /**
     * Z}tHlɎsꍇɗOthrow邩ǂ𔻒肷B<p>
     * 
     * @return Z}tHlɎsꍇɗOthrowꍇtrue
     */
    public boolean isFailToObtainSemaphore();
}
