/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link ContextExportInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ContextExportInterceptorService
 */
public interface ContextExportInterceptorServiceMBean extends ServiceBaseMBean{
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}̏i[}bv{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑ƂĐݒ肷鎞̑̃ftHglB<p>
     * ftHgȊO̒lgpꍇ́A{@link #setAttributeName(String)}Őݒ肷B<br>
     * 
     * @see #setAttributeName(String)
     */
    public static final String DEFAULT_ATTRIBUTE_NAME
         = ContextExportInterceptorService.class.getName() + ".Context";
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}̏i[}bv{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑ƂĐݒ肷鎞̑ݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AftHgƂāA{@link #DEFAULT_ATTRIBUTE_NAME}gpB<p>
     *
     * @param name GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}̏i[}bv{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑ƂĐݒ肷鎞̑
     * @see #DEFAULT_ATTRIBUTE_NAME
     */
    public void setAttributeName(String name);
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}̏i[}bv{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑ƂĐݒ肷鎞̑擾B<p>
     *
     * @return GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}̏i[}bv{@link jp.ossc.nimbus.service.aop.InvocationContext InvocationContext}̑ƂĐݒ肷鎞̑
     */
    public String getAttributeName();
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃L[zݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́AContextɊi[ꂽSĂ̏񂪃GNX|[gB<br>
     *
     * @param keys GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃L[z
     */
    public void setContextKeys(String[] keys);
    
    /**
     * GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃L[z擾B<p>
     *
     * @return GNX|[g{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃L[z
     */
    public String[] getContextKeys();
}
