/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * RXgN^`&lt;constructor&gt;vf^f[^B<p>
 * T[rX`t@C&lt;constructor&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class ConstructorMetaData extends MetaData
 implements Serializable{
    
    private static final long serialVersionUID = 1385893693509473372L;
    
    /**
     * &lt;constructor&gt;vf̗vfB<p>
     */
    public static final String CONSTRUCTOR_TAG_NAME = "constructor";
    
    /**
     * qvf&lt;invoke&gt;\^f[^B<p>
     */
    protected InvokeMetaData invoke;
    
    /**
     * qvf&lt;static-invoke&gt;\^f[^B<p>
     */
    protected StaticInvokeMetaData staticInvoke;
    
    /**
     * qvf&lt;static-field=ref&gt;\^f[^B<p>
     */
    protected StaticFieldRefMetaData staticFieldRef;
    
    /**
     * qvf&lt;argument&gt;i[郊XgB<p>
     */
    protected final List<ArgumentMetaData> arguments = new ArrayList<ArgumentMetaData>();
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public ConstructorMetaData(ObjectMetaData parent){
        super(parent);
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;invoke&gt;vf\{@link InvokeMetaData}擾B<p>
     *
     * @return qvf&lt;invoke&gt;vf\InvokeMetaData
     */
    public InvokeMetaData getInvoke(){
        return invoke;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;invoke&gt;vf\{@link InvokeMetaData}ݒ肷B<p>
     *
     * @param data qvf&lt;invoke&gt;vf\InvokeMetaData
     */
    public void setInvoke(InvokeMetaData data){
        invoke = data;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;static-invoke&gt;vf\{@link StaticInvokeMetaData}擾B<p>
     *
     * @return qvf&lt;static-invoke&gt;vf\StaticInvokeMetaData
     */
    public StaticInvokeMetaData getStaticInvoke(){
        return staticInvoke;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;static-invoke&gt;vf\{@link StaticInvokeMetaData}ݒ肷B<p>
     *
     * @param data qvf&lt;static-invoke&gt;vf\StaticInvokeMetaData
     */
    public void setStaticInvoke(StaticInvokeMetaData data){
        staticInvoke = data;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;static-field-ref&gt;vf\{@link StaticInvokeMetaData}擾B<p>
     *
     * @return qvf&lt;static-field-ref&gt;vf\StaticFieldRefMetaData
     */
    public StaticFieldRefMetaData getStaticFieldRef(){
        return staticFieldRef;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;static-field-ref&gt;vf\{@link StaticFieldRefMetaData}ݒ肷B<p>
     *
     * @param data qvf&lt;static-field-ref&gt;vf\StaticFieldRefMetaData
     */
    public void setStaticFieldRef(StaticFieldRefMetaData data){
        staticFieldRef = data;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}̏W擾B<p>
     *
     * @return qvf&lt;argument&gt;vf\ArgumentMetaDatȁW
     */
    public List<ArgumentMetaData> getArguments(){
        return arguments;
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}ǉB<p>
     *
     * @param arg qvf&lt;argument&gt;vf\ArgumentMetaData
     */
    public void addArgument(ArgumentMetaData arg){
        arguments.add(arg);
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}폜B<p>
     *
     * @param arg qvf&lt;argument&gt;vf\ArgumentMetaData
     */
    public void removeArgument(ArgumentMetaData arg){
        arguments.remove(arg);
    }
    
    /**
     * &lt;constructor&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}Sč폜B<p>
     */
    public void clearArguments(){
        arguments.clear();
    }
    
    /**
     * &lt;constructor&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;constructor&gt;vfElement
     * @exception DeploymentException &lt;constructor&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        if(!element.getTagName().equals(CONSTRUCTOR_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + CONSTRUCTOR_TAG_NAME + " : "
                 + element.getTagName()
            );
            
        }
        
        final Element invokeElement = getOptionalChild(
            element,
            InvokeMetaData.INVOKE_TAG_NAME
        );
        if(invokeElement != null){
            final InvokeMetaData invokeData
                 = new InvokeMetaData(this);
            invokeData.importXML(invokeElement);
            if(invokeData.getTarget() == null){
                throw new DeploymentException("Target is null." + invokeData);
            }
            invoke = invokeData;
            return;
        }
        
        final Element staticInvokeElement = getOptionalChild(
            element,
            StaticInvokeMetaData.STATIC_INVOKE_TAG_NAME
        );
        if(staticInvokeElement != null){
            final StaticInvokeMetaData staticInvokeData
                 = new StaticInvokeMetaData(this);
            staticInvokeData.importXML(staticInvokeElement);
            staticInvoke = staticInvokeData;
            return;
        }
        
        final Element staticFieldRefElement = getOptionalChild(
            element,
            StaticFieldRefMetaData.STATIC_FIELD_REF_TAG_NAME
        );
        if(staticFieldRefElement != null){
            final StaticFieldRefMetaData staticFieldRefData
                 = new StaticFieldRefMetaData(this);
            staticFieldRefData.importXML(staticFieldRefElement);
            staticFieldRef = staticFieldRefData;
            return;
        }
        
        final Iterator<Element> argElements = getChildrenByTagName(
            element,
            ArgumentMetaData.ARGUMENT_TAG_NAME
        );
        while(argElements.hasNext()){
            final ArgumentMetaData argData
                 = new ArgumentMetaData(this, (ObjectMetaData)getParent());
            argData.importXML(argElements.next());
            addArgument(argData);
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(CONSTRUCTOR_TAG_NAME).append('>');
        if(arguments.size() != 0){
            buf.append(LINE_SEPARATOR);
            for(int i = 0, imax = arguments.size(); i < imax; i++){
                buf.append(
                    addIndent(arguments.get(i).toXML(new StringBuilder()))
                );
                buf.append(LINE_SEPARATOR);
            }
        }else{
            MetaData data = invoke;
            if(data == null){
                data = staticInvoke;
            }
            if(data == null){
                data = staticFieldRef;
            }
            if(data != null){
                buf.append(LINE_SEPARATOR);
                buf.append(
                    addIndent(data.toXML(new StringBuilder()))
                );
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append("</").append(CONSTRUCTOR_TAG_NAME).append('>');
        return buf;
    }
}
